/*
 * \file        dia_EcuResetPlugin.h
 *
 * \brief       {insert brief description here}
 *
 * \details     Send positive response immediately and don't care two things:
 *                1/ SPM could reset ECU before CAN driver will send response
 *                2/ SPM could call dia_SAFeatureSpmBase::vHandleSystemRestart before ECU reset
 *
 * \author      kaa1hi
 * \date        Apr 21, 2015
 *
 * \copyright   Robert Bosch Car Multimedia 2015
 */

#ifndef __INCLUDED_DIA_ECURESET_PLUGIN__
#define __INCLUDED_DIA_ECURESET_PLUGIN__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include <common/framework/protocols/uds/dia_ServiceHandlerUDS.h>
#endif

#include "dia_EcuReset.h"

class dia_EcuResetPlugin
{
public:
   //! class constructor
   dia_EcuResetPlugin (tCString name, dia_ResetType resetType);

   //! class destructor
   virtual ~dia_EcuResetPlugin ( void );

   //! return the name of the reset service handler
   virtual tCString getName ( void ) const { return mName.c_str(); }

   //! get the unique identifier of the ECU reset service handler
   virtual dia_UID getUID ( void ) const;

   //! get ECU reset type
   virtual dia_ResetType getResetType ( void ) const;

   //! get assigned DID
   virtual tU16 getDID ( void ) const { return static_cast<tU16>(mResetType); }

   //! handle the Reset request from the tester (implemented by concrete subclasses)
   //! @return DIA_FAILED if was not successful
   virtual tDiaResetResponse handleRequest ( void ) = 0;

   //! retrieve the value of the maximum processing time in ms
   virtual tU32 getMaxProcessingTime ( void ) const { return DIA_RESET_DEFAULT_PROCESSING_TIMEOUT; }

protected:
   //! deprecated default constructor
   dia_EcuResetPlugin ( std::string name );
   //! deprecated default constructor
   dia_EcuResetPlugin ( void );

protected:
   //! reset name
   std::string mName;
   //! unique reset identifier
   dia_UID mUID;
   //! reset type
   dia_ResetType mResetType;
};

#endif /* __INCLUDED_DIA_ECURESET_PLUGIN__ */
