/*
 * \file        dia_EcuResetManager.cpp
 *
 * \brief       {insert brief description here}
 *
 * \details     {insert file description here}
 *
 * \author      kaa1hi
 * \date        Apr 21, 2015
 *
 * \copyright   Robert Bosch Car Multimedia 2015
 */

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_IOCTRL_MANAGER__
#include <common/framework/protocols/uds/ecureset/dia_EcuResetManager.h>
#endif

#ifndef __INCLUDED_DIA_ECURESET_PLUGIN__
#include <common/framework/protocols/uds/ecureset/dia_EcuResetPlugin.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_ECU_RESET_LISTENER__
#include <common/interfaces/dia_IEcuResetListener.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __DIA_UNIT_TESTING__

dia_EcuResetManager*
getInstanceOfEcuResetManager ( void )
{
   return dia_EcuResetManager::getInstance();
}

void
releaseInstanceOfEcuResetManager ( void )
{
   return dia_EcuResetManager::deleteInstance();
}

#endif

// implementation of the singleton methods
DIA_IMPL_SINGLETON(dia_EcuResetManager)

//------------------------------------------------------------------------------

dia_EcuResetManager::dia_EcuResetManager ( void )
{
   dia_tclFnctTrace trc("dia_EcuResetManager::dia_EcuResetManager");
}

//------------------------------------------------------------------------------

dia_EcuResetManager::~dia_EcuResetManager ( void )
{
   _BP_TRY_BEGIN
   {
      mUIDResetRep.clear();
      mTypeResetRep.clear();
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_EcuResetManager::~dia_EcuResetManager !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//------------------------------------------------------------------------------

tDiaResult
dia_EcuResetManager::addReset ( dia_EcuResetPlugin* pEcuResetGenSrvHandler )
{
   dia_tclFnctTrace oTrace("dia_EcuResetManager::addReset()");

   if ( !pEcuResetGenSrvHandler ) return DIA_E_INVALID_POINTER;

   tDiaResult retCode = DIA_FAILED;

   dia_UID uid = pEcuResetGenSrvHandler->getUID();
   dia_ResetType resetType = pEcuResetGenSrvHandler->getResetType();

   std::map<dia_UID,dia_EcuResetPlugin*>::iterator iter = mUIDResetRep.find(uid);
   if ( iter == mUIDResetRep.end() )
   {
      mUIDResetRep[uid] = pEcuResetGenSrvHandler;
      mTypeResetRep[resetType] = pEcuResetGenSrvHandler;
      retCode = DIA_SUCCESS;

      DIA_TR_INF("dia_EcuResetManager::addReset srv handler added (UID=0x%08X, resetType=%d)", uid, resetType);
   }
   else
   {
      DIA_TR_ERR("#### dia_EcuResetManager::addReset UID=0x%08X already exists", uid);
   }

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_EcuResetManager::removeReset ( dia_UID uid )
{
   dia_tclFnctTrace oTrace("dia_EcuResetManager::removeSignal()");

   tDiaResult retCode = DIA_E_NOT_FOUND;

   std::map<dia_UID,dia_EcuResetPlugin*>::iterator itUID = mUIDResetRep.find(uid);
   if ( itUID != mUIDResetRep.end() )
   {
      if (NULL!=itUID->second)
      {
         dia_ResetType resType = itUID->second->getResetType();

         DIA_TR_INF("dia_EcuResetManager::removeReset uid=0x%08X resType=0x%08X", uid, resType);

         std::map<dia_ResetType,dia_EcuResetPlugin*>::iterator itType = mTypeResetRep.find(resType);

         if ( itType != mTypeResetRep.end() )
         {
            mUIDResetRep.erase(itUID);
            mTypeResetRep.erase(itType);
            retCode = DIA_SUCCESS;
         }
         else
         {
            DIA_TR_ERR("#### dia_EcuResetManager::removeReset resType=0x%08X not found", resType);
         }
      }
      else
      {
         DIA_TR_ERR("#### dia_EcuResetManager::removeReset UID=0x%08X NULL ptr in map", uid);
      }
   }
   else
   {
      DIA_TR_ERR("#### dia_EcuResetManager::removeReset UID=0x%08X not found", uid);
   }

   return retCode;
}

//------------------------------------------------------------------------------

tU16
dia_EcuResetManager::numberOfResets ( void ) const
{
   return (tU16) mUIDResetRep.size();
}

//-----------------------------------------------------------------------------

const std::map<dia_UID, dia_EcuResetPlugin*>&
dia_EcuResetManager::getUIDResetSrvHandlers ( void ) const
{
   return mUIDResetRep;
}

dia_EcuResetPlugin*
dia_EcuResetManager::getResetSrvHandler ( dia_UID uid ) const
{
   dia_tclFnctTrace oTrace("dia_EcuResetManager::getResetSrvHandler(dia_UID)");

   std::map<dia_UID,dia_EcuResetPlugin*>::const_iterator iter = mUIDResetRep.find(uid);
   if ( iter != mUIDResetRep.end() )
   {
      return iter->second;
   }
   else
   {
      DIA_TR_ERR("dia_EcuResetManager::getResetSrvHandler uid=0x%08X not found, return NULL.", uid);
      return NULL;
   }
}

dia_EcuResetPlugin*
dia_EcuResetManager::getResetSrvHandler ( dia_ResetType resetType ) const
{
   dia_tclFnctTrace oTrace("dia_EcuResetManager::getResetSrvHandler(dia_ResetType)");

   std::map<dia_ResetType,dia_EcuResetPlugin*>::const_iterator iter = mTypeResetRep.find(resetType);
   if ( iter != mTypeResetRep.end() )
   {
      return iter->second;
   }
   else
   {
      DIA_TR_ERR("dia_EcuResetManager::getResetSrvHandler resetType=0x%02X not found, return NULL.", resetType);
      return NULL;
   }
}

//-----------------------------------------------------------------------------

void
dia_EcuResetManager::vOnEcuResetUpdate ( dia_EcuResetPlugin* pEcuResetPlugin, tDiaResult result ) const
{
   dia_tclFnctTrace oTrace("dia_EcuResetManager::vOnEcuResetUpdate()");

   if (NULL==pEcuResetPlugin)
   {
      DIA_TR_ERR("####### !!! pEcuResetPlugin is NULL !!! #######");
      return;
   }

   DIA_TR_INF("###########################################");
   DIA_TR_INF("#");
   DIA_TR_INF("# vOnEcuResetUpdate !!");
   DIA_TR_INF("#");
   DIA_TR_INF("# NAME = %s",            pEcuResetPlugin->getName());
   DIA_TR_INF("# UID   = 0x%08X",       pEcuResetPlugin->getUID());
   DIA_TR_INF("# RESETTYPE = 0x%02X",   pEcuResetPlugin->getResetType());
   DIA_TR_INF("#");
   DIA_TR_INF("###########################################");

   dia_IEcuResetListener* pListener = OSAL_NULL;
   querySysAdapterListener<dia_IEcuResetListener>(&pListener);
   if ( pListener )
   {
      DIA_TR_INF("dia_EcuResetManager::vOnEcuResetUpdate pListener is not NULL.");
      pListener->vOnEcuResetUpdate(pEcuResetPlugin, result);
   }
   else
   {
      DIA_TR_ERR("########### dia_EcuResetManager::vOnEcuResetUpdate pListener is NULL ########### ");
   }
}
