/*
 * dia_MultipleReadDataByIDHandler.h
 *
 *  Created on: 22.07.2015
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_MULTIPLE_READ_DATA_BY_ID_HANDLER__
#define __INCLUDED_DIA_MULTIPLE_READ_DATA_BY_ID_HANDLER__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_MESSAGEHANDLER__
#include <common/framework/engine/dia_MessageHandler.h>
#endif

#ifndef __INCLUDED_DIA_MULTIPLEREADFSM__
#include <common/framework/fsm/generated/dia_MultipleReadFSM.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_TIMER_LISTENER__
#include <common/interfaces/dia_ITimerListener.h>
#endif

class dia_MessageBuffer;

class dia_MultipleReadDataByIDHandler
   : public dia_MessageHandler,
     public dia_MultipleReadFSM::FsmBehaviour,
     public dia_ITimerListener
{
   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_MultipleReadDataByIDHandler);
public:
   struct dia_DIDWorkItem
   {
      dia_DIDWorkItem ( tU16 did );

      tU16 mDID;
      std::vector<tU8> mResponse;
   };

public:
   //! class constructor
   dia_MultipleReadDataByIDHandler ( void );
   //! class constructor with next hanndler passed
   dia_MultipleReadDataByIDHandler ( dia_MessageHandler* nextHandler );
   //! class destructor
   virtual ~dia_MultipleReadDataByIDHandler ( void );

   //! list of work items (DIDs) to be processed
   const std::list<dia_DIDWorkItem*>& getWorkItems ( void ) const { return mWorkItems; }
   //! list of processed work items containing the work item response
   const std::list<dia_DIDWorkItem*>& getPocessedWorkItems ( void ) const { return mPocessedWorkItems; }

   //! method to be implemented by concrete handlers for processing incoming messages. Return value of DIA_SUCCESS indicates that the message was handled within the chain of handlers
   virtual tDiaResult handleMessage ( dia_MessageBuffer& msg );

   //! overloaded method from class dia_ITimerListener
   virtual void vOnTimerElapsed ( dia_TimerID id );

   //! callback method used by DID read service handlers
   static void onDIDResponse ( const tU8 au8MsgBuffer[], tU16 u16Length, tCookieType cookie );

protected:
   //! setup method for the application
   virtual tDiaResult setup ( void );
   //! shutdown method for the application
   virtual tDiaResult tearDown ( void );

   void clearWorkItems ( void );
   void clearProcessedWorkItems ( void );

   // FSM actions
   virtual void vFsmEvaluateResponse ( boost::any& pArg );
   virtual void vFsmPrepareProcessing ( boost::any& pArg );
   virtual void vFsmProcessDID ( boost::any& pArg );
   virtual void vFsmReset ( boost::any& pArg );
   virtual void vFsmSendResponse ( boost::any& pArg );
   virtual void vFsmSetErrCode_Timeout ( boost::any& pArg );
   virtual void vFsmSetNextDID ( boost::any& pArg );
   virtual void vFsmStartProcessingTimer ( boost::any& pArg );
   virtual void vFsmStopProcessingTimer ( boost::any& pArg );

   // FSM guards
   virtual bool bIsProcessingComplete ( boost::any& pArg );

   void vSendPositiveResponse ( dia_MessageBuffer* pMsgBuffer, const std::vector<tU8>& dataVec ) const;

protected:
   //!
   bool mIsSetupDone;
   //! generated state machine
   dia_MultipleReadFSM::Fsm* mpFSM; //lint -sem(dia_MultipleReadDataByIDHandler::tearDown,cleanup)
   //! timer used when rolling out a system setting
   dia_Timer mTimer;
   //! processing timeout value
   tU32 mProcessingTimeout;
   //! internal
   tDiaResult mErrorCode;
   //! active diagnosis request
   dia_MessageBuffer* mpActiveMessageBuffer;
   //! number of DIDs extracted from original UDS request
   tU16 mNumOfDIDs;
   //! currently processed work item
   dia_DIDWorkItem* mpActiveWorkItem;
   //! list of work items (DIDs) to be processed
   std::list<dia_DIDWorkItem*> mWorkItems;
   //! list of processed work items containing the work item response
   std::list<dia_DIDWorkItem*> mPocessedWorkItems;
};

#endif /* __INCLUDED_DIA_MULTIPLE_READ_DATA_BY_ID_HANDLER__ */
