/*
 * dia_MessageBufferUDS.cpp
 *
 *  Created on: 14.05.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER_UDS__
#include "common/framework/protocols/uds/dia_MessageBufferUDS.h"
#endif

//-----------------------------------------------------------------------------

dia_MessageBufferUDS::dia_MessageBufferUDS (
      const tU8 byteBuffer[],
      tU16 length,
      tFuncSendResponse  funcResponseSend,
      enBufferState  enState,
      enBufferFormat enFormat,
      tCookieType cookie
   )
   : dia_MessageBuffer(byteBuffer,length,funcResponseSend,DIA_EN_PROTOCOL_UDS,enState,enFormat,cookie)
{
   dia_tclFnctTrace trc("dia_MessageBufferUDS::dia_MessageBufferUDS");
}

//-----------------------------------------------------------------------------

dia_MessageBufferUDS::dia_MessageBufferUDS (
      const std::vector<tU8>& byteBuffer,
      tFuncSendResponse  funcResponseSend,
      enBufferState  enState,
      enBufferFormat enFormat,
      tCookieType cookie
   )
   : dia_MessageBuffer(byteBuffer,funcResponseSend,DIA_EN_PROTOCOL_UDS,enState,enFormat,cookie)
{
   dia_tclFnctTrace trc("dia_MessageBufferUDS::dia_MessageBufferUDS");
}

//-----------------------------------------------------------------------------

dia_MessageBufferUDS::~dia_MessageBufferUDS ( void )
{
}

//-----------------------------------------------------------------------------

void
dia_MessageBufferUDS::vSetNegResp ( tU8 negRespCode )
{
   dia_tclFnctTrace trc("dia_MessageBufferUDS::vSetNegResp");

   //prepare neg. response
   mBufferSize = 3;
   tU8* const pNewBuffer = OSAL_NEW tU8[mBufferSize];

   if(NULL != pNewBuffer)
   {
      pNewBuffer[0] = 0x7F;
      int pos = ( mFormat == format_length_and_data ) ? 1 : 0;
      pNewBuffer[1] = (mState == holds_response)? mpBuffer[pos]^udsPosRespMask : mpBuffer[pos]; //SID
      pNewBuffer[2] = negRespCode;

      OSAL_DELETE [] mpBuffer;

      mpBuffer = pNewBuffer;
      mState = holds_response;
   }
}

//-----------------------------------------------------------------------------

void
dia_MessageBufferUDS::vSetPosResp ( void )
{
   dia_tclFnctTrace trc("dia_MessageBufferUDS::vSetPosResp");

   // convert req into resp, keep data unchanged - Set positive response bit
   tU8 pos = ( mFormat == format_length_and_data ) ? 1 : 0;
   DIA_TR_INF("### SETTING POSITIVE RESPONSE (POS=%d, BUFFER(POS)=0x%02x) ###", pos, mpBuffer[pos]);
   mpBuffer[pos] |= udsPosRespMask;
   mState = holds_response;
}

//-----------------------------------------------------------------------------

tU16
dia_MessageBufferUDS::u16GetServiceId ( void ) const
{
   tU8  pos = ( mFormat == format_length_and_data ) ? 1 : 0;
   tU16 sid = tU16((mpBuffer[pos] << 8) | mpBuffer[pos+1]);

   DIA_TR_INF( "sid is 0x%04X (decimal %d)", sid, sid );

   return sid;
}

//-----------------------------------------------------------------------------

tU8
dia_MessageBufferUDS::u8GetServiceId() const
{
   tU8 pos = ( mFormat == format_length_and_data ) ? 1 : 0;
   tU8 sId = mpBuffer[pos];

   DIA_TR_INF( "The Service Id is 0x%02X (decimal %d)", sId, sId );

   return sId;
}

//-----------------------------------------------------------------------------

tU8
dia_MessageBufferUDS::u8GetSubServiceId() const
{
   // TODO: return 0 if SID does not have a subservice
   tU8  pos = ( mFormat == format_length_and_data ) ? 2 : 1;
   return mpBuffer[pos];
}

//-----------------------------------------------------------------------------

tU16
dia_MessageBufferUDS::u16GetSubServiceId() const
{
   tU8    pos = ( mFormat == format_length_and_data ) ? 2 : 1;
   tU16 subID = tU16((mpBuffer[pos] << 8) | mpBuffer[pos+1]);

   DIA_TR_INF( "Sub service id 16 bit has value 0x%04X (decimal %d)", subID, subID );

   return subID;
}

