/**
 * \file    dia_LookupKeyUDS.h
 *
 * \brief   This file contains the definition of the dia_LookupKeyUDS class that is
 *          used to check if a service handler for incoming diagnosis request is
 *          available
 *
 * \author  gib2hi
 * \date    2012/04/24
 */

#ifndef __INCLUDED_DIA_LOOKUPKEYUDS__
#define __INCLUDED_DIA_LOOKUPKEYUDS__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_LOOKUPKEY__
#include "common/framework/engine/dia_LookupKey.h"
#endif

class dia_MessageBuffer;

/**
 * \class   dia_LookupKeyUDS
 *
 * \brief   This class is used to check if a service handler for incoming diagnosis
 *          request is available
 *
 * \ingroup diaCoreEngine
 */

class dia_LookupKeyUDS
      : public dia_LookupKey
{
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_LookupKeyUDS);
   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_LookupKeyUDS);
public:
   //! class constructor that calculates a key from a received message
   dia_LookupKeyUDS ( const dia_MessageBuffer& msgBuffer );
   //!
   virtual ~dia_LookupKeyUDS ( void ) {}
};

#endif /* __INCLUDED_DIA_LOOKUPKEYUDS__ */
