/*
 * dia_LookupKeyUDS.cpp
 *
 *  Created on: 24.04.2012
 *      Author: gib2hi
 */

#include "dia_LookupKeyUDS.h"

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER__
#include "common/framework/engine/dia_MessageBuffer.h"
#endif

//#define DIA_U8_UDS_SID_POS      1
#define DIA_U8_UDS_SUBFUNC_POS  2

dia_LookupKeyUDS::dia_LookupKeyUDS ( const dia_MessageBuffer& msgBuffer )
   : dia_LookupKey(msgBuffer)
{
   dia_tclFnctTrace oTrace("dia_LookupKeyUDS::dia_LookupKeyUDS(dia_MessageBuffer&)");

   // at this time we only support the UDS protocol
   if ( msgBuffer.getProtocol() == DIA_EN_PROTOCOL_UDS )
   {
      if ( mParaType == eParameterWord )
      {
         if ( mSID == 0x31 )
         {
            if ( msgBuffer.u16GetDataLength() > 4 )
            {
               mParameter = (((tU16) msgBuffer.getDataU8(DIA_U8_UDS_SUBFUNC_POS+1)) << 8) | ((tU16) msgBuffer.getDataU8(DIA_U8_UDS_SUBFUNC_POS+2));
            }
         }
      }
   }
}

