/*
 * dia_LookupKeyGMLan.cpp
 *
 *  Created on: 24.04.2012
 *      Author: gib2hi
 */

#include "dia_LookupKeyGMLan.h"

#define DIA_U8_UDS_SID_POS      1
#define DIA_U8_UDS_SUBFUNC_POS  2

dia_LookupKeyGMLan::dia_LookupKeyGMLan ( const dia_MessageBuffer& msgBuffer )
   : dia_LookupKey(msgBuffer)
{
   dia_tclFnctTrace oTrace("dia_LookupKeyGMLan::dia_LookupKeyGMLan(dia_MessageBuffer&)");

   // at this time we only support the GMLAN protocol
   if ( msgBuffer.getProtocol() == DIA_EN_PROTOCOL_GMLAN )
   {
      mSID = msgBuffer.getDataU8(DIA_U8_UDS_SID_POS);
   }

   if ( mSID && dia_LookupKey::mKeyFormatRep[mSID].mSID != 0 )
   {
      // we have a valid entry in the repository

      mParaType = dia_LookupKey::mKeyFormatRep[mSID].mParaType;

      if ( mParaType == eParameterByte )
      {
         mParameter = msgBuffer.getDataU8(DIA_U8_UDS_SUBFUNC_POS);
      }
      else if ( mParaType == eParameterWord )
      {
         mParameter = (((tU16) msgBuffer.getDataU8(DIA_U8_UDS_SUBFUNC_POS)) << 8) | ((tU16) msgBuffer.getDataU8(DIA_U8_UDS_SUBFUNC_POS+1));
      }
      else
      {
         // parameter type unknown or doubleword
         mParameter = 0x0000;
      }

      mLengthType = dia_LookupKey::mKeyFormatRep[mSID].mLengthType;
      if ( mLengthType == eLengthSpecified ) {
         mLength = msgBuffer.u16GetDataLength();
      }
   }
}

