/************************************************************************
* FILE:         dia_DeviceControl.h
* PROJECT:      GM Gen2
* SW-COMPONENT: Diagnostic application
*----------------------------------------------------------------------
*
* DESCRIPTION: Class for SID $AE - "Device Control"
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2004 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author          	   | Modification
* 02.09.10  | TMS Thomas Schmidt		| initial version
*
*************************************************************************/

#ifndef dia_DeviceControl_H
#define dia_DeviceControl_H

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_UDS__
#include "common/framework/protocols/uds/dia_common_uds.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SESSION_LISTENER__
#include <common/interfaces/dia_ISessionListener.h>
#endif

class dia_DeviceControl
   : public dia_ServiceHandlerUDS,
     public dia_ISessionListenerImpl
{
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_DeviceControl);
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_DeviceControl);

public:   
   dia_DeviceControl ( tCString name, tU8 cpid );
   virtual ~dia_DeviceControl ( tVoid );
   //! notification about session change
   virtual tVoid vOnSessionChanged ( tU8 /*newSession*/, tU8 /*oldSession*/ ) {}
   //! notification about a session's internal state change
   virtual tVoid vOnSessionEvent ( tU8 sessionID, OSAL_tEventMask mask );

protected:
   //! create and send positive response
   tVoid vSendPositiveResponse ();  //lint !e1511 This non-virtual method doesn't hidden a method
                                    //            from base class dia_ServiceHandlerUDS::vSendPositiveResponse,
                                    //            because parameters lists of both functions are different.
                                    //            This non-virtual method is an example of bad practice in this case
                                    //            and it should be fixed to a virtual functions, because
                                    //            the class dia_DeviceControl is a base class for others.
                                    //            Otherwise some description should be added why it is non-virtual.

   virtual tVoid vCancel() = 0;
};

#endif

