/************************************************************************
* FILE:         dia_DeviceControl.cpp
* PROJECT:      GM Gen2
* SW-COMPONENT: Diagnostic application
*----------------------------------------------------------------------
*
* DESCRIPTION: Class for SID $AE - "Device Control"
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2004 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                | Modification
* 02.09.10  | TMS Thomas Schmidt   | initial version
* 10.05.11  | TMS Khaled Daoud      | Implementation of the Functionality
*
*************************************************************************/


#include "dia_DeviceControl.h"

#ifndef __INCLUDED_DIA_ENGINE_SERVER__
#include "common/framework/engine/dia_EngineServer.h"
#endif

#ifndef __INCLUDED_DIA_SESSION_CONTROLLER__
#include "common/framework/application/dia_SessionController.h"
#endif


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGNOSTICS_CUST
#include "trcGenProj/Header/dia_DeviceControl.cpp.trc.h"
#endif

#define DATA_START (1/*sizeof(SID)*/ + mDIDLen)


dia_DeviceControl::dia_DeviceControl ( tCString name, tU8 cpid )
   : dia_ServiceHandlerUDS(name,0xAE,(tU8) cpid)
{
    ETG_TRACE_USR3_THR(("--> dia_DeviceControl::dia_DeviceControl"));

    ETG_TRACE_USR3_THR(("<-- dia_DeviceControl::dia_DeviceControl"));
}


dia_DeviceControl::~dia_DeviceControl()
{
    ETG_TRACE_USR3_THR(("--> dia_DeviceControl::~dia_DeviceControl"));

    ETG_TRACE_USR3_THR(("<-- dia_DeviceControl::~dia_DeviceControl"));
}


tVoid dia_DeviceControl::vSendPositiveResponse ( )
{
    ETG_TRACE_USR3_THR(("--> dia_DeviceControl::vSendPositiveResponse"));

    dia_SessionController* pSessionController = mpEngine->getSessionController();

    if (pSessionController)
    {
       OSAL_tEventMask mask = 0;
       mask |= 2; //DiagServicesDisableDTCs
       mask |= 4; //DeviceControl

       (tVoid) pSessionController->addListener(this);
       if ( pSessionController->setSessionEvent(mask, OSAL_EN_EVENTMASK_OR) == DIA_SUCCESS )
       {
          ETG_TRACE_COMP_THR(("--- dia_DeviceControl::vSendPositiveResponse => Switched to DeviceControl"));
       }
       else
       {
          ETG_TRACE_ERR_THR(("!!! dia_DeviceControl::vSendPositiveResponse => ERROR: Failed to enable DeviceControl"));
       }
    }

    dia_ServiceHandlerUDS::vSendPositiveResponse((tU16)DATA_START);

    ETG_TRACE_USR3_THR(("<-- dia_DeviceControl::vSendPositiveResponse"));
}


tVoid dia_DeviceControl::vOnSessionEvent ( tU8 sessionID, OSAL_tEventMask mask )
{
    ETG_TRACE_USR3_THR(("--> dia_DeviceControl::vOnSessionEvent"));

    ETG_TRACE_COMP_THR(("--- dia_DeviceControl::vOnSessionEvent => id=%d event=0x%x",
          sessionID, mask));

    if (!(mask & 4))
    {
       ETG_TRACE_COMP_THR(("--- dia_DeviceControl::vOnSessionEvent => Cancel DeviceControl"));

       (tVoid) mpEngine->getSessionController()->removeListener(this);

       vCancel();
    }

    ETG_TRACE_USR3_THR(("<-- dia_DeviceControl::vOnSessionEvent"));
}


