/**
 * \file      dia_OSALDriverTrace.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      13.06.2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_INTERFACE_TRACE_LISTENER__
#include "common/interfaces/dia_ITraceListener.h"
#endif

#ifndef __INCLUDED_DIA_TRACE_IF__
#include "common/framework/platform/dia_trace_if.h"
#endif

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#include "dia_OSALDriverTrace.h"

//----------------------------------------------------------------------------------------

tDiaResult
dia_OSALDriverTrace::open ( void )
{
   tDiaResult retCode = DIA_FAILED;

   if ( mpDriver )
   {
      if ( mpDriver->open() == DIA_SUCCESS )
      {
         OSAL_trIOCtrlLaunchChannel oTraceChannel;
         // set up the trace channel for TTFis
         oTraceChannel.enTraceChannel = TR_TTFIS_DIAG_MCNET;
         // set up the call back function for TTFis
         oTraceChannel.pCallback = (OSAL_tpfCallback) vOnTraceChannelCallback;
         if ( mpDriver->ioctrl(OSAL_C_S32_IOCTRL_CALLBACK_REG, (intptr_t) &oTraceChannel) == DIA_SUCCESS )
         {
            retCode = DIA_SUCCESS;
         }
         else
         {
            DIA_TR_ERR("DIA_TRACE_CHANNEL NOT SUCCESSFULLY CONFIGURED !!!");
         }
      } //lint !e550: Symbol not accessed, but required to pass a valid parameter in function call
   }

   return retCode;
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_OSALDriverTrace::close ( void )
{
   tDiaResult retCode = DIA_FAILED;

   if ( mpDriver )
   {
      // close TTFis channel
      OSAL_trIOCtrlLaunchChannel oTraceChannel;
      oTraceChannel.enTraceChannel = TR_TTFIS_DIAG_MCNET;
      oTraceChannel.pCallback = (OSAL_tpfCallback) vOnTraceChannelCallback;
      if ( mpDriver->ioctrl(OSAL_C_S32_IOCTRL_CALLBACK_UNREG, (intptr_t) &oTraceChannel) != DIA_SUCCESS )
      {
         DIA_TR_ERR("DIA_TRACE_CHANNEL NOT SUCCESSFULLY UNREGISTERED !!!");
      }

      retCode = mpDriver->close();
   } //lint !e550: Symbol not accessed, but required to pass a valid parameter in function call

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_OSALDriverTrace::ioctrl ( tS32 /*func*/, intptr_t /*arg*/ )
{
   dia_tclFnctTrace oTrace("dia_OSALDriverTrace::ioctrl()");

//   tDiaResult retCode = DIA_FAILED;

//   switch ( func )
//   {
//   case DIA_C_S32_IOCTRL_TRACE_SET_LOCK_STATUS:
//      {
//         tS32 lockStatus = 0;
//         if ( TRACE_lock_seed_status(TRACE_GET_LOCK_STATUS,&lockStatus) == 0 )
//         {
//            if ( lockStatus != arg )
//            {
//               if ( TRACE_lock_seed_status(TRACE_SET_LOCK_STATUS,&arg) == 0 )
//               {
//                  DIA_TR_ERR("#################################################################");
//                  DIA_TR_ERR("#");
//                  DIA_TR_ERR("# TRACE_lock_seed_status(TRACE_SET_LOCK_STATUS,%d)",arg);
//                  DIA_TR_ERR("#");
//                  DIA_TR_ERR("#################################################################");
//                  retCode = DIA_SUCCESS;
//               }
//            }
//            else
//            {
//               DIA_TR_ERR("#################################################################");
//               DIA_TR_ERR("#");
//               DIA_TR_ERR("# TRACE LOCK STATUS UNCHANGED");
//               DIA_TR_ERR("#");
//               DIA_TR_ERR("#################################################################");
//               retCode = DIA_SUCCESS;
//            }
//         }
//      }
//      break;
//
//   default:
//      break;
//   }

//   return retCode;
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tVoid
dia_OSALDriverTrace::vOnTraceChannelCallback ( tVoid* pArg )
{
   dia_tclFnctTrace oTrace("dia_OSALDriverTrace::vOnTraceChannelCallback()");

   dia_ITraceListener* pListener = OSAL_NULL;
   querySysAdapterListener<dia_ITraceListener>(&pListener);
   if ( pListener )
   {
      tU8* pMessage = static_cast<tU8*>(pArg);
      pListener->vOnTraceMessage(pMessage);
   }
}


