/**
 * \file      dia_ServiceTracker.h
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      Oct 17, 2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */


#ifndef __INCLUDED_DIA_SERVICE_TRACKER__
#define __INCLUDED_DIA_SERVICE_TRACKER__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_DEFINES_CCA__
#include <common/framework/platform/cca/dia_defsCCA.h>
#endif

#ifndef __INCLUDED_DIA_LOCK__
#include <common/framework/application/dia_Lock.h>
#endif

class dia_IServiceListener;
class dia_ServiceInfoCCA;

class dia_ServiceTracker
{
   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_ServiceTracker);

public:
   //! add a new listener to the repository (will be notified for updates in any service)
   virtual tDiaResult addListener ( dia_IServiceListener* pListener );
   //! add a new listener to the repository
   virtual tDiaResult addListener ( tU16 serviceID, tU16 serverID, dia_IServiceListener* pListener );
   //! remove a listener from the repository of listeners listening on any service updates
   virtual tDiaResult removeListener ( const dia_IServiceListener* pListener );
   //! remove a listener from the repository
   virtual tDiaResult removeListener ( tU16 serviceID, tU16 serverID, dia_IServiceListener* pListener );
   //!
   virtual tU16 getServiceRegistration ( tU16 serviceID, tU16 serverID );
   //!
   virtual dia_enServiceState getServiceState ( tU16 serviceID, tU16 serverID );

   //! a service state has been changed
   virtual void onServiceRegistration ( tU16 serviceID, tU16 serverID, tU16 regID );
   //! a service state has been changed
   virtual void onServiceState ( tU16 serviceID, tU16 serverID, dia_enServiceState state );

   //! for trace (see trace commandos)
   virtual void printStatistic(void);
   //! reset registrations, but not the listener repository
   virtual void reset ( void );

protected:
   //! constructor
   dia_ServiceTracker ( void );
   //! destructor
   virtual ~dia_ServiceTracker ( void );

   //! clear the content of all repositories
   virtual void destroy ( void );

protected:
   //! synchronization object used to synchronize concurrent access from multiple threads
   mutable dia::Lock mSyncObj;

   //! list of service registration listeners
   std::map<tU32,dia_ServiceInfoCCA*> mRep;
   //!
   std::list<dia_IServiceListener*> mListenerRep;
};

#endif
