/**
 * \file      dia_ServiceInfoCCA.h
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      Oct 18, 2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */


#ifndef __INCLUDED_DIA_SERVICE_INFO_CCA__
#define __INCLUDED_DIA_SERVICE_INFO_CCA__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_DEFINES_CCA__
#include "common/framework/platform/cca/dia_defsCCA.h"
#endif

class dia_IServiceListener;

class dia_ServiceInfoCCA
{
public:
   //! class constructor
   dia_ServiceInfoCCA ( tU16 serviceID, tU16 serverID, dia_enServiceState state=DIA_EN_SERVICE_STATE_UNKNOWN );
   //!
   virtual ~dia_ServiceInfoCCA ( void );

   tU16 getID ( void ) const { return mID; }
   void setID ( tU16 id ) { mID = id; }
   tU16 getServerID ( void ) const { return mServerID; }
   void setServerID ( tU16 serverID ) { mServerID = serverID; }
   tU16 getRegID ( void ) const { return mRegID; }
   void setRegID ( tU16 regID ) { mRegID = regID; }
   dia_enServiceState getState ( void ) const { return mState; }
   void setState ( dia_enServiceState state ) { mState = state; }

   tDiaResult addListener ( dia_IServiceListener* pListener );
   tDiaResult removeListener ( const dia_IServiceListener* pListener );
   const std::list<dia_IServiceListener*>& getListeners ( void ) const { return mListenerRep; }
   tU16 getNumberOfListeners ( void ) const { return (tU16)mListenerRep.size(); }

protected:
   //! deprecated default constructor
   dia_ServiceInfoCCA ( void );

protected:
   //! service identifier
   tU16 mID;
   //! identifier of the server offering the service
   tU16 mServerID;
   //! registration ID
   tU16 mRegID;
   //! state of the service
   dia_enServiceState  mState;
   //! repository of listeners for service information
   std::list<dia_IServiceListener*> mListenerRep;
};

#endif /* __INCLUDED_DIA_SERVICE_INFO_CCA__ */
