/**
 * \file      dia_ServiceInfoCCA.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      Oct 18, 2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_INTERFACE_SERVICE_LISTENER__
#include "common/interfaces/dia_IServiceListener.h"
#endif

#ifndef __INCLUDED_DIA_SERVICE_INFO_CCA__
#include "common/framework/platform/cca/dia_ServiceInfoCCA.h"
#endif

//-----------------------------------------------------------------------------

dia_ServiceInfoCCA::dia_ServiceInfoCCA ( tU16 serviceID, tU16 serverID, dia_enServiceState state )
   : mID(serviceID),
     mServerID(serverID),
     mRegID(DIA_C_U16_INVALID_REGISTRATION_ID),
     mState(state)
{
   dia_tclFnctTrace trc("dia_ServiceInfoCCA::dia_ServiceInfoCCA(serviceID,serverID,state)");
   DIA_TR_INF( " --> SID=0x%0x, AID=0x%0x, RID=0x%0x, STATE=%d", mID, mServerID, mRegID, mState);
}

//-----------------------------------------------------------------------------

dia_ServiceInfoCCA::~dia_ServiceInfoCCA ( void )
{
   _BP_TRY_BEGIN
   {
      mListenerRep.clear();
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_ServiceInfoCCA::~dia_ServiceInfoCCA!!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-----------------------------------------------------------------------------

tDiaResult
dia_ServiceInfoCCA::addListener ( dia_IServiceListener* pListener )
{
   if ( !pListener ) return DIA_E_INVALID_POINTER;

   tDiaResult retCode = DIA_E_ALREADY_EXISTS;

   // check if the corresponding object is already registered
   std::list<dia_IServiceListener*>::iterator iter = find(mListenerRep.begin(), mListenerRep.end(), pListener);
   if ( iter == mListenerRep.end() )
   {
      mListenerRep.push_back(pListener);
      retCode = DIA_SUCCESS;
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_ServiceInfoCCA::removeListener ( const dia_IServiceListener* pListener )
{
   if ( !pListener ) return DIA_E_INVALID_POINTER;

   tDiaResult retCode = DIA_E_NOT_FOUND;

   std::list<dia_IServiceListener*>::iterator listIter = mListenerRep.begin();
   for ( ; listIter != mListenerRep.end(); listIter++ )
   {
      if ( (*listIter) == pListener )
      {
         mListenerRep.erase(listIter);
         retCode = DIA_SUCCESS;
         break;
      }
   }

   return retCode;
}
