/**
 * \file      dia_PredicateServiceStateCCA.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      Oct 17, 2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_PREDICATE_SERVICE_STATE_CCA__
#include "common/framework/platform/cca/dia_PredicateServiceStateCCA.h"
#endif

#ifndef __INCLUDED_DIA_SERVICE_TRACKER__
#include "common/framework/platform/cca/dia_ServiceTracker.h"
#endif

using namespace dia;

//-----------------------------------------------------------------------------

dia_PredicateServiceStateCCA::dia_PredicateServiceStateCCA ( tU16 serviceID, tU16 serverID, tBool availability )
   : dia_PredicateServiceCCA(dia_PredicateServiceStateCCA::getClassIdentifier(),serviceID,serverID),
     mAvailability(availability)
{
   std::string str = dia_composeStlString("%s_%04x_%04x_%s",DIA_PRED_CCA_SRV_STATE,serviceID,serverID,((availability) ? "TRUE" : "FALSE"));
   mUID = dia_getHashCodeFromString(str);
}

//-----------------------------------------------------------------------------

dia_PredicateServiceStateCCA::dia_PredicateServiceStateCCA ( const dia_PredicateServiceStateCCA& obj )
   : dia_PredicateServiceCCA(obj),
     mAvailability(obj.mAvailability)
{}

//-----------------------------------------------------------------------------

dia_PredicateServiceStateCCA&
dia_PredicateServiceStateCCA::operator = ( const dia_PredicateServiceStateCCA& obj )
{
   if ( this != &obj )
   {
      mUID          = obj.mUID;
      mClassID      = obj.mClassID;
      mIsMatched    = obj.mIsMatched;
      mServiceID    = obj.mServiceID;
      mServerID     = obj.mServerID;
      mAvailability = obj.mAvailability;
   }
   return *this;
}

//-----------------------------------------------------------------------------

dia_PredicateServiceStateCCA::~dia_PredicateServiceStateCCA ( void )
{}

//-----------------------------------------------------------------------------

dia_Predicate*
dia_PredicateServiceStateCCA::clone (void )
{
   return new dia_PredicateServiceStateCCA(*this);
}

//-----------------------------------------------------------------------------

tDiaResult
dia_PredicateServiceStateCCA::match ( void )
{
   ScopeTrace trc("dia_PredicateServiceStateCCA::bMatch()");

   tDiaResult retCode = DIA_FAILED;

   dia_ServiceTracker* pSrvTracker = getInstanceOfServiceTracker();
   if ( pSrvTracker )
   {
      tBool availability = (pSrvTracker->getServiceState(mServiceID,mServerID) == DIA_EN_SERVICE_STATE_AVAILABLE) ? TRUE : FALSE;

      if ( mAvailability == availability )
      {
         DIA_TR_INF("###################################################################");
         DIA_TR_INF("#");
         DIA_TR_INF("# dia_PredicateServiceStateCCA::match: SERVICE STATE FOR SERVICE 0x%x OK", mServiceID );
         DIA_TR_INF("#");
         DIA_TR_INF("###################################################################");
         retCode    = DIA_SUCCESS;
         mIsMatched = TRUE;
      }
      else
      {
         DIA_TR_INF("###################################################################");
         DIA_TR_INF("#");
         DIA_TR_INF("# dia_PredicateServiceStateCCA::match: SERVICE STATE FOR SERVICE 0x%x NOT OK", mServiceID );
         DIA_TR_INF("#");
         DIA_TR_INF("###################################################################");
      }
   }

   return retCode;
}

//-----------------------------------------------------------------------------

void
dia_PredicateServiceStateCCA::update ( const std::vector<tU32>& args )
{
   ScopeTrace trc("dia_PredicateServiceStateCCA::update()");

   if ( args.size() != 3 ) return;

   if ( (mServiceID == args[0]) && (mServerID == args[1]) )
   {
      if ( mAvailability == args[2] )
      {
         DIA_TR_INF("###################################################################");
         DIA_TR_INF("#");
         DIA_TR_INF("# dia_PredicateServiceStateCCA::update: SERVICE STATE FOR SERVICE 0x%x OK", mServiceID );
         DIA_TR_INF("#");
         DIA_TR_INF("###################################################################");
         mIsMatched = TRUE;
      }
      else
      {
         DIA_TR_INF("###################################################################");
         DIA_TR_INF("#");
         DIA_TR_INF("# dia_PredicateServiceStateCCA::update: SERVICE STATE FOR SERVICE 0x%x NOK", mServiceID );
         DIA_TR_INF("#");
         DIA_TR_INF("###################################################################");
         mIsMatched = FALSE;
      }
   }
}

