/**
 * \file      dia_PredicateServiceRegistrationCCA.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      Oct 17, 2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_PREDICATE_SERVICE_REGISTRATION_CCA__
#include "common/framework/platform/cca/dia_PredicateServiceRegistrationCCA.h"
#endif

#ifndef __INCLUDED_DIA_SERVICE_TRACKER__
#include "common/framework/platform/cca/dia_ServiceTracker.h"
#endif

using namespace dia;

//-----------------------------------------------------------------------------

dia_PredicateServiceRegistrationCCA::dia_PredicateServiceRegistrationCCA ( tU16 serviceID, tU16 serverID )
   : dia_PredicateServiceCCA(dia_PredicateServiceRegistrationCCA::getClassIdentifier(),serviceID,serverID),
     mRegID(DIA_C_U16_INVALID_REGISTRATION_ID)
{
   std::string str = dia_composeStlString("%s_%04x_%04x",DIA_PRED_CCA_SRV_REG,serviceID,serverID);
   mUID = dia_getHashCodeFromString(str);
}

//-----------------------------------------------------------------------------

dia_PredicateServiceRegistrationCCA::dia_PredicateServiceRegistrationCCA ( const dia_PredicateServiceRegistrationCCA& obj )
   : dia_PredicateServiceCCA(obj),
     mRegID(obj.mRegID)
{}

//-----------------------------------------------------------------------------

dia_PredicateServiceRegistrationCCA&
dia_PredicateServiceRegistrationCCA::operator = ( const dia_PredicateServiceRegistrationCCA& obj )
{
   if ( this != &obj )
   {
      mUID       = obj.mUID;
      mClassID   = obj.mClassID;
      mIsMatched = obj.mIsMatched;
      mServiceID = obj.mServiceID;
      mServerID  = obj.mServerID;
      mRegID     = obj.mRegID;
   }
   return *this;
}

//-----------------------------------------------------------------------------

dia_PredicateServiceRegistrationCCA::~dia_PredicateServiceRegistrationCCA ( void )
{}

//-----------------------------------------------------------------------------

dia_Predicate*
dia_PredicateServiceRegistrationCCA::clone (void )
{
   return OSAL_NEW dia_PredicateServiceRegistrationCCA(*this);
}

//-----------------------------------------------------------------------------

tDiaResult
dia_PredicateServiceRegistrationCCA::match ( void )
{
   dia_tclFnctTrace trc("dia_PredicateServiceRegistrationCCA::bMatch()");

   tDiaResult retCode = DIA_FAILED;

   dia_ServiceTracker* pSrvTracker = getInstanceOfServiceTracker();
   if ( pSrvTracker )
   {
      mRegID = pSrvTracker->getServiceRegistration(mServiceID,mServerID);

      if ( mRegID != DIA_C_U16_INVALID_REGISTRATION_ID )
      {
         DIA_TR_INF("###################################################################");
         DIA_TR_INF("#");
         DIA_TR_INF("# dia_PredicateServiceRegistrationCCA::bMatch: SERVICE REGISTRATION FOR SERVICE 0x%x OK", mServiceID );
         DIA_TR_INF("#");
         DIA_TR_INF("###################################################################");
         retCode    = DIA_SUCCESS;
         mIsMatched = TRUE;
      }
   }

   return retCode;
}

//-----------------------------------------------------------------------------

void
dia_PredicateServiceRegistrationCCA::update ( const std::vector<tU32>& args )
{
   dia_tclFnctTrace trc("dia_PredicateServiceRegistrationCCA::update()");

   if ( args.size() != 3 ) return;

   if ( (mServiceID == args[0]) && (mServerID == args[1]) )
   {
      mRegID = (tU16) args[2];

      if ( mRegID == DIA_C_U16_INVALID_REGISTRATION_ID )
      {
         DIA_TR_INF("###################################################################");
         DIA_TR_INF("#");
         DIA_TR_INF("# dia_PredicateServiceRegistrationCCA::vOnServiceRegistration: SERVICE REGISTRATION FOR SERVICE 0x%x OK", mServiceID );
         DIA_TR_INF("#");
         DIA_TR_INF("###################################################################");
         mIsMatched = FALSE;
      }
      else
      {
         DIA_TR_INF("###################################################################");
         DIA_TR_INF("#");
         DIA_TR_INF("# dia_PredicateServiceRegistrationCCA::vOnServiceRegistration: SERVICE REGISTRATION FOR SERVICE 0x%x NOK", mServiceID );
         DIA_TR_INF("#");
         DIA_TR_INF("###################################################################");
         mIsMatched = TRUE;
      }
   }
}

