/*
 * dia_SystemAdapterASF.h
 *
 *  Created on: Nov 29, 2013
 *      Author: stc2hi
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_ASF__
#define __INCLUDED_DIA_SYSTEM_ADAPTER_ASF__

#if 1
//Redefinition of new and delete when both OSAL and std::stl is used
#define __PLACEMENT_NEW_INLINE
#endif

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#include <asf/core/Proxy.h>

using namespace ::boost;
using namespace ::asf::core;

class dia_SystemAdapterASF
   : public ServiceAvailableIF
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SystemAdapterASF);

public:
   static std::unique_ptr<dia_SystemAdapterASF> create ( void );

   //! class destructor
   virtual ~dia_SystemAdapterASF ( void );

   //! add a plugin for a given service of the associated application
   tDiaResult addServicePlugin(const boost::shared_ptr<Proxy>& proxy, ServiceAvailableIF& pPlugin);

   //! ServiceAvailableIF implementation
   virtual void onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);
   virtual void onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange);

protected:
   //! default constructor
   dia_SystemAdapterASF();

   //!
   tDiaResult setup() const;

protected:
   //! map ASF Proxy -> SystemAdapterServicePlugin implementing an ServiceAvailableIF
   std::map<boost::shared_ptr<Proxy>,ServiceAvailableIF*> mPluginRep;
};

#endif /* __INCLUDED_DIA_SYSTEM_ADAPTER_ASF__ */
