/*
 * dia_SystemAdapterASF.cpp
 *
 *  Created on: Nov 29, 2013
 *      Author: stc2hi
 */

#if 1
//Redefinition of new and delete when both OSAL and std::stl is used
#define __PLACEMENT_NEW_INLINE
#endif

#include "dia_SystemAdapterASF.h"

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_SERVICE_PLUGIN_ASF__
#include <common/framework/platform/asf/dia_SystemAdapterServicePluginASF.h>
#endif

using namespace ::boost;
using namespace ::asf::core;

std::unique_ptr<dia_SystemAdapterASF>
dia_SystemAdapterASF::create ( void )
{
   dia_tclFnctTrace oTrace("dia_SystemAdapterASF::create()");
   std::unique_ptr<dia_SystemAdapterASF> pAdapter(OSAL_NEW dia_SystemAdapterASF());
   if ( pAdapter != nullptr )
   {
      if ( pAdapter->setup() != DIA_SUCCESS )
      {
         return nullptr;
      }
   }

   return pAdapter;
}

//----------------------------------------------------------------------------------------

dia_SystemAdapterASF::dia_SystemAdapterASF ( void )
{}

//----------------------------------------------------------------------------------------

dia_SystemAdapterASF::~dia_SystemAdapterASF ( void )
{}

//----------------------------------------------------------------------------------------

tDiaResult
dia_SystemAdapterASF::setup ( void ) const
{
   dia_tclFnctTrace oTrace("dia_SystemAdapterASF::setup()");
   return DIA_SUCCESS;
}

//------------------------------------------------------------------------------

tDiaResult
dia_SystemAdapterASF::addServicePlugin ( const boost::shared_ptr<Proxy>& proxy, ServiceAvailableIF& pPlugin )
{
   dia_tclFnctTrace oTrace("dia_SystemAdapterASF::addServicePlugin()");

   tDiaResult retCode = DIA_FAILED;

   std::map<boost::shared_ptr<Proxy>,ServiceAvailableIF*>::iterator iter = mPluginRep.find(proxy);
   if ( iter == mPluginRep.end() )
   {
      mPluginRep[proxy] = &pPlugin;
      DIA_TR_INF("--- dia_SystemAdapterASF::addServicePlugin => Mapped Proxy to SystemAdapterServicePlugin");
      retCode = DIA_SUCCESS;
   }
   else
   {
      DIA_TR_INF("!!! dia_SystemAdapterASF::addServicePlugin => ERROR: SystemAdapterServicePlugin already exists for Proxy");
   }

   return retCode;
}

//------------------------------------------------------------------------------

void
dia_SystemAdapterASF::onAvailable ( const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange )
{
   dia_tclFnctTrace oTrace("dia_SystemAdapterASF::onAvailable()");

   ServiceAvailableIF* pPlugin = NULL;
   std::map<boost::shared_ptr<Proxy>,ServiceAvailableIF*>::iterator iter = mPluginRep.find(proxy);
   if ( iter != mPluginRep.end() )
   {
      pPlugin = iter->second;
   }

   if (pPlugin)
   {
      DIA_TR_INF("Proxy for port \"%s\" service state %d", proxy->getPortName().c_str(), stateChange.getCurrentState());

      pPlugin->onAvailable(proxy, stateChange);
   }
   else
   {
      DIA_TR_ERR("!!! dia_SystemAdapterASF::onAvailable => ERROR: No associated service plugin!");
   }
}

//------------------------------------------------------------------------------

void
dia_SystemAdapterASF::onUnavailable ( const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange )
{
   dia_tclFnctTrace oTrace("dia_SystemAdapterASF::onUnavailable()");

   ServiceAvailableIF* pPlugin = NULL;
   std::map<boost::shared_ptr<Proxy>,ServiceAvailableIF*>::iterator iter = mPluginRep.find(proxy);
   if ( iter != mPluginRep.end() )
   {
      pPlugin = iter->second;
   }

   if (pPlugin)
   {
      DIA_TR_INF("Proxy for port \"%s\" service state %d", proxy->getPortName().c_str(), stateChange.getCurrentState());

      pPlugin->onUnavailable(proxy, stateChange);
   }
   else
   {
      DIA_TR_ERR("!!! dia_SystemAdapterASF::onUnavailable => ERROR: No associated service plugin!");
   }
}
