/*!
 * \file       dia_PredicateServiceASF.h
 *
 * \brief      Predicate class for the ASF service availability
 *
 * \component  Diagnostics
 *
 * \ingroup    diaCorePlatform
 *
 * \copyright  (c) 2015-2018 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_PREDICATE_SERVICE_ASF__
#define __INCLUDED_DIA_PREDICATE_SERVICE_ASF__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_PREDICATE__
#include <common/framework/application/dia_Predicate.h>
#endif

#define DIA_PRED_ASF_SERVICE   "DIA_PREDICATE_CLASS_ASF_SERVICE"

//-----------------------------------------------------------------------------


template <class _Proxy> class dia_SystemAdapterServicePluginASF;

template <class _Proxy>
class dia_PredicateServiceASF
   : public dia_Predicate
{
   DIA_DECL_PREDICATE_CLASS(DIA_PRED_ASF_SERVICE);

public:
   //! return the identifier
   static dia_UID getUID( const dia_SystemAdapterServicePluginASF<_Proxy>& srvPlugin )
   {
      return dia_getHashCodeFromString(srvPlugin.getPortName());
   }

   //! class constructor
   dia_PredicateServiceASF ( dia_SystemAdapterServicePluginASF<_Proxy>& srvPlugin )
      : dia_Predicate(dia_PredicateServiceASF::getClassIdentifier(), getUID(srvPlugin)),
        mpSrvPlugin(&srvPlugin)
   {}

   //! copy constructor
   dia_PredicateServiceASF ( const dia_PredicateServiceASF& obj )
      : dia_Predicate(obj),
        mpSrvPlugin(obj.mpSrvPlugin)
   {}

   //! assignment operator
   dia_PredicateServiceASF& operator = ( const dia_PredicateServiceASF& obj )
   {
      if ( this != &obj )
      {
         mUID       = obj.mUID;
         mClassID   = obj.mClassID;
         mIsMatched = obj.mIsMatched;
         mpSrvPlugin  = obj.mpSrvPlugin;
      }
      return *this;
   }

   //! destructor
   virtual ~dia_PredicateServiceASF ( void ) {}

   //! check if the predicate is matched
   virtual tDiaResult match ( void )
   {
      tDiaResult retCode = DIA_FAILED;

      if (mpSrvPlugin && mpSrvPlugin->isAvailable())
      {
         _Proxy* pProxy = mpSrvPlugin->getProxy();
         if (pProxy && pProxy->isAvailable())
         {
            DIA_TR_INF("Predicate %s matched by checking the ASF Proxy (port=%s, avail=%d)",
                  dia_PredicateServiceASF::getClassName(), pProxy->getPortName().c_str(), pProxy->isAvailable());
            mIsMatched = TRUE;
            retCode = DIA_SUCCESS;
         }
         else
         {
            DIA_ASSERT_ALWAYS();
         }
      }
      else
      {
         DIA_TR_INF("Predicate %s still not matching!", dia_PredicateServiceASF::getClassName());
      }

      return retCode;
   }

   //! observer pattern
   virtual void update ( const std::vector<tU32>& /*args*/ )
   {
      if (mpSrvPlugin && mpSrvPlugin->isAvailable())
      {
         _Proxy* pProxy = mpSrvPlugin->getProxy();
         if (pProxy && pProxy->isAvailable())
         {
            DIA_TR_INF("Predicate %s updated by checking the ASF Proxy (port=%s, avail=%d)",
                  dia_PredicateServiceASF::getClassName(), pProxy->getPortName().c_str(), pProxy->isAvailable());
            mIsMatched = TRUE;
         }
         else
         {
            mIsMatched = FALSE;
         }
      }
      else
      {
         mIsMatched = FALSE;
      }
   }

   //! prototype pattern
   virtual dia_Predicate* clone (void ) { return new dia_PredicateServiceASF(*this); }

protected:
   //! deprecated default class constructor
   dia_PredicateServiceASF();

   dia_SystemAdapterServicePluginASF<_Proxy>* mpSrvPlugin;
};

#endif /* __INCLUDED_DIA_PREDICATE_SERVICE_ASF__ */
