/*!
 * \file       dia_ASFComponentSystemAdapterFactory.h
 *
 * \brief      ASF component providing a service to create other ASF system adapters
 *
 * \component  Diagnostics
 *
 * \ingroup    diaCorePlatform
 *
 * \copyright  (c) 2019 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_ASF_COMPONENT_SYSTEM_ADAPTER_FACTORY__
#define __INCLUDED_DIA_ASF_COMPONENT_SYSTEM_ADAPTER_FACTORY__


#ifndef __INCLUDED_DIA_ASF_COMPONENT__
#include <project/framework/platform/asf/dia_ASFComponent.h>
#endif


#ifndef ASF_SYSTEMADAPTERFACTORYSERVICESTUB_H
#include "asf/SystemAdapterFactoryServiceStub.h"
#endif

using namespace ::asf::core;

namespace dia
{
   class DynamicLoader;
   class DynamicLoaderModule;
}

class dia_SAFeatureSystemAdapterFactory;

namespace asf {

class dia_ASFComponentSystemAdapterFactory
   : public dia_ASFComponent,
     public asf::SystemAdapterFactoryService::SystemAdapterFactoryServiceStub
{
   friend BaseComponent* ComponentFactory<dia_ASFComponentSystemAdapterFactory>::getComponent();

   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_ASFComponentSystemAdapterFactory);

public:
   //! default class destructor
   virtual ~dia_ASFComponentSystemAdapterFactory();

private:
   //! default class constructor called only by ComponentFactory<dia_ASFComponentSystemAdapterFactory>::getComponent()
   dia_ASFComponentSystemAdapterFactory();

   //! SystemAdapterFactoryServiceStub function
   void onRegisterModuleRequest (const ::boost::shared_ptr< asf::SystemAdapterFactoryService::RegisterModuleRequest >& registerModule) override;
   //! SystemAdapterFactoryServiceStub function
   void onCreateSystemAdapterRequest (const ::boost::shared_ptr< asf::SystemAdapterFactoryService::CreateSystemAdapterRequest >& createSystemAdapter) override;

private:
   //! SystemAdapterFeature
   dia_SAFeatureSystemAdapterFactory* mpFeature;
   //! DynamicLoader used to load a DynamicLoaderModule
   dia::DynamicLoader* mpDynamicLoader;
   //! DynamicLoaderModules contain SystemAdapters implementing several Interfaces
   std::map<dia::IID, std::unique_ptr<dia::DynamicLoaderModule> > mDynamicLoaderModules;

};

} //namespace asf

#endif /* __INCLUDED_DIA_ASF_COMPONENT_SYSTEM_ADAPTER_FACTORY__ */
