/*
 * dia_ASFComponentServer.cpp
 *
 *  Created on: 07.07.2015
 *      Author: gib2hi
 */

#include "dia_ASFComponentServer.h"
#include "org/bosch/cm/diagnosis/dbus/Diagnosis1/Control1Stub.h" //lint !e451 !e537 repeatedly included header file without standard include guard

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include <common/framework/sysadapters/dia_SystemAdapterFacade.h>
#endif

using namespace dia;

namespace asf {

//------------------------------------------------------------------------------

dia_ASFComponentServer::dia_ASFComponentServer ( void )
   : Control1Stub("diagServerPort")
{
   dia_tclFnctTrace trc("dia_ASFComponentServer::dia_ASFComponentServer");
}

//------------------------------------------------------------------------------

dia_ASFComponentServer::~dia_ASFComponentServer()
{
}

//------------------------------------------------------------------------------

void
dia_ASFComponentServer::onSetRemoteControlModeRequest ( const ::boost::shared_ptr< SetRemoteControlModeRequest >& request )
{
   dia_tclFnctTrace trc("dia_ASFComponentServer::onSetRemoteControlModeRequest");

   // currently we only support remote control for area "DIA_REMOTECTRL_AREA_SYSTEM_SETTING"
   tDiaResult retCode = checkRemoteControlArea(request->getArea());
   if ( retCode == DIA_SUCCESS )
   {
      dia_enSystemSettingMode mode = DIA_EN_SYSTEM_SETTING_MODE_UNKNOWN;
      retCode = checkRemoteControlMode(request->getMode(),mode);
      if ( retCode == DIA_SUCCESS )
      {
         dia_ISystemSettings* pInterface = 0;
         retCode = queryInterface<dia_ISystemSettings>(&pInterface);
         if ( (retCode == DIA_SUCCESS) && pInterface )
         {
            dia_RemoteControlRequestInfo* pRequestInfo = OSAL_NEW dia_RemoteControlRequestInfo(request->getArea(),request->getMode(),request->getCookie(),request->getAct());
            if ( pRequestInfo )
            {
               mRemoteControlRequestRep[request->getAct()] = pRequestInfo;
               retCode = pInterface->setSystemSettingMode(mode,*this, (tCookieType)request->getAct());
            }
         }
      }
   }

   if ( retCode != DIA_SUCCESS )
   {
      std::map<act_t,dia_RemoteControlRequestInfo*>::iterator iter = mRemoteControlRequestRep.find(request->getAct());
      if ( iter != mRemoteControlRequestRep.end() )
      {
         OSAL_DELETE iter->second;
         mRemoteControlRequestRep.erase(iter);
      }

      sendSetRemoteControlModeResponse(request->getArea(),request->getMode(),DIA_FAILED,request->getCookie(),request->getAct());
   }
}

//-----------------------------------------------------------------------------

void
dia_ASFComponentServer::onSetSystemSettingMode ( dia_enSystemSettingMode /*mode*/, tDiaResult resultCode, tCookieType cookie )
{
   dia_tclFnctTrace trc("dia_ASFComponentServer::onSetSystemSettingMode");

   act_t act = (act_t)(cookie);
   std::map<act_t,dia_RemoteControlRequestInfo*>::iterator iter = mRemoteControlRequestRep.find(act);
   if ( iter != mRemoteControlRequestRep.end() )
   {
      sendSetRemoteControlModeResponse(iter->second->mArea,iter->second->mMode,resultCode,iter->second->mCookie,act);
      OSAL_DELETE iter->second;
      mRemoteControlRequestRep.erase(iter);
   }
}


//------------------------------------------------------------------------------

tDiaResult
dia_ASFComponentServer::checkRemoteControlArea ( const std::string& strArea ) const
{
   return ( strArea == std::string("DIA_REMOTECTRL_AREA_SYSTEM_SETTING") ) ? DIA_SUCCESS : DIA_E_SYSSET_INVALID_AREA;
}

//------------------------------------------------------------------------------

tDiaResult
dia_ASFComponentServer::checkRemoteControlMode ( const std::string& strMode, dia_enSystemSettingMode& mode ) const
{
   tDiaResult retCode = DIA_SUCCESS;

   if  ( strMode == std::string("DIA_REMOTECTRL_MODE_ACTIVE") )
   {
      mode = DIA_EN_SYSTEM_SETTING_MODE_SLAVE;
   }
   else if  ( strMode == std::string("DIA_REMOTECTRL_MODE_INACTIVE") )
   {
      mode = DIA_EN_SYSTEM_SETTING_MODE_MASTER;
   }
   else
   {
      retCode = DIA_E_SYSSET_INVALID_MODE;
   }

   return retCode;
}

//------------------------------------------------------------------------------

void
dia_ASFComponentServer::onGetRemoteControlModeRequest ( const ::boost::shared_ptr< GetRemoteControlModeRequest >& request )
{
   dia_tclFnctTrace trc("dia_ASFComponentServer::onGetRemoteControlModeRequest");

   std::string strMode("DIA_REMOTECTRL_MODE_UNKNOWN");

   // currently we only support remote control for area "DIA_REMOTECTRL_AREA_SYSTEM_SETTING"
   tDiaResult retCode = checkRemoteControlArea(request->getArea());
   if ( retCode == DIA_SUCCESS )
   {
      dia_ISystemSettings* pInterface = 0;
      retCode = queryInterface<dia_ISystemSettings>(&pInterface);
      if ( (retCode == DIA_SUCCESS) && pInterface )
      {
         dia_enSystemSettingMode mode = pInterface->getSystemSettingMode();
         strMode = ( mode == DIA_EN_SYSTEM_SETTING_MODE_SLAVE ) ? "DIA_REMOTECTRL_MODE_ACTIVE" : "DIA_REMOTECTRL_MODE_INACTIVE";
      }
   }

   sendGetRemoteControlModeResponse(request->getArea(),strMode,request->getCookie(),request->getAct());
}

//------------------------------------------------------------------------------

void
dia_ASFComponentServer::onStartSystemSettingRequest ( const ::boost::shared_ptr< StartSystemSettingRequest >& request )
{
   dia_tclFnctTrace trc("dia_ASFComponentServer::onStartSystemSettingRequest");

   dia_ISystemSettings* pInterface = 0;
   tDiaResult retCode = queryInterface<dia_ISystemSettings>(&pInterface);
   if ( (retCode == DIA_SUCCESS) && pInterface )
   {
      dia_SystemSettingExtendedData extDataVec;
      for ( tU16 i=0; i<request->getExtendedData().size(); i++ )
      {
         dia_SystemSettingExtDataElem elem((request->getExtendedData())[i].getElem1(),(request->getExtendedData())[i].getElem2());
         extDataVec.push_back(elem);
      }

      dia_SystemSettingRequestInfo* pRequestInfo = OSAL_NEW dia_SystemSettingRequestInfo(request->getSysSetType(),extDataVec,request->getCookie(),request->getAct());
      if ( pRequestInfo )
      {
         mSystemSettingRequestRep[request->getAct()] = pRequestInfo;
         retCode = pInterface->processSystemSetting(pRequestInfo->mTypeID,pRequestInfo->mExtData,*this, (tCookieType)request->getAct());
      }
   }

   if ( retCode != DIA_SUCCESS )
   {
      std::vector<StartSystemSettingResponseExtendedDataStruct> responseExtDataVec;
      for ( tU16 i=0; i<request->getExtendedData().size(); i++ )
      {
         StartSystemSettingResponseExtendedDataStruct elem((request->getExtendedData())[i].getElem1(),(request->getExtendedData())[i].getElem2());
         responseExtDataVec.push_back(elem);
      }

      std::map<act_t,dia_SystemSettingRequestInfo*>::iterator iter = mSystemSettingRequestRep.find(request->getAct());
      if ( iter != mSystemSettingRequestRep.end() )
      {
         OSAL_DELETE iter->second;
         mSystemSettingRequestRep.erase(iter);
      }

      sendStartSystemSettingResponse(request->getSysSetType(),responseExtDataVec,retCode,request->getCookie(),request->getAct());
   }
}

//-----------------------------------------------------------------------------

void
dia_ASFComponentServer::onSystemSettingProcessed ( dia_UID /*typeID*/, const dia_SystemSettingExtendedData& /*extData*/, tDiaResult resultCode, tCookieType cookie )
{
   dia_tclFnctTrace trc("dia_ASFComponentServer::onSystemSettingProcessed(dia_UID,const dia_SystemSettingExtendedData&,tDiaResult,void*)");

   act_t act = (act_t)(cookie);
   std::map<act_t,dia_SystemSettingRequestInfo*>::iterator iter = mSystemSettingRequestRep.find(act);
   if ( iter != mSystemSettingRequestRep.end() )
   {
      std::vector<StartSystemSettingResponseExtendedDataStruct> responseExtDataVec;
      for ( tU16 i=0; i<iter->second->mExtData.size(); i++ )
      {
         StartSystemSettingResponseExtendedDataStruct elem((iter->second->mExtData)[i].mTypeInfo,(iter->second->mExtData)[i].mData);
         responseExtDataVec.push_back(elem);
      }
      sendStartSystemSettingResponse(iter->second->mType,responseExtDataVec,resultCode,iter->second->mCookie,act);
      OSAL_DELETE iter->second;
      mSystemSettingRequestRep.erase(iter);
   }
}

//-----------------------------------------------------------------------------

void
dia_ASFComponentServer::onSystemSettingProcessed ( dia_UID /*typeID*/, dia_enSystemSettingLevel level, const dia_SystemSettingExtendedData& /*extData*/, tDiaResult resultCode, tCookieType cookie )
{
   dia_tclFnctTrace trc("dia_ASFComponentServer::onSystemSettingProcessed(dia_UID,const dia_SystemSettingExtendedData&,tDiaResult,void*)");

   act_t act = (act_t)(cookie);
   std::map<act_t,dia_SystemSettingRequestInfo*>::iterator iter = mSystemSettingRequestRep.find(act);
   if ( iter != mSystemSettingRequestRep.end() )
   {
      switch ( level )
      {
      case DIA_EN_SYSTEM_SETTING_LEVEL_PREPARE:
         {
            std::vector<RemotePrepareSystemSettingResponseExtendedDataStruct> responseExtDataVec;
            for ( tU16 i=0; i<iter->second->mExtData.size(); i++ )
            {
               RemotePrepareSystemSettingResponseExtendedDataStruct elem((iter->second->mExtData)[i].mTypeInfo,(iter->second->mExtData)[i].mData);
               responseExtDataVec.push_back(elem);
            }
            sendRemotePrepareSystemSettingResponse(iter->second->mType,responseExtDataVec,resultCode,iter->second->mCookie,act);
         }
         break;

      case DIA_EN_SYSTEM_SETTING_LEVEL_EXECUTE:
         {
            std::vector<RemoteExecuteSystemSettingResponseExtendedDataStruct> responseExtDataVec;
            for ( tU16 i=0; i<iter->second->mExtData.size(); i++ )
            {
               RemoteExecuteSystemSettingResponseExtendedDataStruct elem((iter->second->mExtData)[i].mTypeInfo,(iter->second->mExtData)[i].mData);
               responseExtDataVec.push_back(elem);
            }
            sendRemoteExecuteSystemSettingResponse(iter->second->mType,responseExtDataVec,resultCode,iter->second->mCookie,act);
         }
         break;

      case DIA_EN_SYSTEM_SETTING_LEVEL_FINALIZE:
         {
            std::vector<RemoteFinalizeSystemSettingResponseExtendedDataStruct> responseExtDataVec;
            for ( tU16 i=0; i<iter->second->mExtData.size(); i++ )
            {
               RemoteFinalizeSystemSettingResponseExtendedDataStruct elem((iter->second->mExtData)[i].mTypeInfo,(iter->second->mExtData)[i].mData);
               responseExtDataVec.push_back(elem);
            }
            sendRemoteFinalizeSystemSettingResponse(iter->second->mType,responseExtDataVec,resultCode,iter->second->mCookie,act);
         }
         break;

      default:
         break;
      }

      OSAL_DELETE iter->second;
      mSystemSettingRequestRep.erase(iter);
   }
}

//------------------------------------------------------------------------------

void
dia_ASFComponentServer::onRemotePrepareSystemSettingRequest ( const ::boost::shared_ptr< RemotePrepareSystemSettingRequest >& request )
{
   dia_tclFnctTrace trc("dia_ASFComponentServer::onRemotePrepareSystemSettingRequest");

   dia_ISystemSettings* pInterface = 0;
   tDiaResult retCode = queryInterface<dia_ISystemSettings>(&pInterface);
   if ( (retCode == DIA_SUCCESS) && pInterface )
   {
      dia_SystemSettingExtendedData extDataVec;
      for ( tU16 i=0; i<request->getExtendedData().size(); i++ )
      {
         dia_SystemSettingExtDataElem elem((request->getExtendedData())[i].getElem1(),(request->getExtendedData())[i].getElem2());
         extDataVec.push_back(elem);
      }

      dia_SystemSettingRequestInfo* pRequestInfo = OSAL_NEW dia_SystemSettingRequestInfo(request->getSysSetType(),DIA_EN_SYSTEM_SETTING_LEVEL_PREPARE,extDataVec,request->getCookie(),request->getAct());
      if ( pRequestInfo )
      {
         mSystemSettingRequestRep[request->getAct()] = pRequestInfo;
         retCode = pInterface->processSystemSetting(pRequestInfo->mTypeID,DIA_EN_SYSTEM_SETTING_LEVEL_PREPARE,pRequestInfo->mExtData,*this, (tCookieType)request->getAct());
      }
   }

   if ( retCode != DIA_SUCCESS )
   {
      std::vector<RemotePrepareSystemSettingResponseExtendedDataStruct> responseExtDataVec;
      for ( tU16 i=0; i<request->getExtendedData().size(); i++ )
      {
         RemotePrepareSystemSettingResponseExtendedDataStruct elem((request->getExtendedData())[i].getElem1(),(request->getExtendedData())[i].getElem2());
         responseExtDataVec.push_back(elem);
      }

      std::map<act_t,dia_SystemSettingRequestInfo*>::iterator iter = mSystemSettingRequestRep.find(request->getAct());
      if ( iter != mSystemSettingRequestRep.end() )
      {
         OSAL_DELETE iter->second;
         mSystemSettingRequestRep.erase(iter);
      }

      sendRemotePrepareSystemSettingResponse(request->getSysSetType(),responseExtDataVec,retCode,request->getCookie(),request->getAct());
   }
}

//------------------------------------------------------------------------------

void
dia_ASFComponentServer::onRemoteExecuteSystemSettingRequest ( const ::boost::shared_ptr< RemoteExecuteSystemSettingRequest >& request )
{
   dia_tclFnctTrace trc("dia_ASFComponentServer::onRemoteExecuteSystemSettingRequest");

   dia_ISystemSettings* pInterface = 0;
   tDiaResult retCode = queryInterface<dia_ISystemSettings>(&pInterface);
   if ( (retCode == DIA_SUCCESS) && pInterface )
   {
      dia_SystemSettingExtendedData extDataVec;
      for ( tU16 i=0; i<request->getExtendedData().size(); i++ )
      {
         dia_SystemSettingExtDataElem elem((request->getExtendedData())[i].getElem1(),(request->getExtendedData())[i].getElem2());
         extDataVec.push_back(elem);
      }

      dia_SystemSettingRequestInfo* pRequestInfo = OSAL_NEW dia_SystemSettingRequestInfo(request->getSysSetType(),DIA_EN_SYSTEM_SETTING_LEVEL_EXECUTE,extDataVec,request->getCookie(),request->getAct());
      if ( pRequestInfo )
      {
         mSystemSettingRequestRep[request->getAct()] = pRequestInfo;
         retCode = pInterface->processSystemSetting(pRequestInfo->mTypeID,DIA_EN_SYSTEM_SETTING_LEVEL_EXECUTE,pRequestInfo->mExtData,*this, (tCookieType)request->getAct());
      }
   }

   if ( retCode != DIA_SUCCESS )
   {
      std::vector<RemoteExecuteSystemSettingResponseExtendedDataStruct> responseExtDataVec;
      for ( tU16 i=0; i<request->getExtendedData().size(); i++ )
      {
         RemoteExecuteSystemSettingResponseExtendedDataStruct elem((request->getExtendedData())[i].getElem1(),(request->getExtendedData())[i].getElem2());
         responseExtDataVec.push_back(elem);
      }

      std::map<act_t,dia_SystemSettingRequestInfo*>::iterator iter = mSystemSettingRequestRep.find(request->getAct());
      if ( iter != mSystemSettingRequestRep.end() )
      {
         OSAL_DELETE iter->second;
         mSystemSettingRequestRep.erase(iter);
      }

      sendRemoteExecuteSystemSettingResponse(request->getSysSetType(),responseExtDataVec,retCode,request->getCookie(),request->getAct());
   }
}

//------------------------------------------------------------------------------

void
dia_ASFComponentServer::onRemoteFinalizeSystemSettingRequest ( const ::boost::shared_ptr< RemoteFinalizeSystemSettingRequest >& request )
{
   dia_tclFnctTrace trc("dia_ASFComponentServer::onRemoteFinalizeSystemSettingRequest");

   dia_ISystemSettings* pInterface = 0;
   tDiaResult retCode = queryInterface<dia_ISystemSettings>(&pInterface);
   if ( (retCode == DIA_SUCCESS) && pInterface )
   {
      dia_SystemSettingExtendedData extDataVec;
      for ( tU16 i=0; i<request->getExtendedData().size(); i++ )
      {
         dia_SystemSettingExtDataElem elem((request->getExtendedData())[i].getElem1(),(request->getExtendedData())[i].getElem2());
         extDataVec.push_back(elem);
      }

      dia_SystemSettingRequestInfo* pRequestInfo = OSAL_NEW dia_SystemSettingRequestInfo(request->getSysSetType(),DIA_EN_SYSTEM_SETTING_LEVEL_FINALIZE,extDataVec,request->getCookie(),request->getAct());
      if ( pRequestInfo )
      {
         mSystemSettingRequestRep[request->getAct()] = pRequestInfo;
         retCode = pInterface->processSystemSetting(pRequestInfo->mTypeID,DIA_EN_SYSTEM_SETTING_LEVEL_FINALIZE,pRequestInfo->mExtData,*this, (tCookieType)request->getAct());
      }
   }

   if ( retCode != DIA_SUCCESS )
   {
      std::vector<RemoteFinalizeSystemSettingResponseExtendedDataStruct> responseExtDataVec;
      for ( tU16 i=0; i<request->getExtendedData().size(); i++ )
      {
         RemoteFinalizeSystemSettingResponseExtendedDataStruct elem((request->getExtendedData())[i].getElem1(),(request->getExtendedData())[i].getElem2());
         responseExtDataVec.push_back(elem);
      }

      std::map<act_t,dia_SystemSettingRequestInfo*>::iterator iter = mSystemSettingRequestRep.find(request->getAct());
      if ( iter != mSystemSettingRequestRep.end() )
      {
         OSAL_DELETE iter->second;
         mSystemSettingRequestRep.erase(iter);
      }

      sendRemoteFinalizeSystemSettingResponse(request->getSysSetType(),responseExtDataVec,retCode,request->getCookie(),request->getAct());
   }
}

} //namespace asf



