/*
 * dia_ASFComponentSwUpdate.cpp
 *
 *  Created on: Dec 27, 2015
 *      Author: nbs3kor
 */

#if 1
//Redefinition of new and delete when both OSAL and std::stl is used
#define __PLACEMENT_NEW_INLINE
#endif

#ifndef __INCLUDED_DIA_FACTORY_PLUGIN__
#include <common/framework/factory/dia_FactoryPlugin.h>
#endif


#include "fcswupdatesrv/FcSwUpdateSrvProxy.h"

#ifndef __INCLUDED_DIA_COMMON_APPLICATION__
#include "common/framework/application/dia_common_application.h"
#endif

#ifndef DIA_SAFEATURESWUPDATE_H_
#include <common/framework/sysadapters/dia_SAFeatureSwUpdate.h>
#endif

#ifndef __INCLUDED_DIA_ASF_COMPONENT_SW_UPDATE__
#include "dia_ASFComponentSWUpdate.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include <common/framework/application/dia_Factory.h>
#endif

using namespace fcswupdatesrv::FcSwUpdateSrv;

namespace asf {

//------------------------------------------------------------------------------

dia_ASFComponentSWUpdate::dia_ASFComponentSWUpdate()
{
   dia_tclFnctTrace oTrace("--> dia_ASFComponentSWUpdate::dia_ASFComponentSWUpdate");

   dia_Factory* pFactory = getInstanceOfFactory();
   if ( !pFactory )
   {
      DIA_TR_ERR("!!! Error: Failed to get pointer to global factory !!");
      return;
   }

   tDiaResult retCode = pFactory->requestInitializationLevel(DIA_EN_INITLEVEL_1);
   if ( retCode != DIA_SUCCESS )
   {
      DIA_TR_ERR("!!! Error: Failed to initialize DIA_EN_INITLEVEL_1 !!");
      return;
   }

   //
   // System Adapter object
   //

   // create the ASF system adapter object
   std::shared_ptr<dia_SystemAdapterASF> pSystemAdapter = createSystemAdapter();
   boost::shared_ptr< fcswupdatesrv::FcSwUpdateSrv::FcSwUpdateSrvProxy > proxy = FcSwUpdateSrvProxy::createProxy("fcSwUpdatePort", *pSystemAdapter);

   //
   // Service Plugins
   //
   dia_SystemAdapterServicePluginASF< FcSwUpdateSrvProxy >* pSASWUpdateService =
         dia_ASFComponent::createSystemAdapterServicePlugin<FcSwUpdateSrvProxy>(
            "DIA_SASWUpadteSrv",
            proxy,
            pSystemAdapter);

   //
   // Feature Plugins
   //
   dia_SAFeatureSwUpdate* pSAFeatureSWUpdate =
         dia_ASFComponent::createSystemAdapterFeature<dia_SAFeatureSwUpdate, FcSwUpdateSrvProxy>(pSASWUpdateService);

   if ( pSAFeatureSWUpdate )
   {
      if (assignInterfaceAndNotifier<dia_ISwUpdate,dia_ISwUpdateListener,dia_ISwUpdateNotifier>(pSAFeatureSWUpdate) != DIA_SUCCESS)
      {
         DIA_TR_ERR("!!! dia_ASFComponentSWUpdate::dia_ASFComponentSWUpdate => Error: assignInterfaceAndNotifier failed");
      }
   }

}
//------------------------------------------------------------------------------

dia_ASFComponentSWUpdate::~dia_ASFComponentSWUpdate()
{
}
//------------------------------------------------------------------------------

} //namespace asf

