
#if 1
//Redefinition of new and delete when both OSAL and std::stl is used
#define __PLACEMENT_NEW_INLINE
#endif

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include <common/framework/application/dia_Factory.h>
#endif

#ifndef __INCLUDED_DIA_MAIN__
#include "common/depricated/dia_main.h"
#endif

#define SCD_S_IMPORT_INTERFACE_GENERIC
#include "scd_if.h"

#include "dia_AILComponent.h"

#ifdef VARIANT_S_FTR_AIL_COMPONENT_FIFO
#define _OPEN_SYS
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DIAGNOSTICS_BASE
#include "trcGenProj/Header/dia_AILComponent.cpp.trc.h"
#endif
namespace asf {


dia_AILComponent::dia_AILComponent():
      m_pAilApp(0)
{
   et_vTraceOpen();

   dia_tclFnctTrace trc("dia_AILComponent::dia_AILComponent");

#ifdef VARIANT_S_FTR_AIL_COMPONENT_FIFO
   unsigned long starttime = OSAL_ClockGetElapsedTime();
   char fn[] = "/run/diagnosis.fifo";
   if (mkfifo(fn, S_IRWXU) != 0)
   {
      ETG_TRACE_FATAL(("!!! dia_AILComponent::dia_AILComponent => ERROR: mkfifo failed!"));
   }
   else
   {
      ETG_TRACE_USR4(("--- dia_AILComponent::dia_AILComponent => mkfifo success at %d.", starttime));

      int rfd = open(fn, O_RDONLY);
      if (rfd < 0)
      {
         ETG_TRACE_FATAL(("!!! dia_AILComponent::dia_AILComponent => ERROR: open fifo failed!"));
      }
      else
      {
         char in[20];
         int numBytes = 0;
         while ((numBytes = read(rfd, in, 3)) < 1)
         {
            ETG_TRACE_FATAL(("!!! dia_AILComponent::dia_AILComponent => ERROR: read from fifo failed! (%d bytes)", numBytes));
         }

         ETG_TRACE_USR4(("--- dia_AILComponent::dia_AILComponent => read %d bytes from fifo.", numBytes));

      }

      close(rfd);
   }
#endif
#ifndef __STARTUP_REFACTORING_ENABLE__  //moved to Application Bundle
   if(FALSE == amt_bInit())
   {
      ETG_TRACE_ERR(("!!! dia_AILComponent::dia_AILComponent => ERROR: amt_bInit failed"));
   }

   if(FALSE == scd_init())
   {
      ETG_TRACE_ERR(("!!! dia_AILComponent::dia_AILComponent => ERROR: scd_init failed"));
   }
#endif
#if 0
   if(FALSE == exh_bInitExceptionHandling()) //lint !e774: Boolean within 'if' always evaluates to False
   {
      ETG_TRACE_ERR(("!!! dia_AILComponent::dia_AILComponent => ERROR: exh_bInitExceptionHandling failed"));
   }
#endif
   if(scd_bAppRegistryAvailable(CCA_C_U16_APP_DIAGDEBUG))
   {
      ETG_TRACE_COMP(("--- dia_AILComponent::dia_AILComponent => Trying to start CCA_C_U16_APP_DIAGDEBUG"));

      dia_Factory* pFactory = getInstanceOfFactory();
      if ( !pFactory )
      {
         DIA_TR_ERR("!!! Error: Failed to get pointer to global factory !!");
         return;
      }

      tDiaResult retCode = pFactory->requestInitializationLevel(DIA_EN_INITLEVEL_1);
      if ( retCode != DIA_SUCCESS )
      {
         DIA_TR_ERR("!!! Error: Failed to initialize DIA_EN_INITLEVEL_1 !!");
         return;
      }

      m_pAilApp = diagnostics_tclApp::getInstance();
      if (m_pAilApp != NULL)
      {
         m_pAilApp->bInitInstance(0, CCA_C_U16_APP_DIAGDEBUG);
      }
   }
}


dia_AILComponent::~dia_AILComponent()
{
   _BP_TRY_BEGIN
   {
      if (m_pAilApp)
      {
         OSAL_DELETE m_pAilApp;
         m_pAilApp = 0;
      }
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_AILComponent::~dia_AILComponent !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

} //namespace asf


