/*
 * dia_datapool.h
 *
 *  Created on: 15.01.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_DATAPOOL__
#define __INCLUDED_DIA_DATAPOOL__

//lint -e451 Warning: Header file repeatedly included but does not have a standard include guard
//lint -e537 Warning: Repeated include file

#ifndef __DIA_UNIT_TESTING__

#ifndef __INCLUDED_DIA_EXTERN_DP_IF__
#define DP_S_IMPORT_INTERFACE_BASE
#define DP_S_IMPORT_INTERFACE_DPPERSACCESS
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"
#define __INCLUDED_DIA_EXTERN_DP_IF__
#endif

#else

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#define DIA_MAX_DPELEM_BUFFER_SIZE 10000

class dp_tclBaseElement
{
public:
   typedef enum {
      eDpElementTypeKds,
      eDpElementTypeRegistry,
      eDpElementTypePersistent,
      eDpElementTypeRuntime
   }EDpElementTypes;

   typedef enum {
      eDpStoringTypeNone,
      eDpStoringTypeImmediately,
      eDpStoringTypeShutdown,
      eDpStoringTypeDelayed,
      eDpStoringTypeCyclic,
      eDpStoringTypeForce
   }EDpStoringTypes;

   typedef enum {
      eDpDefSetNone,
      eDpDefSetProduction,
      eDpDefSetCustomer,
      eDpDefSetUser
   }EDpDefSetTypes;

   typedef enum {
      eDpElemLoaded = 0,
      eDpElemInit,
      eDpElemSet
   }EDpElemState;

//   typedef struct {
//      DP_tpvDataUpdateCallback pCallback;
//      tU32  u32Event;
//   } TFuncNotEntry;


   dp_tclBaseElement(const tChar* pcElementName, tS32 s32Hash = 0)
      : mName(pcElementName), mLength(0), mHash(s32Hash), mVersion(0)
   {}
   virtual ~dp_tclBaseElement() {}

   tVoid vChangeProperties(tBool bVarSize, tU16 u16AccessType, EDpElementTypes tElemType, EDpStoringTypes tStoringType, tU8 u8VarType, tU32 u32DefSetMode) {
      _tProperty.u16AccessType = u16AccessType;
      _tProperty.tElemType = tElemType;
      _tProperty.tStoringType = tStoringType;
      _tProperty.bVarSize = bVarSize;
      _tProperty.u8VarType = u8VarType;
      _tProperty.u32DefSetMode = u32DefSetMode;
      return;
   }

   virtual tU32 u32GetDataLength() const { return mLength; }
   virtual tS32 s32GetHash() const { return mHash; }
   virtual void vSetVersion(tU8 u8Version) { mVersion = u8Version; }
   virtual tU8 u8GetVersion() const { return mVersion; }

   EDpElementTypes eGetElementType() const {return _tProperty.tElemType;};
   EDpElemState eGetElementState() const {return _tProperty.tElemState;};
   tVoid vSetElementState( EDpElemState eState) {_tProperty.tElemState = eState;};

   virtual tBool bFillData(tVoid* pStreamStart, tU32 u32StreamLength) {
      ::memcpy(mDataBuffer, (tU8*) pStreamStart, u32StreamLength);
      mLength = u32StreamLength;
      return TRUE;
   }
//   virtual void vFillElementProperty(dp_tclBaseElement* pElemSrc) = 0;

   virtual void* pvGetData() { return (void*) mDataBuffer; }

protected:
   typedef struct TDpElementProperty{
      tU8  u8Version;
      tU16 u16AccessType;
      tBool bVarSize;
      EDpElementTypes tElemType;
      EDpStoringTypes tStoringType;
      tU32 u32StoringIntervall;
      tU32 u32NextStoreTime;
      tBool bValidated;
      tBool bRestore;
      EDpDefSetTypes tDefsetType;
      EDpElemState tElemState;
      tBool bExport2Registry;
      tU8  u8VarType;
      tU32  u32DefSetMode;
   } TDpElementProperty;

protected:
   dp_tclBaseElement();

public:
   const tChar* mName;
   tU32 mLength;
   tS32 mHash;
   tU8  mVersion;
   tU8  mDataBuffer[DIA_MAX_DPELEM_BUFFER_SIZE];
   TDpElementProperty _tProperty;
};

extern "C"
{
   void DP_vCreateDatapool( void );
   tS32 DP_s32SetElement(tU32 poolID, dp_tclBaseElement* pElem, tU16 accessID);
   tS32 DP_s32GetElement(tU32 poolID, dp_tclBaseElement* pElem, tU16 accessID);
   tS32 DP_s32SetConfig ( tU32 poolID, tU32 u32AccessId, tU32 u32Timeout);
   tS32 DP_s32StorePoolNow(tU32 u32PoolId, tU32 u32AccessId);
};

#endif

//lint +e451 Warning: Header file repeatedly included but does not have a standard include guard
//lint +e537 Warning: Repeated include file

#endif /* DIA_DATAPOOL_H_ */
