/*!
 * \file       dia_PDXParserStrategyTinyXML.h
 *
 * \brief      TBD
 *
 * \details    TBD
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreODX
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_PDX_PARSER_STRATEGY_TINYXML__
#define __INCLUDED_DIA_PDX_PARSER_STRATEGY_TINYXML__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_PDX_TYPES__
#include <common/framework/odx/pdx/dia_PDXTypes.h>
#endif

#ifndef __INCLUDED_DIA_PDX_PARSER_STRATEGY__
#include <common/framework/odx/pdx/dia_PDXParserStrategy.h>
#endif

namespace tinyxml2 {
class XMLElement;
class XMLNode;
}

namespace dia {
namespace odx {

class DataBlock;
class DataBlockRef;
class EcuMem;
class ExpectedIdent;
class Flash;
class FlashData;
class IdentValue;
class Mem;
class NamedObject;
class ODX;
class OwnIdent;
class Segment;
class Session;
class PDXABlock;
class PDXCatalog;
class PDXFile;

/**
 * \class   dia::odx::PDXParserStrategyTinyXML
 *
 * \brief   TBD
 *
 * \ingroup diaCoreODX
 */

class PDXParserStrategyTinyXML
   : public PDXParserStrategy
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(PDXParserStrategyTinyXML);

public:
   //! class constructor
   PDXParserStrategyTinyXML ( const std::string& name ) : PDXParserStrategy(name) {}
   //! class destructor
   virtual ~PDXParserStrategyTinyXML ( void ) {}

   //! initialize the seed
   virtual tDiaResult parseIndexXML ( const std::string& indexFile );
//   //! initialize the seed
//   virtual tDiaResult validIndexXML ( void ) = 0;
   //! initialize the seed
   virtual tDiaResult parseOdxFlashContainer ( const std::string& odxFile );
   //! initialize the seed
//   virtual tDiaResult parseIndexXML ( void ) = 0;

protected:
   PDXParserStrategyTinyXML ( void );

   tDiaResult evaluateCatalog ( dia::odx::PDXCatalog& oPDXCatalog );
   tDiaResult evaluateODXF ( dia::odx::ODX& oODX );

   tDiaResult readODX ( tinyxml2::XMLNode* pNode, dia::odx::ODX* pODX );
   tDiaResult readFlashData  ( tinyxml2::XMLElement* parent, dia::odx::FlashData** ppODXFlashData, dia::odx::ODX& oODX );
   tDiaResult readFlashDataExtern ( tinyxml2::XMLElement* pFlashData, dia::odx::FlashData** ppODXFlashData, dia::odx::ODX& oODX );
   tDiaResult readFlashDataIntern ( tinyxml2::XMLElement* pFlashData, dia::odx::FlashData** ppODXFlashData, dia::odx::ODX& oODX );
   tDiaResult readFlashDatas ( tinyxml2::XMLElement* parent, dia::odx::Mem* pODXMem, dia::odx::ODX& oODX );
   tDiaResult readDataFormat ( tinyxml2::XMLElement* pElement, dia::odx::FlashData* pODXFlashData, dia::odx::ODX& oODX );
   tDiaResult readSegments ( tinyxml2::XMLElement* pElement, dia::odx::DataBlock* pODXDataBlock, dia::odx::ODX& oODX );
   tDiaResult readSegment ( tinyxml2::XMLElement* pSegment, dia::odx::Segment** pODXSegment, dia::odx::DataBlock& oODXDataBlock, dia::odx::ODX& oODX );
   tDiaResult readLogicalBlockIndex ( tinyxml2::XMLElement* pOwnIdent, dia::odx::DataBlock* pODXDataBlock );
   tDiaResult readOwnIdents ( tinyxml2::XMLElement* pOwnIdent, dia::odx::DataBlock* pODXDataBlock, dia::odx::ODX& oODX );
   tDiaResult readOwnIdent ( tinyxml2::XMLElement* pOwnIdent, dia::odx::OwnIdent** ppODXOwnIdent, dia::odx::ODX& oODX );
   tDiaResult readFlashDataRef ( tinyxml2::XMLElement& oElement, dia::odx::DataBlock& oODXDataBlock, dia::odx::ODX& oODX );
   tDiaResult readDataBlocks ( tinyxml2::XMLElement* pElement, dia::odx::Mem* pODXMem, dia::odx::ODX& oODX );
   tDiaResult readDataBlock ( tinyxml2::XMLElement* pElement, dia::odx::DataBlock** ppODXDataBlock, dia::odx::Mem& oParent, dia::odx::ODX& oODX );
   tDiaResult readDataBlockRefs ( tinyxml2::XMLElement* pElement, dia::odx::Session* pODXSession, dia::odx::ODX& oODX );
   tDiaResult readDataBlockRef ( tinyxml2::XMLElement* pElement, dia::odx::DataBlockRef** ppODXDataBlockRef, dia::odx::Session& oSession, dia::odx::ODX& oODX );
   tDiaResult readExpectedIdents ( tinyxml2::XMLElement* pElement, dia::odx::Session* pODXSession, dia::odx::ODX& oODX );
   tDiaResult readExpectedIdent ( tinyxml2::XMLElement* pExpectedIdent, dia::odx::ExpectedIdent** pODXExpectedIdent, dia::odx::ODX& oODX );
   tDiaResult readSessions ( tinyxml2::XMLElement* pElement, dia::odx::Mem* pODXMem, dia::odx::ODX& oODX );
   tDiaResult readSession ( tinyxml2::XMLElement* pElement, dia::odx::Session** ppODXSession, dia::odx::Mem& oODXMem, dia::odx::ODX& oODX );
   tDiaResult readMem ( tinyxml2::XMLElement* pEcuMem, dia::odx::EcuMem* pODXEcuMem, dia::odx::ODX& oODX );
   tDiaResult readEcuMems ( tinyxml2::XMLElement* pElement, dia::odx::Flash* pODXFlash, dia::odx::ODX& oODX );
   tDiaResult readEcuMem ( tinyxml2::XMLElement* pEcuMems, dia::odx::EcuMem** pODXEcuMem, dia::odx::ODX& oODX );
   tDiaResult readFlash ( tinyxml2::XMLNode* pNode, dia::odx::ODX& oODX );
   tDiaResult readSourceStartAddress( tinyxml2::XMLElement* pSegment, dia::odx::Segment& oODXSegment, dia::odx::ODX& oODX );
   tDiaResult readUncompressedSize( tinyxml2::XMLElement* pSegment, dia::odx::Segment& oODXSegment, dia::odx::ODX& oODX );
   tDiaResult readIdentValues ( tinyxml2::XMLElement* pElement, dia::odx::OwnIdent* pODXOwnIdent, dia::odx::ODX& oODX );
   tDiaResult readIdentValues ( tinyxml2::XMLElement* pElement, dia::odx::ExpectedIdent* pODXExpectedIdent, dia::odx::ODX& oODX );
   tDiaResult readIdentValue ( tinyxml2::XMLElement* pElement, dia::odx::IdentValue** pODXIdentValue, dia::odx::ODX& oODX );
   tDiaResult readAttributeDataBlockType ( tinyxml2::XMLElement& oElement, dia::odx::DataBlock& oDataBlock );

   tDiaResult readCatalog ( tinyxml2::XMLNode* pNode, dia::odx::PDXCatalog* pPDXCatalog );
   tDiaResult readABlocks ( tinyxml2::XMLNode* pElement, dia::odx::PDXCatalog& oPDXCatalog );
   tDiaResult readABlock ( tinyxml2::XMLElement* pElement, dia::odx::PDXABlock** ppPDXABlock, dia::odx::PDXCatalog& oPDXCatalog );
   tDiaResult readFiles ( tinyxml2::XMLElement* pElement, dia::odx::PDXABlock* pPDXABlock, dia::odx::PDXCatalog& oPDXCatalog );
   tDiaResult readFile ( tinyxml2::XMLElement* pElement, dia::odx::PDXFile** ppPDXFile, dia::odx::PDXCatalog& oPDXCatalog );
   tDiaResult readAttributeCreationDate ( tinyxml2::XMLElement* pFileElement, dia::odx::PDXFile* pPDXFile );
   tDiaResult readAttributeMimeType ( tinyxml2::XMLElement* pFileElement, dia::odx::PDXFile* pPDXFile );

   tDiaResult readAttributeID ( tinyxml2::XMLElement* pElement, dia::odx::NamedObject* pODXNamedObject );
   tDiaResult readAttributeOID ( tinyxml2::XMLElement* pElement, dia::odx::NamedObject* pODXNamedObject );
   tDiaResult readShortName ( tinyxml2::XMLElement* pElement, dia::odx::NamedObject* pODXNamedObject );
   tDiaResult readShortName ( tinyxml2::XMLNode* pElement, dia::odx::NamedObject* pODXNamedObject );
   tDiaResult readLongName ( tinyxml2::XMLElement* pElement, dia::odx::NamedObject* pODXNamedObject );
   tDiaResult readLongName ( tinyxml2::XMLNode* pNode, dia::odx::NamedObject* pODXNamedObject );

protected:
   std::string mIndexFileName;
   std::string mODXFileName;
   std::string mPath;
};

} // namespace odx
} // namespace dia

#endif /* __INCLUDED_DIA_PDX_PARSER_STRATEGY_TINYXML__ */
