/*!
 * \file       dia_PDXParserStrategy.h
 *
 * \brief      TBD
 *
 * \details    TBD
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreODX
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_PDX_PARSER_STRATEGY__
#define __INCLUDED_DIA_PDX_PARSER_STRATEGY__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_PDX_TYPES__
#include <common/framework/odx/pdx/dia_PDXTypes.h>
#endif

namespace dia {
namespace odx {

class PDXCatalog;
class ODX;
/**
 * \class   dia::odx::dia_PDXParserStrategy
 *
 * \brief   TBD
 *
 * \ingroup diaCoreODX
 */

class PDXParserStrategy
   : public dia_ObjectWithUID
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(PDXParserStrategy);

public:
   //! class constructor
   PDXParserStrategy ( const std::string& name ) : dia_ObjectWithUID(name), mpPDXCatalog(0), mpODX(0) {}
   //! class destructor
   virtual ~PDXParserStrategy ( void ) {}

   //! initialize the seed
   virtual tDiaResult parseIndexXML ( const std::string& indexFile ) = 0;
   //! initialize the seed
   virtual tDiaResult parseOdxFlashContainer ( const std::string& odxFile ) = 0;

   //! return pointer to the catalog object of the PDX container
   const PDXCatalog* getPdxCatalog ( void ) const { return mpPDXCatalog; }
   //! return pointer to the ODX object of the PDX container
   const ODX* getODX ( void ) const { return mpODX; }

protected:
   PDXParserStrategy ( void );

protected:
   PDXCatalog* mpPDXCatalog;
   ODX* mpODX;
};

}
}

#endif /* __INCLUDED_DIA_PDX_PARSER_STRATEGY__ */
