/*!
 * \file       dia_PDXFile.h
 *
 * \brief      TBD
 *
 * \details    TBD
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreODX
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_PDX_FILE__
#define __INCLUDED_DIA_PDX_FILE__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_PDX_TYPES__
#include <common/framework/odx/pdx/dia_PDXTypes.h>
#endif

//#ifndef __INCLUDED_DIA_ODX_NAMED_OBJECT__
//#include <common/framework/odx/dia_ODXNamedObject.h>
//#endif

class dia_File;

namespace dia {
namespace odx {

class PDXCatalog;

/**
 * \class   dia::odx::PDXFile
 *
 * \brief   TBD
 *
 * \ingroup diaCoreODX
 */

class PDXFile
//   : public NamedObject
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(PDXFile);

public:
   PDXFile ( void ) : mpCatalog(0), mpFile(0) {}
   PDXFile ( PDXCatalog& catalog ) : mpCatalog(&catalog), mpFile(0) {}

   void setCatalog ( PDXCatalog& catalog ) { mpCatalog = &catalog; }

   tDiaResult evaluate ( void );

   const std::string& getFileName ( void ) const { return mFileName; }
   void setFileName ( const std::string& fileName ) { mFileName = fileName; setSuffix(mFileName); }
   dia::UID getHashCodeOfFileName ( void ) { return dia_getHashCodeFromString(mFileName); }

   const std::string& getCreationDate ( void ) const { return mCreationDate; }
   void setCreationDate ( const std::string& creationDate ) { mCreationDate = creationDate; }
   dia::UID getHashCodeOfCreationDate ( void ) { return dia_getHashCodeFromString(mCreationDate); }

   const std::string& getMimeType ( void ) const { return mMimeType; }
   void setMimeType ( const std::string& mimeType ) { mMimeType = mimeType; }
   dia::UID getHashCodeOfMimeType ( void ) { return dia_getHashCodeFromString(mMimeType); }

   const std::string& getSuffix ( void ) const { return mFileSuffix; }

protected:
   void setSuffix ( const std::string& fileName );

protected:
   PDXCatalog* mpCatalog;
   std::string mCreationDate;
   std::string mMimeType;
   std::string mFileName;
   std::string mFileSuffix;
   dia_File*   mpFile;
};

}
}

#endif /* __INCLUDED_DIA_PDX_FILE__ */
