/*!
 * \file       dia_ODXSegment.h
 *
 * \brief      TBD
 *
 * \details    TBD
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreODX
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_ODX_SEGMENT__
#define __INCLUDED_DIA_ODX_SEGMENT__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ODX_TYPES__
#include <common/framework/odx/dia_ODXTypes.h>
#endif

#ifndef __INCLUDED_DIA_ODX_NAMED_OBJECT__
#include <common/framework/odx/dia_ODXNamedObject.h>
#endif

namespace dia {
namespace odx {

class ODX;
class DataBlock;

/**
 * \class   dia::odx::Segment
 *
 * \brief   TBD
 *
 * \ingroup diaCoreODX
 */

class Segment
   : public NamedObject
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(Segment);

public:
   Segment ( void ) : mpODXDataBlock(0), mpODX(0), mStartAddress(0), mUncompressedSize(0), wasStartAddressAssigned(false), wasUncompressedSizeAssigned(false) {}
   Segment ( const DataBlock& oODXDataBlock, const ODX& oODX ) : mpODXDataBlock(&oODXDataBlock), mpODX(&oODX), mStartAddress(0), mUncompressedSize(0), wasStartAddressAssigned(false), wasUncompressedSizeAssigned(false) {}

   const DataBlock* getParent ( void ) const { return mpODXDataBlock; }
   void setSourceStartAddress ( tU32 startAddress ) { mStartAddress = startAddress; wasStartAddressAssigned = true; }
   tU32 getSourceStartAddress ( void ) const { return mStartAddress; }

   void setUncompressedSize ( tU32 uncompressedSize ) { mUncompressedSize = uncompressedSize; wasUncompressedSizeAssigned = true; }
   tU32 getUncompressedSize ( void ) const { return mUncompressedSize; }

   tDiaResult evaluate ( void ) const;

protected:
   const DataBlock* mpODXDataBlock;
   const ODX* mpODX;
   tU32 mStartAddress;
   tU32 mUncompressedSize;
   bool wasStartAddressAssigned;
   bool wasUncompressedSizeAssigned;
};

}
}

#endif /* __INCLUDED_DIA_ODX_SEGMENT__ */
