/*!
 * \file       dia_ODXIdRef.h
 *
 * \brief      TBD
 *
 * \details    TBD
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreODX
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_ODX_ID_REF__
#define __INCLUDED_DIA_ODX_ID_REF__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ODX_TYPES__
#include <common/framework/odx/dia_ODXTypes.h>
#endif

namespace dia {
namespace odx {

/**
 * \class   dia::odx::IdRef
 *
 * \brief   TBD
 *
 * \ingroup diaCoreODX
 */

class IdRef
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(IdRef);

public:
   IdRef ( void ) : mIdRef(gUnknownIdRef) {}
   IdRef ( const std::string& idRef ) : mIdRef(idRef) {}

   const std::string& getIdRef ( void ) const { return mIdRef; }
   void setIdRef ( const std::string& idRef ) { mIdRef = idRef; }
   dia::UID getHashCodeOfIdRef ( void ) { return dia_getHashCodeFromString(mIdRef); }

protected:
   std::string mIdRef;
};

}
}

#endif /* __INCLUDED_DIA_ODX_ID_REF__ */
