/*!
 * \file       dia_ODXFlashDataRef.cpp
 *
 * \brief      TBD
 *
 * \details    TBD
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreODX
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#include <common/framework/odx/dia_ODXFlashDataRef.h>
#include <common/framework/odx/dia_ODXFlashData.h>
#include <common/framework/odx/dia_ODXDataBlock.h>
#include <common/framework/odx/dia_ODXMem.h>

namespace dia {
namespace odx {

//---------------------------------------------------------------------------------------------------------------------

tDiaResult
FlashDataRef::evaluate ( void )
{
   dia::ScopeTrace oTrc("FlashDataRef::evaluate");

   if ( getIdRef().empty() )
   {
      DIA_TR_INF("        +--> EVALUATING FlashDataRef (NO ID-REF FOUND)");
      return DIA_FAILED;
   }

   DIA_TR_INF("        +--> EVALUATING FlashDataRef ID-REF\"%s\"",getIdRef().c_str());

   if ( !mpODXDataBlock ) return DIA_FAILED;
   if ( !mpODXDataBlock->getParent() ) return DIA_FAILED;

   tDiaResult retCode = DIA_FAILED;
   const Mem* pMem = mpODXDataBlock->getParent();
   const std::list<FlashData*>& flashDatas = pMem->getFlashDatas();
   std::list<FlashData*>::const_iterator iter = flashDatas.begin();
   for ( ; iter != flashDatas.end(); ++iter )
   {
      if ( (*iter) && ((*iter)->getID() == getIdRef()) )
      {
         DIA_TR_INF("          +--> FLASH-DATA-REF RESOLVED");
         mpFlashData = (*iter);
         retCode = DIA_SUCCESS;
         break;
      }
   }

   return retCode;
}

}
}




