/*!
 * \file       dia_ODXFlashDataIntern.h
 *
 * \brief      TBD
 *
 * \details    TBD
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreODX
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_ODX_FLASH_DATA_INTERN__
#define __INCLUDED_DIA_ODX_FLASH_DATA_INTERN__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ODX_TYPES__
#include <common/framework/odx/dia_ODXTypes.h>
#endif

#ifndef __INCLUDED_DIA_ODX_FLASH_DATA__
#include <common/framework/odx/dia_ODXFlashData.h>
#endif

namespace dia {
namespace odx {

/**
 * \class   dia::odx::FlashDataIntern
 *
 * \brief   TBD
 *
 * \ingroup diaCoreODX
 */

class FlashDataIntern
   : public FlashData
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(FlashDataIntern);

public:
   FlashDataIntern ( const ODX& oODX ) : FlashData(DIA_ODX_FLASHDATA_TYPE_INTERN,oODX), mDID(0), mNumOfBytes(0) {}
   virtual ~FlashDataIntern ( void ) {}

   tDiaResult evaluate ( void );

   virtual tDiaResult setType ( const std::string& /*dataType*/ ) { return ( mType == DIA_ODX_FLASHDATA_TYPE_INTERN ) ? DIA_SUCCESS : DIA_FAILED; }

   const std::vector<tU8>& getData ( void ) const { return mData; }
   tDiaResult setData ( const std::vector<tU8>& data ) { mData = data; return DIA_SUCCESS; }

   void setDID ( tU16 did ) { mDID = did; }
   tU16 getDID ( void ) const { return mDID; }

   void setNumOfBytes ( tU16 numOfBytes ) { mNumOfBytes = numOfBytes; }
   tU16 getNumOfBytes ( void ) const { return mNumOfBytes; }

protected:
   FlashDataIntern ( void );

protected:
   std::vector<tU8> mData;
   tU16 mDID;
   tU16 mNumOfBytes;
};

}
}

#endif /* __INCLUDED_DIA_ODX_FLASH_DATA_INTERN__ */
