/*
 * dia_ODXFlashDataIntern.cpp
 *
 *  Created on: 23.11.2016
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_ODX__
#include <common/framework/odx/dia_ODX.h>
#endif

#ifndef __INCLUDED_DIA_ODX_FLASH_DATA_INTERN__
#include <common/framework/odx/dia_ODXFlashDataIntern.h>
#endif

const int cSizeOfDID    = 2;
const int cSizeOfLength = 1;

namespace dia {
namespace odx {

//---------------------------------------------------------------------------------------------------------------------

tDiaResult
FlashDataIntern::evaluate ( void )
{
   dia::ScopeTrace oTrc("FlashDataIntern::evaluate");

   DIA_TR_INF("          +--> EVALUATING FLASH DATA \"%s\" (INTERN)",getShortName().c_str());

   if ( !mpODX ) return DIA_FAILED;

   tDiaResult retCode = DIA_FAILED;

   if ( mData.size() )
   {
      DIA_TR_INF("            +--> %zu DATA BYTES FOUND",mData.size());
      if ( mData.size() >= (cSizeOfDID + cSizeOfLength) )
      {
         tU16 DID = (tU16) ((((tU32) mData[0]) << 8) + ((tU32) mData[1]));
         tU16 numOfBytes = (cSizeOfLength == 1) ? ((tU16) mData[2]) : ((tU16) ((((tU32) mData[2]) << 8) + ((tU32) mData[3])));
         DIA_TR_INF("            +--> DID = 0x%04x",DID);
         DIA_TR_INF("            +--> NUMBYTES = %d",numOfBytes);
         setDID(DID);
         setNumOfBytes(numOfBytes);
         retCode = DIA_SUCCESS;
      }
   }

   return retCode;
}

}
}









