/*!
 * \file       dia_ODXFlashDataExtern.h
 *
 * \brief      TBD
 *
 * \details    TBD
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreODX
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_ODX_FLASH_DATA_EXTERN__
#define __INCLUDED_DIA_ODX_FLASH_DATA_EXTERN__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ODX_TYPES__
#include <common/framework/odx/dia_ODXTypes.h>
#endif

#ifndef __INCLUDED_DIA_ODX_FLASH_DATA__
#include <common/framework/odx/dia_ODXFlashData.h>
#endif

class dia_File;

namespace dia {
namespace odx {

/**
 * \class   dia::odx::FlashDataExtern
 *
 * \brief   TBD
 *
 * \ingroup diaCoreODX
 */

class FlashDataExtern
   : public FlashData
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(FlashDataExtern);

public:
   FlashDataExtern ( const ODX& oODX ) : FlashData(DIA_ODX_FLASHDATA_TYPE_EXTERN,oODX), mSizeOfData(0), mIsLateBound(false), mpFile(0) {}
   virtual ~FlashDataExtern ( void ) {}

   tDiaResult evaluate ( void );

   virtual tDiaResult setType ( const std::string& /*dataType*/ ) { return ( mType == DIA_ODX_FLASHDATA_TYPE_EXTERN ) ? DIA_SUCCESS : DIA_FAILED; }

   const std::string& getDataFileName ( void ) const { return mDataFileName; }
   tDiaResult setDataFileName ( const std::string& fileName ) { mDataFileName = fileName; return DIA_SUCCESS; }
   dia::UID getHashCodeOfDataFileName ( void ) { return dia_getHashCodeFromString(mDataFileName); }

   bool isLateBound ( void ) const { return mIsLateBound; }
   void setLateBound ( bool mode = true ) { mIsLateBound = mode; }

   //! read data from file and put it to buffer
   virtual tDiaResult getData ( std::vector<tU8>& data );
   //! get size of data
   virtual tU32 getSizeOfData(void) { return mSizeOfData; }

protected:
   FlashDataExtern ( void );

protected:
   std::string mDataFileName;
   tU32 mSizeOfData; //in bytes
   bool mIsLateBound;
   dia_File* mpFile;
};

}
}

#endif /* __INCLUDED_DIA_ODX_FLASH_DATA_EXTERN__ */
