/*!
 * \file       dia_ODXFlashData.h
 *
 * \brief      TBD
 *
 * \details    TBD
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreODX
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_ODX_FLASH_DATA__
#define __INCLUDED_DIA_ODX_FLASH_DATA__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ODX_TYPES__
#include <common/framework/odx/dia_ODXTypes.h>
#endif

#ifndef __INCLUDED_DIA_ODX_NAMED_OBJECT__
#include <common/framework/odx/dia_ODXNamedObject.h>
#endif

namespace dia {
namespace odx {

class ODX;

/**
 * \class   dia::odx::FlashData
 *
 * \brief   TBD
 *
 * \ingroup diaCoreODX
 */

class FlashData
   : public NamedObject
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(FlashData);

public:
   virtual ~FlashData ( void ) {}

   const std::string& getType ( void ) const { return mType; }
   virtual tDiaResult setType ( const std::string& dataType ) { mType = dataType; return DIA_SUCCESS; }
   dia::UID getHashCodeOfType ( void ) { return dia_getHashCodeFromString(mType); }

   const std::string& getDataFormat ( void ) const { return mDataFormat; }
   virtual tDiaResult setDataFormat ( const std::string& dataFormat ) { mDataFormat = dataFormat; return DIA_SUCCESS; }
   dia::UID getHashCodeOfDataFormat ( void ) { return dia_getHashCodeFromString(mDataFormat); }

   virtual tDiaResult evaluate ( void ) = 0;

   void setODX ( const ODX& oODX ) { mpODX = &oODX; }

protected:
   FlashData ( void ) : mpODX(0) {}
   FlashData ( const ODX& oODX ) : mpODX(&oODX) {}
   FlashData ( const std::string& dataType, const ODX& oODX  ) : mpODX(&oODX), mType(dataType), mDataFormat(gUnknownDataFormat) {}

protected:
   const ODX* mpODX;
   std::string mType;
   std::string mDataFormat;
};

}
}

#endif /* __INCLUDED_DIA_ODX_FLASH_DATA__ */
