/*!
 * \file       dia_ODXExpectedIdent.h
 *
 * \brief      TBD
 *
 * \details    TBD
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreODX
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_ODX_EXPECTED_IDENT__
#define __INCLUDED_DIA_ODX_EXPECTED_IDENT__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ODX_TYPES__
#include <common/framework/odx/dia_ODXTypes.h>
#endif

#ifndef __INCLUDED_DIA_ODX_NAMED_OBJECT__
#include <common/framework/odx/dia_ODXNamedObject.h>
#endif

namespace dia {
namespace odx {

class ODX;
class IdentValue;

/**
 * \class   dia::odx::ExpectedIdent
 *
 * \brief   TBD
 *
 * \ingroup diaCoreODX
 */

class ExpectedIdent
   : public NamedObject
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(ExpectedIdent);

public:
   ExpectedIdent ( void ) : mpODX(0) {}
   ExpectedIdent ( const ODX& oODX ) : mpODX(&oODX) {}
   virtual ~ExpectedIdent ( void );

   tDiaResult evaluate ( void );

   tDiaResult addIdentValue ( IdentValue& identValue );
// tDiaResult removeIdentValue ( IdentValue& identValue );
   const std::list<IdentValue*>& getIdentValues ( void ) const { return mIdentValues; }

protected:
   const ODX* mpODX;
   std::list<IdentValue*> mIdentValues;
};

}
}

#endif /* __INCLUDED_DIA_ODX_EXPECTED_IDENT__ */
