/*!
 * \file       dia_ODXExpectedIdent.cpp
 *
 * \brief      TBD
 *
 * \details    TBD
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreODX
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#include <common/framework/odx/dia_ODXExpectedIdent.h>
#include <common/framework/odx/dia_ODXIdentValue.h>

namespace dia {
namespace odx {

//---------------------------------------------------------------------------------------------------------------------

ExpectedIdent::~ExpectedIdent ( void )
{
   DIA_IMPL_LIST_REPOSITORY_TEAR_DOWN(IdentValue,mIdentValues);
}

//---------------------------------------------------------------------------------------------------------------------

tDiaResult
ExpectedIdent::evaluate ( void )
{
   dia::ScopeTrace oTrc("ExpectedIdent::evaluate");

   DIA_TR_INF("          +--> EVALUATING EXPECTED IDENT \"%s\"",getShortName().c_str());

   tDiaResult retCode = DIA_SUCCESS;

   DIA_TR_INF("            +--> NUMBER OF IDENT VALUES = %zu",mIdentValues.size());
   std::list<IdentValue*>::iterator iter = mIdentValues.begin();
   for ( ; iter != mIdentValues.end(); ++iter )
   {
      retCode = (*iter)->evaluate();
      if ( retCode != DIA_SUCCESS ) break;
   }

   return retCode;
}

//---------------------------------------------------------------------------------------------------------------------

tDiaResult
ExpectedIdent::addIdentValue ( IdentValue& identValue )
{
   tDiaResult retCode = DIA_E_ALREADY_EXISTS;

   std::list<IdentValue*>::iterator iter = std::find(mIdentValues.begin(), mIdentValues.end(), (&identValue));
   if ( iter == mIdentValues.end() )
   {
      mIdentValues.push_back(&identValue);
      retCode = DIA_SUCCESS;
   }

   return retCode;
}

}
}




