/*!
 * \file       dia_ODXEcuMem.h
 *
 * \brief      TBD
 *
 * \details    TBD
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreODX
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_ODX_ECU_MEM__
#define __INCLUDED_DIA_ODX_ECU_MEM__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ODX_TYPES__
#include <common/framework/odx/dia_ODXTypes.h>
#endif

#ifndef __INCLUDED_DIA_ODX_NAMED_OBJECT__
#include <common/framework/odx/dia_ODXNamedObject.h>
#endif

namespace dia {
namespace odx {

/**
 * \class   dia::odx::EcuMem
 *
 * \brief   TBD
 *
 * \ingroup diaCoreODX
 */

class ODX;
class Mem;

class EcuMem
   : public NamedObject
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(EcuMem);

public:
   EcuMem ( void ) : mpODX(0), mpMem(0) {}
   EcuMem ( const ODX& oODX ) : mpODX(&oODX), mpMem(0) {}
   virtual ~EcuMem ( void );

   tDiaResult setMem ( Mem& mem ) { mpMem = &mem; return DIA_SUCCESS; }
   const Mem* getMem ( void ) const { return mpMem; }

   tDiaResult evaluate ( void );

protected:
   const ODX* mpODX;
   Mem* mpMem;
};

}
}

#endif /* __INCLUDED_DIA_ODX_ECU_MEM__ */
