/*!
 * \file       dia_ODXDataBlockRef.h
 *
 * \brief      TBD
 *
 * \details    TBD
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreODX
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_ODX_DATA_BLOCK_REF__
#define __INCLUDED_DIA_ODX_DATA_BLOCK_REF__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ODX_TYPES__
#include <common/framework/odx/dia_ODXTypes.h>
#endif

#ifndef __INCLUDED_DIA_ODX_ID_REF__
#include <common/framework/odx/dia_ODXIdRef.h>
#endif

namespace dia {
namespace odx {

class ODX;
class Session;
class DataBlock;

/**
 * \class   dia::odx::DataBlockRef
 *
 * \brief   TBD
 *
 * \ingroup diaCoreODX
 */

class DataBlockRef
   : public IdRef
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(DataBlockRef);

public:
   DataBlockRef ( void ) : mpODXSession(0), mpODX(0), mpDataBlock(0) {}
   DataBlockRef ( const Session& oODXSession, const ODX& oODX ) : mpODXSession(&oODXSession), mpODX(&oODX), mpDataBlock(0) {}

   const Session* getParent ( void ) const { return mpODXSession; }
   const DataBlock* getDataBlock ( void ) const { return mpDataBlock; }

   tDiaResult evaluate ( void );

   const std::string& getRefID ( void ) const { return mIdRef; }
   void setRefID ( const std::string& idRef ) { mIdRef = idRef; }

   dia::UID getHashCodeOfIdRef ( void ) { return dia_getHashCodeFromString(mIdRef); }

protected:
   const Session* mpODXSession;
   const ODX* mpODX;
   std::string mIdRef;
   const DataBlock* mpDataBlock;
};

}
}

#endif /* __INCLUDED_DIA_ODX_DATA_BLOCK_REF__ */
