/*!
 * \file       dia_ODXDataBlockRef.cpp
 *
 * \brief      TBD
 *
 * \details    TBD
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreODX
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#include <common/framework/odx/dia_ODXDataBlockRef.h>
#include <common/framework/odx/dia_ODXDataBlock.h>
#include <common/framework/odx/dia_ODXMem.h>
#include <common/framework/odx/dia_ODXSession.h>

namespace dia {
namespace odx {

//---------------------------------------------------------------------------------------------------------------------

tDiaResult
DataBlockRef::evaluate ( void )
{
   ScopeTrace oTrc("DataBlockRef::evaluate");

   if ( getIdRef().empty() )
   {
      DIA_TR_INF("        +--> EVALUATING DataBlockRef (NO ID-REF FOUND)");
      return DIA_FAILED;
   }

   DIA_TR_INF("          +--> EVALUATING DataBlockRef ID-REF\"%s\"",getIdRef().c_str());

   if ( !mpODXSession ) return DIA_FAILED;
   if ( !mpODXSession->getParent() ) return DIA_FAILED;

   tDiaResult retCode = DIA_FAILED;
   const Mem* pMem = mpODXSession->getParent();
   const std::list<DataBlock*>& dataBlocks = pMem->getDataBlocks();
   std::list<DataBlock*>::const_iterator cIter = dataBlocks.begin();
   for ( ; cIter != dataBlocks.end(); ++cIter )
   {
      DataBlock* pDataBlock = (*cIter);

      if ( pDataBlock && (pDataBlock->getID() == getIdRef()) )
      {
         DIA_TR_INF("          +--> DATABLOCK-REF RESOLVED");
         mpDataBlock = pDataBlock;
         retCode = DIA_SUCCESS;
         break;
      }
   }

   return retCode;
}

}
}






