/*!
 * \file       dia_ODXDataBlock.h
 *
 * \brief      TBD
 *
 * \details    TBD
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreODX
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_ODX_DATA_BLOCK__
#define __INCLUDED_DIA_ODX_DATA_BLOCK__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ODX_TYPES__
#include <common/framework/odx/dia_ODXTypes.h>
#endif

#ifndef __INCLUDED_DIA_ODX_NAMED_OBJECT__
#include <common/framework/odx/dia_ODXNamedObject.h>
#endif

namespace dia {
namespace odx {

class ODX;
class OwnIdent;
class Segment;
class FlashDataRef;
class Mem;

/**
 * \class   dia::odx::DataBlock
 *
 * \brief   TBD
 *
 * \ingroup diaCoreODX
 */

class DataBlock
   : public NamedObject
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(DataBlock);

public:
   DataBlock ( const Mem& oParent, const ODX& oODX ) : mpMem(&oParent), mpODX(&oODX), mType(gUnknownType), mLogicalBlockIndex(gUnknownLogicalBlockIndex), mFlashDataRef(0) {}
   DataBlock ( const std::string& blockType, const Mem& oParent, const ODX& oODX ) : mpMem(&oParent), mpODX(&oODX), mType(blockType), mLogicalBlockIndex(gUnknownLogicalBlockIndex), mFlashDataRef(0) {}
   virtual ~DataBlock ( void );

   const Mem* getParent ( void ) const { return mpMem; }

   const std::string& getType ( void ) const { return mType; }
   void setType ( const std::string& blockType ) { mType = blockType; }
   dia::UID getHashCodeOfType ( void ) { return dia_getHashCodeFromString(mType); }

   tDiaResult setFlashDataRef ( FlashDataRef& ref ) { mFlashDataRef = &ref; return DIA_SUCCESS; }
   const FlashDataRef* getFlashDataRef ( void ) const { return mFlashDataRef; }

   tDiaResult addOwnIdent ( OwnIdent& ident );
   const std::list<OwnIdent*>& getOwnIdents ( void ) const { return mOwnIdents; }

   tDiaResult addSegment ( Segment& segment );
   const std::list<Segment*>& getSegments ( void ) const { return mSegments; }

   tDiaResult setLogicalBlockIndex ( const std::string& logBlockIndx ) { mLogicalBlockIndex = logBlockIndx; return DIA_SUCCESS; }

   const std::string& getLogicalBlockIndex ( void ) const { return mLogicalBlockIndex; }

   tDiaResult evaluate ( void );

protected:
   DataBlock ( void );

protected:
   const Mem* mpMem;
   const ODX* mpODX;
   std::string mType;
   std::string mLogicalBlockIndex;
   FlashDataRef* mFlashDataRef;
   std::list<OwnIdent*> mOwnIdents;
   std::list<Segment*> mSegments;
};

}
}

#endif /* __INCLUDED_DIA_ODX_DATA_BLOCK__ */
