/*!
 * \file       dia_ODXDataBlock.cpp
 *
 * \brief      TBD
 *
 * \details    TBD
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreODX
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#include <common/framework/odx/dia_ODXDataBlock.h>
#include <common/framework/odx/dia_ODXOwnIdent.h>
#include <common/framework/odx/dia_ODXSegment.h>
#include <common/framework/odx/dia_ODXFlashDataRef.h>

namespace dia {
namespace odx {

//---------------------------------------------------------------------------------------------------------------------

DataBlock::~DataBlock ( void )
{
   delete mFlashDataRef;
   mFlashDataRef = 0;

   DIA_IMPL_LIST_REPOSITORY_TEAR_DOWN(OwnIdent,mOwnIdents);
   DIA_IMPL_LIST_REPOSITORY_TEAR_DOWN(Segment,mSegments);
}

//---------------------------------------------------------------------------------------------------------------------

tDiaResult
DataBlock::evaluate ( void )
{
   dia::ScopeTrace oTrc("DataBlock::evaluate");

   tDiaResult retCode = DIA_SUCCESS;

   DIA_TR_INF("        +--> EVALUATING DataBlock \"%s\"",getShortName().c_str());

   if ( !mFlashDataRef ) return DIA_FAILED;

   if ( !((mType == DIA_ODX_DATABLOCK_TYPE_WDBI) || (mType == DIA_ODX_DATABLOCK_TYPE_DOWNLOAD)) )
   {
      DIA_TR_INF("          +--> INVALID TYPE \"%s\" (TYPE MUST BE \"%s\") || (mType == \"%s\")",mType.c_str(),DIA_ODX_DATABLOCK_TYPE_WDBI.c_str(),DIA_ODX_DATABLOCK_TYPE_DOWNLOAD.c_str());
      return DIA_FAILED;
   }

   DIA_TR_INF("          +--> NUMBER OF SEGMENTS = %zu",mSegments.size());
   std::list<Segment*>::iterator iter = mSegments.begin();
   for ( ; iter != mSegments.end(); ++iter )
   {
      retCode = (*iter)->evaluate();
      if ( retCode != DIA_SUCCESS ) break;
   }

   if ( retCode != DIA_SUCCESS ) return DIA_FAILED;

   DIA_TR_INF("          +--> NUMBER OF OWN IDENTS = %zu",mOwnIdents.size());
   std::list<OwnIdent*>::iterator iter2 = mOwnIdents.begin();
   for ( ; iter2 != mOwnIdents.end(); ++iter2 )
   {
      retCode = (*iter2)->evaluate();
      if ( retCode != DIA_SUCCESS ) break;
   }

   if ( retCode != DIA_SUCCESS ) return DIA_FAILED;

   return mFlashDataRef->evaluate();
}

tDiaResult
DataBlock::addOwnIdent ( OwnIdent& ident )
{
   tDiaResult retCode = DIA_E_ALREADY_EXISTS;

   std::list<OwnIdent*>::iterator iter = std::find(mOwnIdents.begin(), mOwnIdents.end(), (&ident));
   if ( iter == mOwnIdents.end() )
   {
      mOwnIdents.push_back(&ident);
      retCode = DIA_SUCCESS;
   }

   return retCode;
}

tDiaResult
DataBlock::addSegment ( Segment& segment )
{
   tDiaResult retCode = DIA_E_ALREADY_EXISTS;

   std::list<Segment*>::iterator iter = std::find(mSegments.begin(), mSegments.end(), (&segment));
   if ( iter == mSegments.end() )
   {
      mSegments.push_back(&segment);
      retCode = DIA_SUCCESS;
   }

   return retCode;
}

}
}

