/*!
 * \file       dia_ODX.h
 *
 * \brief      TBD
 *
 * \details    TBD
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreODX
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_ODX__
#define __INCLUDED_DIA_ODX__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ODX_TYPES__
#include <common/framework/odx/dia_ODXTypes.h>
#endif

//#ifndef __INCLUDED_DIA_ODX_NAMED_OBJECT__
//#include <common/framework/odx/dia_ODXNamedObject.h>
//#endif

namespace dia {
namespace odx {

class Flash;

/**
 * \class   dia::odx::Odx
 *
 * \brief   TBD
 *
 * \ingroup diaCoreODX
 */

class ODX
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(ODX);

public:
   ODX ( void ) : mpFlash(0) {}
   virtual ~ODX ( void );

   void setRootFolder ( const std::string& pathName ) { mPath = pathName; }
   const std::string& getRootFolder ( void ) const { return mPath; }

   void setFlash ( Flash& flash ) { mpFlash = &flash; }
   const Flash* getFlash ( void ) const { return mpFlash; }

   tDiaResult evaluate ( void );

protected:
   std::string mPath;
   Flash* mpFlash;
};

}
}

#endif /* __INCLUDED_DIA_ODX__ */
