///////////////////////////////////////////////////////////////////////////////
//
// File: dia_VideoSourceControlFSM.h
//
// Generated by SMC 4.1.0 (C++ State Pattern Code Generator)
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __INCLUDED_DIA_VIDEOSOURCECONTROLFSM__
#define __INCLUDED_DIA_VIDEOSOURCECONTROLFSM__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

namespace dia_VideoSourceControlFSM
{

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody;

///////////////////////////////////////////////////////////////////////////////
//
// Enums and typedefs
//
///////////////////////////////////////////////////////////////////////////////

//! enumeration of FSM events. First and last item added by SMC
enum FsmEvent
{
    evUnknown = 0,
    evReset,
    evError,
    evTimeout,
    evRequestVideoSource,
    evOnVideoSourceInfo,
    evOnVideoStreamStopped,
    evOnVideoSourceDisconnected,
    evOnVideoSourceConnected,
    evOnVideoStreamStarted,
    evCount
};

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBehaviour
//
// This is the base class for the FSM server (provides implementation for all
// actions and guards)
//
///////////////////////////////////////////////////////////////////////////////

class FsmBehaviour
{
    friend class NoVideoSrcActiveState;
    friend class RequestingActiveSourceState;
    friend class SwitchVideoSourceState;
    friend class ToplevelVideoSourceControlState;
    friend class VideoSourceActivationState;
    friend class VideoSrcActiveState;
    friend class FsmBody;

public:
    virtual ~FsmBehaviour ( void ) {}

protected:
    // FSM actions
    virtual void vFsmReset ( void* pArg ) = 0;
    virtual void vFsmSetErrCode_TimeExpired ( void* pArg ) = 0;
    virtual void vFsmSetRequestedVideoSource ( void* pArg ) = 0;
    virtual void vFsmSetErrCode_InvalidVideoSource ( void* pArg ) = 0;
    virtual void vFsmGetCurrentlyActivatedVideoSource ( void* pArg ) = 0;
    virtual void vFsmStopActiveVideoStream ( void* pArg ) = 0;
    virtual void vFsmDisconnectActiveVideoSource ( void* pArg ) = 0;
    virtual void vFsmConnectRequestedVideoSource ( void* pArg ) = 0;
    virtual void vFsmStartRequestedVideoStream ( void* pArg ) = 0;
    virtual void vFsmSetActiveVideoSource ( void* pArg ) = 0;
    virtual void vFsmVideoSourceActivated ( void* pArg ) = 0;

    // FSM guards
    virtual bool bIsRequestedSourceValid ( void* pArg ) = 0;
    virtual bool bIsSrcSwitchRequired ( void* pArg ) = 0;
    virtual bool bIsVideoSrcActive ( void* pArg ) = 0;
    virtual bool bIsVideoStreamStopped ( void* pArg ) = 0;
    virtual bool bNeedToDisconnect ( void* pArg ) = 0;
    virtual bool bIsVideoSourceDisconnected ( void* pArg ) = 0;
    virtual bool bIsVideoSourceConnected ( void* pArg ) = 0;
    virtual bool bIsVideoStreamStarted ( void* pArg ) = 0;
};

///////////////////////////////////////////////////////////////////////////////
//
// Class: Fsm
//
// This is the finite state machine class 'dia_VideoSourceControlFSM'.
//
///////////////////////////////////////////////////////////////////////////////

class Fsm
{
    //! we grant the body class access to our protected section
    friend class FsmBody;

public:
    //! class constructor
    Fsm ( FsmBehaviour* behaviour );
    //! class destructor
    virtual ~Fsm ( void );

    //! setup and initialize the state machine
    void init ( void );

    //! this method is used to stimulate the FSM with events
    void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the current state
    const char* getStateName ( void ) const;

protected:
    //! protected default constructor to avoid usage
    Fsm ( void );
    //! copy constructor without implementation
    Fsm ( const Fsm& obj );
    //! assignment operator without implementation
    Fsm& operator = ( const Fsm& obj );

    //! pointer to the server that provides the implementation for the actions and guards
    FsmBehaviour* mpBehaviour;
    //! body of the FSM implementation
    FsmBody* mpBody;
};


} // namespace

#endif
