///////////////////////////////////////////////////////////////////////////////
//
// File: dia_SystemSettingsFSM.h
//
// Generated by SMC 4.4.0 (C++ State Pattern Code Generator)
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __INCLUDED_DIA_SYSTEMSETTINGSFSM__
#define __INCLUDED_DIA_SYSTEMSETTINGSFSM__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

namespace dia_SystemSettingsFSM
{

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody;

///////////////////////////////////////////////////////////////////////////////
//
// Enums and typedefs
//
///////////////////////////////////////////////////////////////////////////////

//! enumeration of FSM events. First and last item added by SMC
enum FsmEvent
{
   evUnknown = 0,
   evBackToSystemSettingActive,
   evFailed,
   evIdle,
   evPluginsProcessed,
   evProcessingError,
   evProcessingFailed,
   evProcessingSucceeded,
   evProcessingTimeout,
   evRemoteSystemSettingRequest,
   evResetMasterSystemSetting,
   evResponseEvaluated,
   evResponseReceived,
   evRetry,
   evReturnControl,
   evSlaveMode,
   evStartProcessing,
   evSuccess,
   evSystemSettingRequest,
   evCount
};

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBehaviour
//
// This is the base class for the FSM server (provides implementation for all
// actions and guards)
//
///////////////////////////////////////////////////////////////////////////////

class FsmBehaviour
{ 
   friend class ExecuteSystemSettingState;
   friend class FinalizeSystemSettingState;
   friend class IdleState;
   friend class MasterSystemSettingState;
   friend class PrepareSystemSettingState;
   friend class ProcessState;
   friend class ProcessSystemSettingState;
   friend class ProcessingFailedState;
   friend class SlaveModeState;
   friend class SlaveSystemSettingState;
   friend class SystemSettingActiveState;
   friend class TopLevelState;
   friend class FsmBody;

public:
   virtual ~FsmBehaviour ( void ) {}

protected:
   // FSM actions
   virtual void vFsmEvaluateResponse ( void* pArg ) = 0;
   virtual void vFsmExecutionCompleted ( void* pArg ) = 0;
   virtual void vFsmFinalizationCompleted ( void* pArg ) = 0;
   virtual void vFsmFinalizeSlaveMode ( void* pArg ) = 0;
   virtual void vFsmFinalizeSlaveProcessing ( void* pArg ) = 0;
   virtual void vFsmFinalizeSystemSetting ( void* pArg ) = 0;
   virtual void vFsmHandleError ( void* pArg ) = 0;
   virtual void vFsmInitializeExecution ( void* pArg ) = 0;
   virtual void vFsmInitializeFinalization ( void* pArg ) = 0;
   virtual void vFsmInitializeMasterSystemSetting ( void* pArg ) = 0;
   virtual void vFsmInitializePreparation ( void* pArg ) = 0;
   virtual void vFsmInitializeProcessing ( void* pArg ) = 0;
   virtual void vFsmInitializeRetry ( void* pArg ) = 0;
   virtual void vFsmInitializeSlaveMode ( void* pArg ) = 0;
   virtual void vFsmInitializeSlaveProcessing ( void* pArg ) = 0;
   virtual void vFsmInitializeSlaveSystemSetting ( void* pArg ) = 0;
   virtual void vFsmInitializeSystemSetting ( void* pArg ) = 0;
   virtual void vFsmPreparationCompleted ( void* pArg ) = 0;
   virtual void vFsmProcessPlugins ( void* pArg ) = 0;
   virtual void vFsmRejectRemoteSystemSettingRequest ( void* pArg ) = 0;
   virtual void vFsmRejectSystemSettingRequest ( void* pArg ) = 0;
   virtual void vFsmSendNegResponseToMaster ( void* pArg ) = 0;
   virtual void vFsmSendPosResponseToMaster ( void* pArg ) = 0;
   virtual void vFsmSendRemoteControlResponseToMaster ( void* pArg ) = 0;
   virtual void vFsmSendResponse ( void* pArg ) = 0;
   virtual void vFsmSendSystemSettingsRequests ( void* pArg ) = 0;
   virtual void vFsmSetProcessingTimeout ( void* pArg ) = 0;
   virtual void vFsmSetRetryTimeout ( void* pArg ) = 0;
   virtual void vFsmStartProcessingTimer ( void* pArg ) = 0;
   virtual void vFsmStopProcessingTimer ( void* pArg ) = 0;

   // FSM guards
   virtual bool bFsmIsCompleteOK ( void* pArg ) = 0;
   virtual bool bFsmIsNotificationRequired ( void* pArg ) = 0;
   virtual bool bFsmIsRetryCheckOK ( void* pArg ) = 0;
   virtual bool bFsmIsRetryCounterExceeded ( void* pArg ) = 0;
};

///////////////////////////////////////////////////////////////////////////////
//
// Class: Fsm
//
// This is the finite state machine class 'dia_SystemSettingsFSM'.
//
///////////////////////////////////////////////////////////////////////////////

class Fsm
{
    //! we grant the body class access to our protected section
    friend class FsmBody;

public:
    //! factory method used to create an FAM object in two stages
    static bool createFSM ( Fsm** ppFSM, FsmBehaviour* behaviour );
    //! class destructor
    virtual ~Fsm ( void );

    //! this method is used to stimulate the FSM with events
    virtual void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the current state
    virtual const char* getStateName ( void ) const;

protected:
    //! protected default constructor to avoid usage
    Fsm ( void );
    //! class constructor
    Fsm ( FsmBehaviour* behaviour );
    //! copy constructor without implementation
    Fsm ( const Fsm& obj );
    //! assignment operator without implementation
    Fsm& operator = ( const Fsm& obj );

    //! setup and initialize the state machine
    virtual bool init ( void );

protected:
    //! pointer to the server that provides the implementation for the actions and guards
    FsmBehaviour* mpBehaviour;
    //! body of the FSM implementation
    FsmBody* mpBody;
};


} // namespace

#endif
