///////////////////////////////////////////////////////////////////////////////
//
// File: dia_SystemSettingsFSM.cpp
//
// Generated by SMC 4.4.0 (C++ State Pattern Code Generator)
//
///////////////////////////////////////////////////////////////////////////////

#include <string.h>

#ifndef __INCLUDED_DIA_SYSTEMSETTINGSFSM__
#include "dia_SystemSettingsFSM.h"
#endif

namespace dia_SystemSettingsFSM
{

const unsigned int MAX_TRIGGER_EVENTS = 20;

const unsigned int MAX_DEFERRED_EVENTS = 25;

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class Fsm;
class FsmSuperState;

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states.
//
///////////////////////////////////////////////////////////////////////////////

class FsmState
{
public:
   //! name of the FSM's state
   virtual const char* getStateName ( void ) const = 0;

   //! resetting state internals
   virtual void reset ( void ) {}

   // event functions 
   virtual void evBackToSystemSettingActive ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evPluginsProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessingError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessingSucceeded ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessingTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRemoteSystemSettingRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evResetMasterSystemSetting ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evResponseEvaluated ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evResponseReceived ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRetry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReturnControl ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSlaveMode ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evStartProcessing ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSuccess ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSystemSettingRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! default implementation for the Entry action
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! default implementation for the Exit action
   virtual void exit  ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! return the parent state
   virtual FsmSuperState* getParent ( void );

   //! assign the body object
   void initState ( FsmSuperState* pParent );

protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmState ( void );
   //! class destructor
   virtual ~FsmState ( void );

   //! pointer to the superstate
   FsmSuperState* mpParent;
};

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

class FsmSuperState
   : public FsmState
{
public:
   //! set a savepoint for the history
   virtual void savepoint ( FsmBody& b );
   //! default action
   virtual void defaultAction ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! resetting state internals
   virtual void reset ( void ) { _history = 0; }

   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! assign the body object
   void initSuperState ( FsmSuperState* pParent, FsmState* defState, bool histEnable=false );

protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmSuperState ( void );

   //! pointer to the default substate
   FsmState* _default;
   //! pointer to the history substate
   const FsmState* _history;
   //! flag that indicates if history is enabled or not
   bool _historyEnable;
};

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ExecuteSystemSettingState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ExecuteSystemSettingState
   : public FsmState
{
public:
   //! default constructor
   ExecuteSystemSettingState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evPluginsProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evResetMasterSystemSetting ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evStartProcessing ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSuccess ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! deferred events
   virtual void evSystemSettingRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRemoteSystemSettingRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSlaveMode ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReturnControl ( FsmBody& b, FsmBehaviour& s, void* pArg );


protected:
   //! array for recording received events to be deferred
   FsmEvent _deferredEvents[MAX_DEFERRED_EVENTS];
   //! array for recording params of events to be deferred
   void*    _deferredParams[MAX_DEFERRED_EVENTS];
   //! number of events currently deferred
   int _numDeferredEvents;


protected:
   static const char* mStateName;
};

const char* ExecuteSystemSettingState::mStateName = "ExecuteSystemSetting";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: FinalizeSystemSettingState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class FinalizeSystemSettingState
   : public FsmState
{
public:
   //! default constructor
   FinalizeSystemSettingState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evPluginsProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evResetMasterSystemSetting ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evStartProcessing ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSuccess ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! deferred events
   virtual void evSystemSettingRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRemoteSystemSettingRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSlaveMode ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReturnControl ( FsmBody& b, FsmBehaviour& s, void* pArg );


protected:
   //! array for recording received events to be deferred
   FsmEvent _deferredEvents[MAX_DEFERRED_EVENTS];
   //! array for recording params of events to be deferred
   void*    _deferredParams[MAX_DEFERRED_EVENTS];
   //! number of events currently deferred
   int _numDeferredEvents;


protected:
   static const char* mStateName;
};

const char* FinalizeSystemSettingState::mStateName = "FinalizeSystemSetting";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: IdleState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class IdleState
   : public FsmState
{
public:
   //! default constructor
   IdleState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRemoteSystemSettingRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReturnControl ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSlaveMode ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSystemSettingRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* IdleState::mStateName = "Idle";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: MasterSystemSettingState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class MasterSystemSettingState
   : public FsmSuperState
{
public:
   //! default constructor
   MasterSystemSettingState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evResetMasterSystemSetting ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! deferred events
   virtual void evSystemSettingRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRemoteSystemSettingRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSlaveMode ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReturnControl ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! set a savepoint for the history
   virtual void savepoint ( FsmBody& b );

protected:
   //! array for recording received events to be deferred
   FsmEvent _deferredEvents[MAX_DEFERRED_EVENTS];
   //! array for recording params of events to be deferred
   void*    _deferredParams[MAX_DEFERRED_EVENTS];
   //! number of events currently deferred
   int _numDeferredEvents;


protected:
   static const char* mStateName;
};

const char* MasterSystemSettingState::mStateName = "MasterSystemSetting";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: PrepareSystemSettingState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class PrepareSystemSettingState
   : public FsmState
{
public:
   //! default constructor
   PrepareSystemSettingState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evPluginsProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evResetMasterSystemSetting ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evStartProcessing ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSuccess ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! deferred events
   virtual void evSystemSettingRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRemoteSystemSettingRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSlaveMode ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReturnControl ( FsmBody& b, FsmBehaviour& s, void* pArg );


protected:
   //! array for recording received events to be deferred
   FsmEvent _deferredEvents[MAX_DEFERRED_EVENTS];
   //! array for recording params of events to be deferred
   void*    _deferredParams[MAX_DEFERRED_EVENTS];
   //! number of events currently deferred
   int _numDeferredEvents;


protected:
   static const char* mStateName;
};

const char* PrepareSystemSettingState::mStateName = "PrepareSystemSetting";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ProcessState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ProcessState
   : public FsmState
{
public:
   //! default constructor
   ProcessState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evBackToSystemSettingActive ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessingError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessingSucceeded ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessingTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evResponseEvaluated ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evResponseReceived ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! deferred events
   virtual void evSystemSettingRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRemoteSystemSettingRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSlaveMode ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReturnControl ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! exit actions
   virtual void exit ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   //! array for recording received events to be deferred
   FsmEvent _deferredEvents[MAX_DEFERRED_EVENTS];
   //! array for recording params of events to be deferred
   void*    _deferredParams[MAX_DEFERRED_EVENTS];
   //! number of events currently deferred
   int _numDeferredEvents;


protected:
   static const char* mStateName;
};

const char* ProcessState::mStateName = "Process";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ProcessSystemSettingState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ProcessSystemSettingState
   : public FsmSuperState
{
public:
   //! default constructor
   ProcessSystemSettingState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evBackToSystemSettingActive ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessingSucceeded ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! deferred events
   virtual void evSystemSettingRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRemoteSystemSettingRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSlaveMode ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReturnControl ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! default action
   virtual void defaultAction ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   //! array for recording received events to be deferred
   FsmEvent _deferredEvents[MAX_DEFERRED_EVENTS];
   //! array for recording params of events to be deferred
   void*    _deferredParams[MAX_DEFERRED_EVENTS];
   //! number of events currently deferred
   int _numDeferredEvents;


protected:
   static const char* mStateName;
};

const char* ProcessSystemSettingState::mStateName = "ProcessSystemSetting";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ProcessingFailedState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ProcessingFailedState
   : public FsmState
{
public:
   //! default constructor
   ProcessingFailedState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evBackToSystemSettingActive ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessingSucceeded ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRetry ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! deferred events
   virtual void evSystemSettingRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRemoteSystemSettingRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSlaveMode ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReturnControl ( FsmBody& b, FsmBehaviour& s, void* pArg );


protected:
   //! array for recording received events to be deferred
   FsmEvent _deferredEvents[MAX_DEFERRED_EVENTS];
   //! array for recording params of events to be deferred
   void*    _deferredParams[MAX_DEFERRED_EVENTS];
   //! number of events currently deferred
   int _numDeferredEvents;


protected:
   static const char* mStateName;
};

const char* ProcessingFailedState::mStateName = "ProcessingFailed";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SlaveModeState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class SlaveModeState
   : public FsmState
{
public:
   //! default constructor
   SlaveModeState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRemoteSystemSettingRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReturnControl ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSlaveMode ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSystemSettingRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* SlaveModeState::mStateName = "SlaveMode";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SlaveSystemSettingState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class SlaveSystemSettingState
   : public FsmState
{
public:
   //! default constructor
   SlaveSystemSettingState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evPluginsProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evStartProcessing ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSuccess ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! deferred events
   virtual void evSystemSettingRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRemoteSystemSettingRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSlaveMode ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReturnControl ( FsmBody& b, FsmBehaviour& s, void* pArg );


protected:
   //! array for recording received events to be deferred
   FsmEvent _deferredEvents[MAX_DEFERRED_EVENTS];
   //! array for recording params of events to be deferred
   void*    _deferredParams[MAX_DEFERRED_EVENTS];
   //! number of events currently deferred
   int _numDeferredEvents;


protected:
   static const char* mStateName;
};

const char* SlaveSystemSettingState::mStateName = "SlaveSystemSetting";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SystemSettingActiveState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class SystemSettingActiveState
   : public FsmSuperState
{
public:
   //! default constructor
   SystemSettingActiveState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! deferred events
   virtual void evSystemSettingRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRemoteSystemSettingRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSlaveMode ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReturnControl ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! set a savepoint for the history
   virtual void savepoint ( FsmBody& b );

protected:
   //! array for recording received events to be deferred
   FsmEvent _deferredEvents[MAX_DEFERRED_EVENTS];
   //! array for recording params of events to be deferred
   void*    _deferredParams[MAX_DEFERRED_EVENTS];
   //! number of events currently deferred
   int _numDeferredEvents;


protected:
   static const char* mStateName;
};

const char* SystemSettingActiveState::mStateName = "SystemSettingActive";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: TopLevelState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class TopLevelState
   : public FsmSuperState
{
public:
   //! default constructor
   TopLevelState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* TopLevelState::mStateName = "TopLevel";

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBody
//
// This is the finite state machine's body class 'FsmBody'.
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody
{
    struct FsmDeferredEvent
    {
          FsmDeferredEvent() : mEvent(evUnknown), mArg(0) {}
          FsmEvent mEvent;
          void*    mArg;
    };

public:
    //! class constructor
    FsmBody ( void );

    //! connect the FSM body with its frontend
    void connect ( Fsm* frontend );

    //! initialize the FSM: set initial state and execute initial actions
    bool init ( void );

    //! this method is used to stimulate the FSM with events
    void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the active state
    const char* getStateName ( void ) const;

    //! push trigger events to the event queue
    bool addEvent ( const FsmEvent& event, void* arg  );
    //! get event from the event queue
    bool getEvent ( FsmEvent& event, void** arg  );
    //! get event from the event queue
    bool isQueueEmpty ( void ) const;

    //! push deferred events to the pool of deferred events
    bool addDeferredEvent ( const FsmEvent& event, void* arg );
    //! get deferred event from the pool of deferred events
    bool getDeferredEvent ( FsmEvent& event, void** arg );
    //! check if the event pool is empty
    bool isPoolOfDeferredEventsEmpty ( void ) const;

    // set the FSM's internal state and propagate to default or history substate
    void setState ( FsmState& state, void* pArg );
    // set the FSM's internal state (no propagation
    void setState ( FsmState* pState );
    // return the active state object
    const FsmState* getState ( void ) const;

    //! static state objects
    ExecuteSystemSettingState oExecuteSystemSettingState;
    FinalizeSystemSettingState oFinalizeSystemSettingState;
    IdleState oIdleState;
    MasterSystemSettingState oMasterSystemSettingState;
    PrepareSystemSettingState oPrepareSystemSettingState;
    ProcessState oProcessState;
    ProcessSystemSettingState oProcessSystemSettingState;
    ProcessingFailedState oProcessingFailedState;
    SlaveModeState oSlaveModeState;
    SlaveSystemSettingState oSlaveSystemSettingState;
    SystemSettingActiveState oSystemSettingActiveState;
    TopLevelState oTopLevelState;

    //! frontend for this body
    Fsm* mpFrontend;
    //! link to the active state object
    FsmState* mpState;

    //! busy indicator flag
    bool mBusyFlag;

    //! queue of trigger events
    FsmEvent mEventQueue[MAX_TRIGGER_EVENTS];
    //! queue of arguments for trigger events
    void*    mParamQueue[MAX_TRIGGER_EVENTS];
    //! index of the queue's front element
    unsigned int mQueueHead;
    //! index of the queue's back element
    unsigned int mQueueTail;
    //! number of queued events
    unsigned int mQueueSize;
    //! pool of deferred events
    FsmDeferredEvent mDeferredEventPool[MAX_DEFERRED_EVENTS];
    //! index of the pool's front element
    unsigned int mPoolHead;
    //! index of the pool's back element
    unsigned int mPoolTail;
    //! number of deferred events stored in the pool
    unsigned int mPoolSize;
};

///////////////////////////////////////////////////////////////////////////////
//
// Default implementation for all events.
//
///////////////////////////////////////////////////////////////////////////////

void
FsmState::evBackToSystemSettingActive ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evBackToSystemSettingActive *** 
}

void
FsmState::evFailed ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evFailed *** 
}

void
FsmState::evIdle ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evIdle *** 
}

void
FsmState::evPluginsProcessed ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evPluginsProcessed *** 
}

void
FsmState::evProcessingError ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evProcessingError *** 
}

void
FsmState::evProcessingFailed ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evProcessingFailed *** 
}

void
FsmState::evProcessingSucceeded ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evProcessingSucceeded *** 
}

void
FsmState::evProcessingTimeout ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evProcessingTimeout *** 
}

void
FsmState::evRemoteSystemSettingRequest ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evRemoteSystemSettingRequest *** 
}

void
FsmState::evResetMasterSystemSetting ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evResetMasterSystemSetting *** 
}

void
FsmState::evResponseEvaluated ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evResponseEvaluated *** 
}

void
FsmState::evResponseReceived ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evResponseReceived *** 
}

void
FsmState::evRetry ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evRetry *** 
}

void
FsmState::evReturnControl ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evReturnControl *** 
}

void
FsmState::evSlaveMode ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evSlaveMode *** 
}

void
FsmState::evStartProcessing ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evStartProcessing *** 
}

void
FsmState::evSuccess ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evSuccess *** 
}

void
FsmState::evSystemSettingRequest ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evSystemSettingRequest *** 
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states components.
//
///////////////////////////////////////////////////////////////////////////////

FsmState::FsmState ( void )
   : mpParent(0)
{}

FsmState::~FsmState ( void )
{
   // make lint happy
   mpParent = 0;
}

void
FsmState::initState ( FsmSuperState* pParent )
{
   mpParent = pParent;
}

void
FsmState::entry ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

void
FsmState::exit ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

const FsmState*
FsmState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.setState(this);
   entry(b,s,pArg);
   return this;
}

FsmSuperState*
FsmState::getParent ( void )
{
   return (mpParent) ? mpParent : 0;
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

FsmSuperState::FsmSuperState ( void )
   : _default(0),
     _history(0),
     _historyEnable(false)
{}

void
FsmSuperState::initSuperState ( FsmSuperState* pParent, FsmState* defState, bool histEnable )
{
   mpParent = pParent;
   _default = defState;
   _history = 0;
   _historyEnable = histEnable;
}

const FsmState*
FsmSuperState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   const FsmState* pState = 0;

   // we have crossed a state boundary
   b.setState(this);
   // execute the entry actions for this superstate
   entry(b,s,pArg);
   
   if ( _history && _historyEnable )
   {
      pState = const_cast<FsmState*>(_history)->propagate(b,s,pArg);
   }
   else
   {
      defaultAction(b,s,pArg);
      if ( _default ) {
         pState = _default->propagate(b,s,pArg);
      }
   }
   
   return pState;
}

void
FsmSuperState::savepoint ( FsmBody& b )
{
   if ( _historyEnable )
   {
      _history = b.getState();
   }
}

void
FsmSuperState::defaultAction ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /*pArg*/ )
{
   //... empty as default ...
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ExecuteSystemSettingState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ExecuteSystemSettingState::ExecuteSystemSettingState ( void )
   : _numDeferredEvents(0)
{
   (void) ::memset(_deferredEvents, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
   (void) ::memset(_deferredParams, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
}

void
ExecuteSystemSettingState::evFailed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmHandleError(pArg);
   s.vFsmFinalizeSystemSetting(pArg);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   // trigger events
   FsmEvent event = dia_SystemSettingsFSM::evUnknown;

   event = dia_SystemSettingsFSM::evStartProcessing; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oFinalizeSystemSettingState,pArg);
}

void
ExecuteSystemSettingState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // set savepoint in superstate with enabled history
   b.oMasterSystemSettingState.savepoint(b);

   // set savepoint in superstate with enabled history
   b.oSystemSettingActiveState.savepoint(b);

   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oIdleState,pArg);
}

void
ExecuteSystemSettingState::evPluginsProcessed ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // set savepoint in superstate with enabled history
   b.oMasterSystemSettingState.savepoint(b);

   // set savepoint in superstate with enabled history
   b.oSystemSettingActiveState.savepoint(b);

   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oProcessSystemSettingState,pArg);
}

void
ExecuteSystemSettingState::evResetMasterSystemSetting ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oPrepareSystemSettingState,pArg);
}

void
ExecuteSystemSettingState::evStartProcessing ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmInitializeExecution(pArg);
   s.vFsmProcessPlugins(pArg);
   // this is an internal transition
}

void
ExecuteSystemSettingState::evSuccess ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmExecutionCompleted(pArg);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   // trigger events
   FsmEvent event = dia_SystemSettingsFSM::evUnknown;

   event = dia_SystemSettingsFSM::evStartProcessing; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oFinalizeSystemSettingState,pArg);
}

void
ExecuteSystemSettingState::evSystemSettingRequest( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SystemSettingsFSM::evSystemSettingRequest;

   b.addDeferredEvent(event,pArg);
}

void
ExecuteSystemSettingState::evRemoteSystemSettingRequest( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SystemSettingsFSM::evRemoteSystemSettingRequest;

   b.addDeferredEvent(event,pArg);
}

void
ExecuteSystemSettingState::evSlaveMode( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SystemSettingsFSM::evSlaveMode;

   b.addDeferredEvent(event,pArg);
}

void
ExecuteSystemSettingState::evReturnControl( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SystemSettingsFSM::evReturnControl;

   b.addDeferredEvent(event,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: FinalizeSystemSettingState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

FinalizeSystemSettingState::FinalizeSystemSettingState ( void )
   : _numDeferredEvents(0)
{
   (void) ::memset(_deferredEvents, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
   (void) ::memset(_deferredParams, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
}

void
FinalizeSystemSettingState::evFailed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // set savepoint in superstate with enabled history
   b.oMasterSystemSettingState.savepoint(b);

   // set savepoint in superstate with enabled history
   b.oSystemSettingActiveState.savepoint(b);

   // transition Actions
   s.vFsmHandleError(pArg);
   s.vFsmFinalizeSystemSetting(pArg);
   s.vFsmSendResponse(pArg);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oIdleState,pArg);
}

void
FinalizeSystemSettingState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // set savepoint in superstate with enabled history
   b.oMasterSystemSettingState.savepoint(b);

   // set savepoint in superstate with enabled history
   b.oSystemSettingActiveState.savepoint(b);

   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oIdleState,pArg);
}

void
FinalizeSystemSettingState::evPluginsProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmIsNotificationRequired(pArg) )
   {
        // set savepoint in superstate with enabled history
        b.oMasterSystemSettingState.savepoint(b);

        // set savepoint in superstate with enabled history
        b.oSystemSettingActiveState.savepoint(b);

        // trigger deferred events
        while ( !b.isPoolOfDeferredEventsEmpty() )
        {
            FsmEvent defevent = evUnknown;
            void*    defarg   = 0;
            if ( b.getDeferredEvent(defevent,&defarg) )
            {
                b.addEvent(defevent,defarg);
            }
        }
        b.setState(b.oProcessSystemSettingState,pArg);
    }
    else
    {
   // set savepoint in superstate with enabled history
   b.oMasterSystemSettingState.savepoint(b);

   // set savepoint in superstate with enabled history
   b.oSystemSettingActiveState.savepoint(b);

   // transition Actions
   s.vFsmFinalizationCompleted(pArg);
   s.vFsmSendResponse(pArg);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oIdleState,pArg);
    }
}

void
FinalizeSystemSettingState::evResetMasterSystemSetting ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oPrepareSystemSettingState,pArg);
}

void
FinalizeSystemSettingState::evStartProcessing ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmInitializeFinalization(pArg);
   s.vFsmProcessPlugins(pArg);
   // this is an internal transition
}

void
FinalizeSystemSettingState::evSuccess ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // set savepoint in superstate with enabled history
   b.oMasterSystemSettingState.savepoint(b);

   // set savepoint in superstate with enabled history
   b.oSystemSettingActiveState.savepoint(b);

   // transition Actions
   s.vFsmFinalizationCompleted(pArg);
   s.vFsmSendResponse(pArg);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oIdleState,pArg);
}

void
FinalizeSystemSettingState::evSystemSettingRequest( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SystemSettingsFSM::evSystemSettingRequest;

   b.addDeferredEvent(event,pArg);
}

void
FinalizeSystemSettingState::evRemoteSystemSettingRequest( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SystemSettingsFSM::evRemoteSystemSettingRequest;

   b.addDeferredEvent(event,pArg);
}

void
FinalizeSystemSettingState::evSlaveMode( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SystemSettingsFSM::evSlaveMode;

   b.addDeferredEvent(event,pArg);
}

void
FinalizeSystemSettingState::evReturnControl( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SystemSettingsFSM::evReturnControl;

   b.addDeferredEvent(event,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: IdleState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

IdleState::IdleState ( void )
{}

void
IdleState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmInitializeSystemSetting(pArg);
}

void
IdleState::evIdle ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

void
IdleState::evRemoteSystemSettingRequest ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmRejectRemoteSystemSettingRequest(pArg);
   // this is an internal transition
}

void
IdleState::evReturnControl ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendRemoteControlResponseToMaster(pArg);
   // this is an internal transition
}

void
IdleState::evSlaveMode ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmInitializeSlaveMode(pArg);
   s.vFsmSendRemoteControlResponseToMaster(pArg);
   b.setState(b.oSlaveModeState,nullptr); //Coverity fix(CID:829694)
}

void
IdleState::evSystemSettingRequest ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmInitializeMasterSystemSetting(pArg);
   // trigger events
   FsmEvent event = dia_SystemSettingsFSM::evUnknown;

   event = dia_SystemSettingsFSM::evStartProcessing; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oPrepareSystemSettingState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: MasterSystemSettingState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

MasterSystemSettingState::MasterSystemSettingState ( void )
   : _numDeferredEvents(0)
{
   (void) ::memset(_deferredEvents, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
   (void) ::memset(_deferredParams, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
}

void
MasterSystemSettingState::savepoint ( FsmBody& b )
{
   if ( _historyEnable )
   {
      _history = b.getState();
      while (  _history && (_history->getStateName() != b.oPrepareSystemSettingState.getStateName()) && (_history->getStateName() != b.oExecuteSystemSettingState.getStateName()) && (_history->getStateName() != b.oFinalizeSystemSettingState.getStateName()) )
      {
         _history = const_cast<FsmState*>(_history)->getParent();
      }
   }
}

void
MasterSystemSettingState::evFailed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   savepoint(b);
   // transition Actions
   s.vFsmHandleError(pArg);
   s.vFsmFinalizeSystemSetting(pArg);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   // trigger events
   FsmEvent event = dia_SystemSettingsFSM::evUnknown;

   event = dia_SystemSettingsFSM::evStartProcessing; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oFinalizeSystemSettingState,pArg);
}

void
MasterSystemSettingState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   savepoint(b);
   // set savepoint in superstate with enabled history
   b.oSystemSettingActiveState.savepoint(b);

   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oIdleState,pArg);
}

void
MasterSystemSettingState::evResetMasterSystemSetting ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   savepoint(b);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oPrepareSystemSettingState,pArg);
}

void
MasterSystemSettingState::evSystemSettingRequest( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SystemSettingsFSM::evSystemSettingRequest;

   b.addDeferredEvent(event,pArg);
}

void
MasterSystemSettingState::evRemoteSystemSettingRequest( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SystemSettingsFSM::evRemoteSystemSettingRequest;

   b.addDeferredEvent(event,pArg);
}

void
MasterSystemSettingState::evSlaveMode( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SystemSettingsFSM::evSlaveMode;

   b.addDeferredEvent(event,pArg);
}

void
MasterSystemSettingState::evReturnControl( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SystemSettingsFSM::evReturnControl;

   b.addDeferredEvent(event,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: PrepareSystemSettingState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

PrepareSystemSettingState::PrepareSystemSettingState ( void )
   : _numDeferredEvents(0)
{
   (void) ::memset(_deferredEvents, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
   (void) ::memset(_deferredParams, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
}

void
PrepareSystemSettingState::evFailed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmHandleError(pArg);
   s.vFsmFinalizeSystemSetting(pArg);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   // trigger events
   FsmEvent event = dia_SystemSettingsFSM::evUnknown;

   event = dia_SystemSettingsFSM::evStartProcessing; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oFinalizeSystemSettingState,pArg);
}

void
PrepareSystemSettingState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // set savepoint in superstate with enabled history
   b.oMasterSystemSettingState.savepoint(b);

   // set savepoint in superstate with enabled history
   b.oSystemSettingActiveState.savepoint(b);

   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oIdleState,pArg);
}

void
PrepareSystemSettingState::evPluginsProcessed ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // set savepoint in superstate with enabled history
   b.oMasterSystemSettingState.savepoint(b);

   // set savepoint in superstate with enabled history
   b.oSystemSettingActiveState.savepoint(b);

   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oProcessSystemSettingState,pArg);
}

void
PrepareSystemSettingState::evResetMasterSystemSetting ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oPrepareSystemSettingState,pArg);
}

void
PrepareSystemSettingState::evStartProcessing ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmInitializePreparation(pArg);
   s.vFsmProcessPlugins(pArg);
   // this is an internal transition
}

void
PrepareSystemSettingState::evSuccess ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmPreparationCompleted(pArg);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   // trigger events
   FsmEvent event = dia_SystemSettingsFSM::evUnknown;

   event = dia_SystemSettingsFSM::evStartProcessing; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oExecuteSystemSettingState,pArg);
}

void
PrepareSystemSettingState::evSystemSettingRequest( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SystemSettingsFSM::evSystemSettingRequest;

   b.addDeferredEvent(event,pArg);
}

void
PrepareSystemSettingState::evRemoteSystemSettingRequest( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SystemSettingsFSM::evRemoteSystemSettingRequest;

   b.addDeferredEvent(event,pArg);
}

void
PrepareSystemSettingState::evSlaveMode( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SystemSettingsFSM::evSlaveMode;

   b.addDeferredEvent(event,pArg);
}

void
PrepareSystemSettingState::evReturnControl( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SystemSettingsFSM::evReturnControl;

   b.addDeferredEvent(event,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ProcessState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ProcessState::ProcessState ( void )
   : _numDeferredEvents(0)
{
   (void) ::memset(_deferredEvents, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
   (void) ::memset(_deferredParams, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
}

void
ProcessState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   _numDeferredEvents = 0;

   s.vFsmStartProcessingTimer(pArg);
   s.vFsmSendSystemSettingsRequests(pArg);
}

void
ProcessState::exit ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmStopProcessingTimer(pArg);
}

void
ProcessState::evBackToSystemSettingActive ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oSystemSettingActiveState,pArg);
}

void
ProcessState::evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oIdleState,pArg);
}

void
ProcessState::evProcessingError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oProcessingFailedState,pArg);
}

void
ProcessState::evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   // trigger events
   FsmEvent event = dia_SystemSettingsFSM::evUnknown;

   event = dia_SystemSettingsFSM::evFailed; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oSystemSettingActiveState,pArg);
}

void
ProcessState::evProcessingSucceeded ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   // trigger events
   FsmEvent event = dia_SystemSettingsFSM::evUnknown;

   event = dia_SystemSettingsFSM::evSuccess; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oSystemSettingActiveState,pArg);
}

void
ProcessState::evProcessingTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   // trigger events
   FsmEvent event = dia_SystemSettingsFSM::evUnknown;

   event = dia_SystemSettingsFSM::evRetry; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oProcessingFailedState,pArg);
}

void
ProcessState::evResponseEvaluated ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmIsCompleteOK(pArg) )
   {
        // trigger events
        FsmEvent event = dia_SystemSettingsFSM::evUnknown;

        event = dia_SystemSettingsFSM::evProcessingSucceeded; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        // this is an internal transition
    }
    else
    {
   // this is an internal transition
    }
}

void
ProcessState::evResponseReceived ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmEvaluateResponse(pArg);
   // trigger events
   FsmEvent event = dia_SystemSettingsFSM::evUnknown;

   event = dia_SystemSettingsFSM::evResponseEvaluated; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
ProcessState::evSystemSettingRequest( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SystemSettingsFSM::evSystemSettingRequest;

   b.addDeferredEvent(event,pArg);
}

void
ProcessState::evRemoteSystemSettingRequest( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SystemSettingsFSM::evRemoteSystemSettingRequest;

   b.addDeferredEvent(event,pArg);
}

void
ProcessState::evSlaveMode( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SystemSettingsFSM::evSlaveMode;

   b.addDeferredEvent(event,pArg);
}

void
ProcessState::evReturnControl( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SystemSettingsFSM::evReturnControl;

   b.addDeferredEvent(event,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ProcessSystemSettingState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ProcessSystemSettingState::ProcessSystemSettingState ( void )
   : _numDeferredEvents(0)
{
   (void) ::memset(_deferredEvents, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
   (void) ::memset(_deferredParams, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
}

void
ProcessSystemSettingState::defaultAction ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
    s.vFsmInitializeProcessing(pArg);
    s.vFsmSetProcessingTimeout(pArg);
}

void
ProcessSystemSettingState::evBackToSystemSettingActive ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oSystemSettingActiveState,pArg);
}

void
ProcessSystemSettingState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oIdleState,pArg);
}

void
ProcessSystemSettingState::evProcessingFailed ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   // trigger events
   FsmEvent event = dia_SystemSettingsFSM::evUnknown;

   event = dia_SystemSettingsFSM::evFailed; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oSystemSettingActiveState,pArg);
}

void
ProcessSystemSettingState::evProcessingSucceeded ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   // trigger events
   FsmEvent event = dia_SystemSettingsFSM::evUnknown;

   event = dia_SystemSettingsFSM::evSuccess; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oSystemSettingActiveState,pArg);
}

void
ProcessSystemSettingState::evSystemSettingRequest( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SystemSettingsFSM::evSystemSettingRequest;

   b.addDeferredEvent(event,pArg);
}

void
ProcessSystemSettingState::evRemoteSystemSettingRequest( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SystemSettingsFSM::evRemoteSystemSettingRequest;

   b.addDeferredEvent(event,pArg);
}

void
ProcessSystemSettingState::evSlaveMode( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SystemSettingsFSM::evSlaveMode;

   b.addDeferredEvent(event,pArg);
}

void
ProcessSystemSettingState::evReturnControl( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SystemSettingsFSM::evReturnControl;

   b.addDeferredEvent(event,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ProcessingFailedState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ProcessingFailedState::ProcessingFailedState ( void )
   : _numDeferredEvents(0)
{
   (void) ::memset(_deferredEvents, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
   (void) ::memset(_deferredParams, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
}

void
ProcessingFailedState::evBackToSystemSettingActive ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oSystemSettingActiveState,pArg);
}

void
ProcessingFailedState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oIdleState,pArg);
}

void
ProcessingFailedState::evProcessingFailed ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   // trigger events
   FsmEvent event = dia_SystemSettingsFSM::evUnknown;

   event = dia_SystemSettingsFSM::evFailed; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oSystemSettingActiveState,pArg);
}

void
ProcessingFailedState::evProcessingSucceeded ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   // trigger events
   FsmEvent event = dia_SystemSettingsFSM::evUnknown;

   event = dia_SystemSettingsFSM::evSuccess; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oSystemSettingActiveState,pArg);
}

void
ProcessingFailedState::evRetry ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmIsRetryCounterExceeded(pArg) )
   {
        // trigger events
        FsmEvent event = dia_SystemSettingsFSM::evUnknown;

        event = dia_SystemSettingsFSM::evProcessingFailed; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        // this is an internal transition
    } 
    else if ( s.bFsmIsRetryCheckOK(pArg) )
   {
        // transition Actions
        s.vFsmInitializeRetry(pArg);
        s.vFsmSetRetryTimeout(pArg);
        // trigger deferred events
        while ( !b.isPoolOfDeferredEventsEmpty() )
        {
            FsmEvent defevent = evUnknown;
            void*    defarg   = 0;
            if ( b.getDeferredEvent(defevent,&defarg) )
            {
                b.addEvent(defevent,defarg);
            }
        }
        b.setState(b.oProcessState,pArg);
    }
    else
    {
   // trigger events
   FsmEvent event = dia_SystemSettingsFSM::evUnknown;

   event = dia_SystemSettingsFSM::evProcessingFailed; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
    }
}

void
ProcessingFailedState::evSystemSettingRequest( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SystemSettingsFSM::evSystemSettingRequest;

   b.addDeferredEvent(event,pArg);
}

void
ProcessingFailedState::evRemoteSystemSettingRequest( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SystemSettingsFSM::evRemoteSystemSettingRequest;

   b.addDeferredEvent(event,pArg);
}

void
ProcessingFailedState::evSlaveMode( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SystemSettingsFSM::evSlaveMode;

   b.addDeferredEvent(event,pArg);
}

void
ProcessingFailedState::evReturnControl( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SystemSettingsFSM::evReturnControl;

   b.addDeferredEvent(event,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SlaveModeState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

SlaveModeState::SlaveModeState ( void )
{}

void
SlaveModeState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oIdleState,pArg);
}

void
SlaveModeState::evRemoteSystemSettingRequest ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmInitializeSlaveSystemSetting(pArg);
   // trigger events
   FsmEvent event = dia_SystemSettingsFSM::evUnknown;

   event = dia_SystemSettingsFSM::evStartProcessing; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oSlaveSystemSettingState,pArg);
}

void
SlaveModeState::evReturnControl ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmFinalizeSlaveMode(pArg);
   s.vFsmSendRemoteControlResponseToMaster(pArg);
   b.setState(b.oIdleState,nullptr); //Coverity fix(CID:830148)
}

void
SlaveModeState::evSlaveMode ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendRemoteControlResponseToMaster(pArg);
   // this is an internal transition
}

void
SlaveModeState::evSystemSettingRequest ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmRejectSystemSettingRequest(pArg);
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SlaveSystemSettingState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

SlaveSystemSettingState::SlaveSystemSettingState ( void )
   : _numDeferredEvents(0)
{
   (void) ::memset(_deferredEvents, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
   (void) ::memset(_deferredParams, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
}

void
SlaveSystemSettingState::evFailed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // set savepoint in superstate with enabled history
   b.oSystemSettingActiveState.savepoint(b);

   // transition Actions
   s.vFsmFinalizeSlaveProcessing(pArg);
   s.vFsmSendNegResponseToMaster(pArg);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oSlaveModeState,pArg);
}

void
SlaveSystemSettingState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // set savepoint in superstate with enabled history
   b.oSystemSettingActiveState.savepoint(b);

   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oIdleState,pArg);
}

void
SlaveSystemSettingState::evPluginsProcessed ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // set savepoint in superstate with enabled history
   b.oSystemSettingActiveState.savepoint(b);

   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oProcessSystemSettingState,pArg);
}

void
SlaveSystemSettingState::evStartProcessing ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmInitializeSlaveProcessing(pArg);
   s.vFsmProcessPlugins(pArg);
   // this is an internal transition
}

void
SlaveSystemSettingState::evSuccess ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // set savepoint in superstate with enabled history
   b.oSystemSettingActiveState.savepoint(b);

   // transition Actions
   s.vFsmFinalizeSlaveProcessing(pArg);
   s.vFsmSendPosResponseToMaster(pArg);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oSlaveModeState,pArg);
}

void
SlaveSystemSettingState::evSystemSettingRequest( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SystemSettingsFSM::evSystemSettingRequest;

   b.addDeferredEvent(event,pArg);
}

void
SlaveSystemSettingState::evRemoteSystemSettingRequest( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SystemSettingsFSM::evRemoteSystemSettingRequest;

   b.addDeferredEvent(event,pArg);
}

void
SlaveSystemSettingState::evSlaveMode( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SystemSettingsFSM::evSlaveMode;

   b.addDeferredEvent(event,pArg);
}

void
SlaveSystemSettingState::evReturnControl( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SystemSettingsFSM::evReturnControl;

   b.addDeferredEvent(event,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SystemSettingActiveState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

SystemSettingActiveState::SystemSettingActiveState ( void )
   : _numDeferredEvents(0)
{
   (void) ::memset(_deferredEvents, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
   (void) ::memset(_deferredParams, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
}

void
SystemSettingActiveState::savepoint ( FsmBody& b )
{
   if ( _historyEnable )
   {
      _history = b.getState();
      while (  _history && (_history->getStateName() != b.oMasterSystemSettingState.getStateName()) && (_history->getStateName() != b.oSlaveSystemSettingState.getStateName()) )
      {
         _history = const_cast<FsmState*>(_history)->getParent();
      }
   }
}

void
SystemSettingActiveState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   savepoint(b);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oIdleState,pArg);
}

void
SystemSettingActiveState::evSystemSettingRequest( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SystemSettingsFSM::evSystemSettingRequest;

   b.addDeferredEvent(event,pArg);
}

void
SystemSettingActiveState::evRemoteSystemSettingRequest( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SystemSettingsFSM::evRemoteSystemSettingRequest;

   b.addDeferredEvent(event,pArg);
}

void
SystemSettingActiveState::evSlaveMode( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SystemSettingsFSM::evSlaveMode;

   b.addDeferredEvent(event,pArg);
}

void
SystemSettingActiveState::evReturnControl( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SystemSettingsFSM::evReturnControl;

   b.addDeferredEvent(event,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: TopLevelState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

TopLevelState::TopLevelState ( void )
{}

void
TopLevelState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oIdleState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

Fsm::Fsm ( void )
    : mpBehaviour(0),
      mpBody(0)
{
}

Fsm::Fsm ( FsmBehaviour* server )
    : mpBehaviour(server),
      mpBody(0)
{}

Fsm::~Fsm ( void )
{
    if ( mpBody )
    {
        delete mpBody;
        mpBody = 0;
    }
    mpBehaviour = 0;
}

bool
Fsm::createFSM ( Fsm** ppFSM, FsmBehaviour* behaviour )
{
   bool retCode = false;

   if ( ppFSM && behaviour )
   {
      (*ppFSM) = new Fsm(behaviour);
      if ( (*ppFSM) )
      {
         if ( !((*ppFSM)->init()) )
         {
            delete (*ppFSM);
            (*ppFSM) = 0;
         }
         else
         {
            retCode = true;
         }
      }
   }

   return retCode;
}

bool
Fsm::init ( void )
{
   bool retCode = false;
   
   mpBody = new FsmBody();
   
   if ( mpBody )
   {
      // connect the body with its frontend
      mpBody->connect(this);
      if ( mpBody->init() )
      {
          retCode = true;
      }
   }
   
   return retCode;
}

const char*
Fsm::getStateName (void) const
{
    return ( mpBody ) ? mpBody->getStateName() : 0;
}

void 
Fsm::acceptEvent ( FsmEvent event, void* pArg )
{
    if ( mpBody )
    {
        // forward the event to the FSM body (handle-body pattern)
        mpBody->acceptEvent(event,pArg);
    }
}
///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

FsmBody::FsmBody ( void ) :
      mpFrontend(0),
      mpState(0),
      mBusyFlag(false),
      mQueueHead(0),
      mQueueTail(0),
      mQueueSize(0),
      mPoolHead(0),
      mPoolTail(0),
      mPoolSize(0)
{
    (void) ::memset(mEventQueue,0,sizeof(FsmEvent)*MAX_TRIGGER_EVENTS);
    (void) ::memset(mParamQueue,0,sizeof(void*)*MAX_TRIGGER_EVENTS);
}

bool
FsmBody::init ( void )
{
    oExecuteSystemSettingState.initState(&oMasterSystemSettingState);
    oFinalizeSystemSettingState.initState(&oMasterSystemSettingState);
    oIdleState.initState(&oTopLevelState);
    oMasterSystemSettingState.initSuperState(&oSystemSettingActiveState, &oPrepareSystemSettingState, true);
    oPrepareSystemSettingState.initState(&oMasterSystemSettingState);
    oProcessState.initState(&oProcessSystemSettingState);
    oProcessSystemSettingState.initSuperState(&oTopLevelState, &oProcessState, false);
    oProcessingFailedState.initState(&oProcessSystemSettingState);
    oSlaveModeState.initState(&oTopLevelState);
    oSlaveSystemSettingState.initState(&oSystemSettingActiveState);
    oSystemSettingActiveState.initSuperState(&oTopLevelState, &oMasterSystemSettingState, true);
    oTopLevelState.initSuperState(0, &oIdleState, false);

    setState(oTopLevelState,0);
    
    return true;
}

void
FsmBody::connect ( Fsm* frontend )
{
    mpFrontend = frontend;
}

const char*
FsmBody::getStateName ( void ) const
{
    return ( mpState ) ? mpState->getStateName() : 0;
}

bool
FsmBody::addEvent ( const FsmEvent& event, void* param )
{
    if ( mQueueSize < MAX_TRIGGER_EVENTS )
    {
        mQueueSize++;
        mEventQueue[mQueueTail] = event;
        mParamQueue[mQueueTail] = param;
        mQueueTail++;
        if ( mQueueTail == MAX_TRIGGER_EVENTS )
        {
            mQueueTail = 0;
        }
        return true;
    }
    return false;
}

bool
FsmBody::getEvent ( FsmEvent& event, void** param )
{
    if ( !mQueueSize || !param )
    {
        return false;
    }
    mQueueSize--;
    event  = mEventQueue[mQueueHead];
    *param = mParamQueue[mQueueHead];
    mQueueHead++;
    if ( mQueueHead == MAX_TRIGGER_EVENTS )
    {
        mQueueHead = 0;
    }
    return true;
}

bool
FsmBody::isQueueEmpty ( void ) const
{
    return ( mQueueSize ) ? false : true;
}

bool
FsmBody::addDeferredEvent ( const FsmEvent& event, void* arg )
{
    if ( mPoolSize < MAX_DEFERRED_EVENTS )
    {
        mPoolSize++;
        mDeferredEventPool[mPoolTail].mEvent = event;
        mDeferredEventPool[mPoolTail].mArg   = arg;
        mPoolTail++;
        if ( mPoolTail == MAX_DEFERRED_EVENTS )
        {
            mPoolTail = 0;
        }
        return true;
    }
    return false;
}

bool
FsmBody::getDeferredEvent ( FsmEvent& event, void** pArg )
{
    if ( !mPoolSize || !pArg )
    {
        return false;
    }
    mPoolSize--;
    event = mDeferredEventPool[mPoolHead].mEvent;
    *pArg = mDeferredEventPool[mPoolHead].mArg;
    mPoolHead++;
    if ( mPoolHead == MAX_DEFERRED_EVENTS )
    {
        mPoolHead = 0;
    }
    return true;
}

bool
FsmBody::isPoolOfDeferredEventsEmpty ( void ) const
{
    return ( mPoolSize ) ? false : true;
}

void 
FsmBody::acceptEvent ( FsmEvent event, void* pArg )
{
    (void) addEvent(event,pArg);

    if ( mBusyFlag )
    {
        return;
    }

    mBusyFlag = true;
    while ( !isQueueEmpty() )
    {
        FsmEvent nextEvent = evUnknown;
        void*    nextArg   = 0;
        if ( !getEvent(nextEvent,&nextArg) )
        {
            break;
        }

        switch (nextEvent)
        {
        case evBackToSystemSettingActive:
            if ( mpState ) mpState->evBackToSystemSettingActive(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evFailed:
            if ( mpState ) mpState->evFailed(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evIdle:
            if ( mpState ) mpState->evIdle(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evPluginsProcessed:
            if ( mpState ) mpState->evPluginsProcessed(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evProcessingError:
            if ( mpState ) mpState->evProcessingError(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evProcessingFailed:
            if ( mpState ) mpState->evProcessingFailed(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evProcessingSucceeded:
            if ( mpState ) mpState->evProcessingSucceeded(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evProcessingTimeout:
            if ( mpState ) mpState->evProcessingTimeout(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evRemoteSystemSettingRequest:
            if ( mpState ) mpState->evRemoteSystemSettingRequest(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evResetMasterSystemSetting:
            if ( mpState ) mpState->evResetMasterSystemSetting(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evResponseEvaluated:
            if ( mpState ) mpState->evResponseEvaluated(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evResponseReceived:
            if ( mpState ) mpState->evResponseReceived(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evRetry:
            if ( mpState ) mpState->evRetry(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evReturnControl:
            if ( mpState ) mpState->evReturnControl(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evSlaveMode:
            if ( mpState ) mpState->evSlaveMode(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evStartProcessing:
            if ( mpState ) mpState->evStartProcessing(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evSuccess:
            if ( mpState ) mpState->evSuccess(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evSystemSettingRequest:
            if ( mpState ) mpState->evSystemSettingRequest(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        default:
            //... unknown event ...
            break;
        } //lint !e788: not all items used within defaulted switch
    }
    mBusyFlag = false;
}

void 
FsmBody::setState ( FsmState& state, void* pArg )
{
    if ( mpFrontend )
    {
        mpState = const_cast<FsmState*>(state.propagate(*this,*(mpFrontend->mpBehaviour),pArg));
    }
}

void 
FsmBody::setState ( FsmState* pState )
{
    mpState = pState;
}

const FsmState*
FsmBody::getState ( void ) const
{
    return mpState;
}


} // namespace
