///////////////////////////////////////////////////////////////////////////////
//
// File: dia_SecurityLevelFSM.cpp
//
// Generated by SMC 4.4.2 (C++ State Pattern Code Generator)
//
///////////////////////////////////////////////////////////////////////////////

#include <string.h>

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SECURITYLEVELFSM__
#include "dia_SecurityLevelFSM.h"
#endif

namespace dia_SecurityLevelFSM
{

const unsigned int MAX_TRIGGER_EVENTS = 20;

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class Fsm;
class FsmSuperState;

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states.
//
///////////////////////////////////////////////////////////////////////////////

class FsmState
{
public:
   //! name of the FSM's state
   virtual const char* getStateName ( void ) const = 0;

   //! resetting state internals
   virtual void reset ( void ) {}

   // event functions 
   virtual void evActivate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evActivationConfirmed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evActivationFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evCheckKeyCtrl ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDeactivate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evKeyReceived ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evKeyTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evLockTimeExpired ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNumOfAttemptsExceeded ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evOnKeyValidationDone ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evOnSeedAvailable ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evOperationModeUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReset ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSeedRequested ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChanged ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! default implementation for the Entry action
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! default implementation for the Exit action
   virtual void exit  ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! return the parent state
   virtual FsmSuperState* getParent ( void );

   //! assign the body object
   void initState ( FsmSuperState* pParent );

protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmState ( void );
   //! class destructor
   virtual ~FsmState ( void );

   //! pointer to the superstate
   FsmSuperState* mpParent;
};

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

class FsmSuperState
   : public FsmState
{
public:
   //! set a savepoint for the history
   virtual void savepoint ( FsmBody& b );
   //! default action
   virtual void defaultAction ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! resetting state internals
   virtual void reset ( void ) { _history = 0; }

   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! assign the body object
   void initSuperState ( FsmSuperState* pParent, FsmState* defState, bool histEnable=false );

protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmSuperState ( void );

   //! pointer to the default substate
   FsmState* _default;
   //! pointer to the history substate
   const FsmState* _history;
   //! flag that indicates if history is enabled or not
   bool _historyEnable;
};

///////////////////////////////////////////////////////////////////////////////
// 
// Class: EvaluatingKeyState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class EvaluatingKeyState
   : public FsmState
{
public:
   //! default constructor
   EvaluatingKeyState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evOnKeyValidationDone ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReset ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChanged ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* EvaluatingKeyState::mStateName = "EvaluatingKey";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: GeneratingSeedState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class GeneratingSeedState
   : public FsmState
{
public:
   //! default constructor
   GeneratingSeedState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evKeyReceived ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evOnSeedAvailable ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReset ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChanged ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* GeneratingSeedState::mStateName = "GeneratingSeed";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: IdleState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class IdleState
   : public FsmState
{
public:
   //! default constructor
   IdleState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evOperationModeUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChanged ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* IdleState::mStateName = "Idle";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: RunningSeedAndKeyPolicyState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class RunningSeedAndKeyPolicyState
   : public FsmSuperState
{
public:
   //! default constructor
   RunningSeedAndKeyPolicyState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evReset ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChanged ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* RunningSeedAndKeyPolicyState::mStateName = "RunningSeedAndKeyPolicy";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SecLevelActiveState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class SecLevelActiveState
   : public FsmSuperState
{
public:
   //! default constructor
   SecLevelActiveState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evActivate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evActivationConfirmed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evActivationFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDeactivate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evKeyReceived ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNumOfAttemptsExceeded ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReset ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSeedRequested ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChanged ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! set a savepoint for the history
   virtual void savepoint ( FsmBody& b );

protected:
   static const char* mStateName;
};

const char* SecLevelActiveState::mStateName = "SecLevelActive";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SecLevelActiveNoRestrictionState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class SecLevelActiveNoRestrictionState
   : public FsmState
{
public:
   //! default constructor
   SecLevelActiveNoRestrictionState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evActivate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evActivationConfirmed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evActivationFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDeactivate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evKeyReceived ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNumOfAttemptsExceeded ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReset ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSeedRequested ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChanged ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* SecLevelActiveNoRestrictionState::mStateName = "SecLevelActiveNoRestriction";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SecLevelActiveRestrictedToSessionState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class SecLevelActiveRestrictedToSessionState
   : public FsmState
{
public:
   //! default constructor
   SecLevelActiveRestrictedToSessionState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evActivate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evActivationConfirmed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evActivationFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evDeactivate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evKeyReceived ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNumOfAttemptsExceeded ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReset ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSeedRequested ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChanged ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* SecLevelActiveRestrictedToSessionState::mStateName = "SecLevelActiveRestrictedToSession";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SecLevelInitializeState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class SecLevelInitializeState
   : public FsmState
{
public:
   //! default constructor
   SecLevelInitializeState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evCheckKeyCtrl ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReset ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChanged ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* SecLevelInitializeState::mStateName = "SecLevelInitialize";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SecLevelLockedState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class SecLevelLockedState
   : public FsmState
{
public:
   //! default constructor
   SecLevelLockedState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evKeyReceived ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evLockTimeExpired ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReset ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSeedRequested ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChanged ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! exit actions
   virtual void exit ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* SecLevelLockedState::mStateName = "SecLevelLocked";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SecLevelNotActiveState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class SecLevelNotActiveState
   : public FsmState
{
public:
   //! default constructor
   SecLevelNotActiveState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evActivate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evActivationConfirmed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evActivationFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evKeyReceived ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNumOfAttemptsExceeded ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReset ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSeedRequested ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChanged ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* SecLevelNotActiveState::mStateName = "SecLevelNotActive";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SecLevelRunningState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class SecLevelRunningState
   : public FsmSuperState
{
public:
   //! default constructor
   SecLevelRunningState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evActivationConfirmed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evActivationFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNumOfAttemptsExceeded ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReset ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChanged ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! set a savepoint for the history
   virtual void savepoint ( FsmBody& b );

protected:
   static const char* mStateName;
};

const char* SecLevelRunningState::mStateName = "SecLevelRunning";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SecurityAccessDisabledState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class SecurityAccessDisabledState
   : public FsmState
{
public:
   //! default constructor
   SecurityAccessDisabledState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evKeyReceived ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSeedRequested ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChanged ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* SecurityAccessDisabledState::mStateName = "SecurityAccessDisabled";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SecurityAccessEnabledState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class SecurityAccessEnabledState
   : public FsmSuperState
{
public:
   //! default constructor
   SecurityAccessEnabledState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evReset ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChanged ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! default action
   virtual void defaultAction ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* SecurityAccessEnabledState::mStateName = "SecurityAccessEnabled";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: TopLevelState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class TopLevelState
   : public FsmSuperState
{
public:
   //! default constructor
   TopLevelState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evSessionChanged ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! default action
   virtual void defaultAction ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* TopLevelState::mStateName = "TopLevel";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: WaitingForKeyState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class WaitingForKeyState
   : public FsmState
{
public:
   //! default constructor
   WaitingForKeyState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evKeyReceived ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evKeyTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReset ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSeedRequested ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSessionChanged ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! exit actions
   virtual void exit ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* WaitingForKeyState::mStateName = "WaitingForKey";

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBody
//
// This is the finite state machine's body class 'FsmBody'.
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody
{
    struct FsmDeferredEvent
    {
          FsmDeferredEvent() : mEvent(evUnknown), mArg(0) {}
          FsmEvent mEvent;
          void*    mArg;
    };

public:
    //! class constructor
    FsmBody ( void );

    //! connect the FSM body with its frontend
    void connect ( Fsm* frontend );

    //! initialize the FSM: set initial state and execute initial actions
    bool init ( void );

    //! this method is used to stimulate the FSM with events
    void acceptEvent ( FsmEvent event, void* pArg );
    void processEvents ( void );

    //! return the name of the active state
    const char* getStateName ( void ) const;

    //! push trigger events to the event queue
    bool addEvent ( const FsmEvent& event, void* arg  );
    //! get event from the event queue
    bool getEvent ( FsmEvent& event, void** arg  );
    //! get event from the event queue
    bool isQueueEmpty ( void ) const;

    // set the FSM's internal state and propagate to default or history substate
    void setState ( FsmState& state, void* pArg );
    // set the FSM's internal state (no propagation
    void setState ( FsmState* pState );
    // return the active state object
    const FsmState* getState ( void ) const;

    //! static state objects
    EvaluatingKeyState oEvaluatingKeyState;
    GeneratingSeedState oGeneratingSeedState;
    IdleState oIdleState;
    RunningSeedAndKeyPolicyState oRunningSeedAndKeyPolicyState;
    SecLevelActiveState oSecLevelActiveState;
    SecLevelActiveNoRestrictionState oSecLevelActiveNoRestrictionState;
    SecLevelActiveRestrictedToSessionState oSecLevelActiveRestrictedToSessionState;
    SecLevelInitializeState oSecLevelInitializeState;
    SecLevelLockedState oSecLevelLockedState;
    SecLevelNotActiveState oSecLevelNotActiveState;
    SecLevelRunningState oSecLevelRunningState;
    SecurityAccessDisabledState oSecurityAccessDisabledState;
    SecurityAccessEnabledState oSecurityAccessEnabledState;
    TopLevelState oTopLevelState;
    WaitingForKeyState oWaitingForKeyState;

    //! frontend for this body
    Fsm* mpFrontend;
    //! link to the active state object
    FsmState* mpState;

    //! busy indicator flag
    bool mBusyFlag;

    //! queue of trigger events
    FsmEvent mEventQueue[MAX_TRIGGER_EVENTS];
    //! queue of arguments for trigger events
    void*    mParamQueue[MAX_TRIGGER_EVENTS];
    //! index of the queue's front element
    unsigned int mQueueHead;
    //! index of the queue's back element
    unsigned int mQueueTail;
    //! number of queued events
    unsigned int mQueueSize;
};

///////////////////////////////////////////////////////////////////////////////
//
// Default implementation for all events.
//
///////////////////////////////////////////////////////////////////////////////

void
FsmState::evActivate ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evActivate *** 
}

void
FsmState::evActivationConfirmed ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evActivationConfirmed *** 
}

void
FsmState::evActivationFailed ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evActivationFailed *** 
}

void
FsmState::evCheckKeyCtrl ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evCheckKeyCtrl *** 
}

void
FsmState::evDeactivate ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evDeactivate *** 
}

void
FsmState::evKeyReceived ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evKeyReceived *** 
}

void
FsmState::evKeyTimeout ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evKeyTimeout *** 
}

void
FsmState::evLockTimeExpired ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evLockTimeExpired *** 
}

void
FsmState::evNumOfAttemptsExceeded ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evNumOfAttemptsExceeded *** 
}

void
FsmState::evOnKeyValidationDone ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evOnKeyValidationDone *** 
}

void
FsmState::evOnSeedAvailable ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evOnSeedAvailable *** 
}

void
FsmState::evOperationModeUpdate ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evOperationModeUpdate *** 
}

void
FsmState::evReset ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evReset *** 
}

void
FsmState::evSeedRequested ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evSeedRequested *** 
}

void
FsmState::evSessionChanged ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evSessionChanged *** 
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states components.
//
///////////////////////////////////////////////////////////////////////////////

FsmState::FsmState ( void )
   : mpParent(0)
{}

FsmState::~FsmState ( void )
{
   // make lint happy
   mpParent = 0;
}

void
FsmState::initState ( FsmSuperState* pParent )
{
   mpParent = pParent;
}

void
FsmState::entry ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

void
FsmState::exit ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

const FsmState*
FsmState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.setState(this);
   entry(b,s,pArg);
   return this;
}

FsmSuperState*
FsmState::getParent ( void )
{
   return (mpParent) ? mpParent : 0;
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

FsmSuperState::FsmSuperState ( void )
   : _default(0),
     _history(0),
     _historyEnable(false)
{}

void
FsmSuperState::initSuperState ( FsmSuperState* pParent, FsmState* defState, bool histEnable )
{
   mpParent = pParent;
   _default = defState;
   _history = 0;
   _historyEnable = histEnable;
}

const FsmState*
FsmSuperState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   const FsmState* pState = 0;

   // we have crossed a state boundary
   b.setState(this);
   // execute the entry actions for this superstate
   entry(b,s,pArg);
   
   if ( _history && _historyEnable )
   {
      pState = const_cast<FsmState*>(_history)->propagate(b,s,pArg);
   }
   else
   {
      defaultAction(b,s,pArg);
      if ( _default ) {
         pState = _default->propagate(b,s,pArg);
      }
   }
   
   return pState;
}

void
FsmSuperState::savepoint ( FsmBody& b )
{
   if ( _historyEnable )
   {
      _history = b.getState();
   }
}

void
FsmSuperState::defaultAction ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /*pArg*/ )
{
   //... empty as default ...
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: EvaluatingKeyState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

EvaluatingKeyState::EvaluatingKeyState ( void )
{}

void
EvaluatingKeyState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmValidateKey(pArg);
}

void
EvaluatingKeyState::evOnKeyValidationDone ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isKeyInvalid(pArg) )
   {
        // transition Actions
        s.vFsmInvalidAttempt(pArg);
        s.vFsmSaveKeyCtrlToNvm(pArg);
        s.vFsmSetErrCode_InvalidKey(pArg);
        s.vFsmSendKeyNotAccepted(pArg);
        // trigger events
        FsmEvent event = dia_SecurityLevelFSM::evUnknown;

        event = dia_SecurityLevelFSM::evActivationFailed; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        b.setState(b.oSecLevelRunningState,pArg);
    }
    else
    {
   // transition Actions
   s.vFsmSendKeyAccepted(pArg);
   // trigger events
   FsmEvent event = dia_SecurityLevelFSM::evUnknown;

   event = dia_SecurityLevelFSM::evActivationConfirmed; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oSecLevelRunningState,pArg);
    }
}

void
EvaluatingKeyState::evReset ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oSecLevelInitializeState,pArg);
}

void
EvaluatingKeyState::evSessionChanged ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: GeneratingSeedState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

GeneratingSeedState::GeneratingSeedState ( void )
{}

void
GeneratingSeedState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmCalculateSeed(pArg);
}

void
GeneratingSeedState::evKeyReceived ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSetErrCode_RequestSequence(pArg);
   // this is an internal transition
}

void
GeneratingSeedState::evOnSeedAvailable ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendSeed(pArg);
   b.setState(b.oWaitingForKeyState,pArg);
}

void
GeneratingSeedState::evReset ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oSecLevelInitializeState,pArg);
}

void
GeneratingSeedState::evSessionChanged ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: IdleState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

IdleState::IdleState ( void )
{}

void
IdleState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmEvaluateOperationMode(pArg);
   s.vFsmActivateAtStartup(pArg);
}

void
IdleState::evOperationModeUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isSimulationEnabled(pArg) )
   {
        b.setState(b.oSecurityAccessDisabledState,pArg);
    }
    else
    {
   // trigger events
   FsmEvent event = dia_SecurityLevelFSM::evUnknown;

   event = dia_SecurityLevelFSM::evCheckKeyCtrl; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oSecurityAccessEnabledState,pArg);
    }
}

void
IdleState::evSessionChanged ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: RunningSeedAndKeyPolicyState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

RunningSeedAndKeyPolicyState::RunningSeedAndKeyPolicyState ( void )
{}

void
RunningSeedAndKeyPolicyState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmInitializeSeedAndKeyPolicy(pArg);
}

void
RunningSeedAndKeyPolicyState::evReset ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oSecLevelInitializeState,pArg);
}

void
RunningSeedAndKeyPolicyState::evSessionChanged ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SecLevelActiveState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

SecLevelActiveState::SecLevelActiveState ( void )
{}

void
SecLevelActiveState::savepoint ( FsmBody& b )
{
   if ( _historyEnable )
   {
      _history = b.getState();
      while (  _history && (_history->getStateName() != b.oSecLevelActiveNoRestrictionState.getStateName()) && (_history->getStateName() != b.oSecLevelActiveRestrictedToSessionState.getStateName()) )
      {
         _history = const_cast<FsmState*>(_history)->getParent();
      }
   }
}

void
SecLevelActiveState::evActivate ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

void
SecLevelActiveState::evActivationConfirmed ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmHandleActivation(pArg);
   // this is an internal transition
}

void
SecLevelActiveState::evActivationFailed ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmHandleFailedActivation(pArg);
   // this is an internal transition
}

void
SecLevelActiveState::evDeactivate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   savepoint(b);
   // transition Actions
   s.vFsmDeactivate(pArg);
   b.setState(b.oSecLevelNotActiveState,pArg);
}

void
SecLevelActiveState::evKeyReceived ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSetErrCode_RequestSequence(pArg);
   // this is an internal transition
}

void
SecLevelActiveState::evNumOfAttemptsExceeded ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   savepoint(b);
   // set savepoint in superstate with enabled history
   b.oSecLevelRunningState.savepoint(b);

   b.setState(b.oSecLevelLockedState,pArg);
}

void
SecLevelActiveState::evReset ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   savepoint(b);
   // set savepoint in superstate with enabled history
   b.oSecLevelRunningState.savepoint(b);

   // transition Actions
   s.vFsmDeactivate(pArg);
   b.setState(b.oSecLevelInitializeState,pArg);
}

void
SecLevelActiveState::evSeedRequested ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.needToRunSeedKeyPolicy(pArg) )
   {
        savepoint(b);
        // set savepoint in superstate with enabled history
        b.oSecLevelRunningState.savepoint(b);

        b.setState(b.oRunningSeedAndKeyPolicyState,pArg);
    }
    else
    {
   // transition Actions
   s.vFsmSendSeedWhenActive(pArg);
   // this is an internal transition
    }
}

void
SecLevelActiveState::evSessionChanged ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SecLevelActiveNoRestrictionState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

SecLevelActiveNoRestrictionState::SecLevelActiveNoRestrictionState ( void )
{}

void
SecLevelActiveNoRestrictionState::evActivate ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

void
SecLevelActiveNoRestrictionState::evActivationConfirmed ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmHandleActivation(pArg);
   // this is an internal transition
}

void
SecLevelActiveNoRestrictionState::evActivationFailed ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmHandleFailedActivation(pArg);
   // this is an internal transition
}

void
SecLevelActiveNoRestrictionState::evDeactivate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // set savepoint in superstate with enabled history
   b.oSecLevelActiveState.savepoint(b);

   // transition Actions
   s.vFsmDeactivate(pArg);
   b.setState(b.oSecLevelNotActiveState,pArg);
}

void
SecLevelActiveNoRestrictionState::evKeyReceived ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSetErrCode_RequestSequence(pArg);
   // this is an internal transition
}

void
SecLevelActiveNoRestrictionState::evNumOfAttemptsExceeded ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // set savepoint in superstate with enabled history
   b.oSecLevelActiveState.savepoint(b);

   // set savepoint in superstate with enabled history
   b.oSecLevelRunningState.savepoint(b);

   b.setState(b.oSecLevelLockedState,pArg);
}

void
SecLevelActiveNoRestrictionState::evReset ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // set savepoint in superstate with enabled history
   b.oSecLevelActiveState.savepoint(b);

   // set savepoint in superstate with enabled history
   b.oSecLevelRunningState.savepoint(b);

   // transition Actions
   s.vFsmDeactivate(pArg);
   b.setState(b.oSecLevelInitializeState,pArg);
}

void
SecLevelActiveNoRestrictionState::evSeedRequested ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.needToRunSeedKeyPolicy(pArg) )
   {
        // set savepoint in superstate with enabled history
        b.oSecLevelActiveState.savepoint(b);

        // set savepoint in superstate with enabled history
        b.oSecLevelRunningState.savepoint(b);

        b.setState(b.oRunningSeedAndKeyPolicyState,pArg);
    }
    else
    {
   // transition Actions
   s.vFsmSendSeedWhenActive(pArg);
   // this is an internal transition
    }
}

void
SecLevelActiveNoRestrictionState::evSessionChanged ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SecLevelActiveRestrictedToSessionState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

SecLevelActiveRestrictedToSessionState::SecLevelActiveRestrictedToSessionState ( void )
{}

void
SecLevelActiveRestrictedToSessionState::evActivate ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

void
SecLevelActiveRestrictedToSessionState::evActivationConfirmed ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmHandleActivation(pArg);
   // this is an internal transition
}

void
SecLevelActiveRestrictedToSessionState::evActivationFailed ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmHandleFailedActivation(pArg);
   // this is an internal transition
}

void
SecLevelActiveRestrictedToSessionState::evDeactivate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // set savepoint in superstate with enabled history
   b.oSecLevelActiveState.savepoint(b);

   // transition Actions
   s.vFsmDeactivate(pArg);
   b.setState(b.oSecLevelNotActiveState,pArg);
}

void
SecLevelActiveRestrictedToSessionState::evKeyReceived ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSetErrCode_RequestSequence(pArg);
   // this is an internal transition
}

void
SecLevelActiveRestrictedToSessionState::evNumOfAttemptsExceeded ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // set savepoint in superstate with enabled history
   b.oSecLevelActiveState.savepoint(b);

   // set savepoint in superstate with enabled history
   b.oSecLevelRunningState.savepoint(b);

   b.setState(b.oSecLevelLockedState,pArg);
}

void
SecLevelActiveRestrictedToSessionState::evReset ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // set savepoint in superstate with enabled history
   b.oSecLevelActiveState.savepoint(b);

   // set savepoint in superstate with enabled history
   b.oSecLevelRunningState.savepoint(b);

   // transition Actions
   s.vFsmDeactivate(pArg);
   b.setState(b.oSecLevelInitializeState,pArg);
}

void
SecLevelActiveRestrictedToSessionState::evSeedRequested ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.needToRunSeedKeyPolicy(pArg) )
   {
        // set savepoint in superstate with enabled history
        b.oSecLevelActiveState.savepoint(b);

        // set savepoint in superstate with enabled history
        b.oSecLevelRunningState.savepoint(b);

        b.setState(b.oRunningSeedAndKeyPolicyState,pArg);
    }
    else
    {
   // transition Actions
   s.vFsmSendSeedWhenActive(pArg);
   // this is an internal transition
    }
}

void
SecLevelActiveRestrictedToSessionState::evSessionChanged ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // set savepoint in superstate with enabled history
   b.oSecLevelActiveState.savepoint(b);

   // transition Actions
   s.vFsmDeactivate(pArg);
   b.setState(b.oSecLevelNotActiveState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SecLevelInitializeState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

SecLevelInitializeState::SecLevelInitializeState ( void )
{}

void
SecLevelInitializeState::evCheckKeyCtrl ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isLockRequired(pArg) )
   {
        b.setState(b.oSecLevelLockedState,pArg);
    }
    else
    {
   b.setState(b.oSecLevelRunningState,pArg);
    }
}

void
SecLevelInitializeState::evReset ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

void
SecLevelInitializeState::evSessionChanged ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SecLevelLockedState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

SecLevelLockedState::SecLevelLockedState ( void )
{}

void
SecLevelLockedState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmSetRemainingLockTime(pArg);
   s.vFsmLock(pArg);
}

void
SecLevelLockedState::exit ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmSaveKeyCtrlToNvm(pArg);
   s.vFsmUnlock(pArg);
}

void
SecLevelLockedState::evKeyReceived ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSetErrCode_RequestSequence(pArg);
   // this is an internal transition
}

void
SecLevelLockedState::evLockTimeExpired ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oSecLevelRunningState,pArg);
}

void
SecLevelLockedState::evReset ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oSecLevelInitializeState,pArg);
}

void
SecLevelLockedState::evSeedRequested ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSetErrCode_RequiredTimeDelayNotExpired(pArg);
   // this is an internal transition
}

void
SecLevelLockedState::evSessionChanged ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SecLevelNotActiveState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

SecLevelNotActiveState::SecLevelNotActiveState ( void )
{}

void
SecLevelNotActiveState::evActivate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isSessionControlled(pArg) )
   {
        // transition Actions
        s.vFsmActivate(pArg);
        b.setState(b.oSecLevelActiveRestrictedToSessionState,pArg);
    }
    else
    {
   // transition Actions
   s.vFsmActivate(pArg);
   b.setState(b.oSecLevelActiveNoRestrictionState,pArg);
    }
}

void
SecLevelNotActiveState::evActivationConfirmed ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmHandleActivation(pArg);
   // this is an internal transition
}

void
SecLevelNotActiveState::evActivationFailed ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmHandleFailedActivation(pArg);
   // this is an internal transition
}

void
SecLevelNotActiveState::evKeyReceived ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSetErrCode_RequestSequence(pArg);
   // this is an internal transition
}

void
SecLevelNotActiveState::evNumOfAttemptsExceeded ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // set savepoint in superstate with enabled history
   b.oSecLevelRunningState.savepoint(b);

   b.setState(b.oSecLevelLockedState,pArg);
}

void
SecLevelNotActiveState::evReset ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // set savepoint in superstate with enabled history
   b.oSecLevelRunningState.savepoint(b);

   b.setState(b.oSecLevelInitializeState,pArg);
}

void
SecLevelNotActiveState::evSeedRequested ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // set savepoint in superstate with enabled history
   b.oSecLevelRunningState.savepoint(b);

   b.setState(b.oRunningSeedAndKeyPolicyState,pArg);
}

void
SecLevelNotActiveState::evSessionChanged ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SecLevelRunningState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

SecLevelRunningState::SecLevelRunningState ( void )
{}

void
SecLevelRunningState::savepoint ( FsmBody& b )
{
   if ( _historyEnable )
   {
      _history = b.getState();
      while (  _history && (_history->getStateName() != b.oSecLevelNotActiveState.getStateName()) && (_history->getStateName() != b.oSecLevelActiveState.getStateName()) )
      {
         _history = const_cast<FsmState*>(_history)->getParent();
      }
   }
}

void
SecLevelRunningState::evActivationConfirmed ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmHandleActivation(pArg);
   // this is an internal transition
}

void
SecLevelRunningState::evActivationFailed ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmHandleFailedActivation(pArg);
   // this is an internal transition
}

void
SecLevelRunningState::evNumOfAttemptsExceeded ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   savepoint(b);
   b.setState(b.oSecLevelLockedState,pArg);
}

void
SecLevelRunningState::evReset ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   savepoint(b);
   b.setState(b.oSecLevelInitializeState,pArg);
}

void
SecLevelRunningState::evSessionChanged ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SecurityAccessDisabledState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

SecurityAccessDisabledState::SecurityAccessDisabledState ( void )
{}

void
SecurityAccessDisabledState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmActivate(pArg);
}

void
SecurityAccessDisabledState::evKeyReceived ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   if ( s.wasSeedRequested(pArg) )
   {
        // transition Actions
        s.vFsmSimulateKeyAccepted(pArg);
        // this is an internal transition
    }
    else
    {
   // transition Actions
   s.vFsmSetErrCode_RequestSequence(pArg);
   // this is an internal transition
    }
}

void
SecurityAccessDisabledState::evSeedRequested ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSimulateCalcSeed(pArg);
   s.vFsmSimulateSeedResponse(pArg);
   // this is an internal transition
}

void
SecurityAccessDisabledState::evSessionChanged ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SecurityAccessEnabledState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

SecurityAccessEnabledState::SecurityAccessEnabledState ( void )
{}

void
SecurityAccessEnabledState::defaultAction ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
    s.vFsmCopyKeyCtrlFromNvm(pArg);
    s.vFsmDeactivate(pArg);
}

void
SecurityAccessEnabledState::evReset ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oSecLevelInitializeState,pArg);
}

void
SecurityAccessEnabledState::evSessionChanged ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: TopLevelState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

TopLevelState::TopLevelState ( void )
{}

void
TopLevelState::defaultAction ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
    s.vFsmInitializeSecurityLevel(pArg);
}

void
TopLevelState::evSessionChanged ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: WaitingForKeyState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

WaitingForKeyState::WaitingForKeyState ( void )
{}

void
WaitingForKeyState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmStartKeyTimer(pArg);
}

void
WaitingForKeyState::exit ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmStopKeyTimer(pArg);
}

void
WaitingForKeyState::evKeyReceived ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isLevelInvalid(pArg) )
   {
        // transition Actions
        s.vFsmSetErrCode_InvalidLevel(pArg);
        // this is an internal transition
    }
    else
    {
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oEvaluatingKeyState,pArg);
    }
}

void
WaitingForKeyState::evKeyTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oSecLevelRunningState,pArg);
}

void
WaitingForKeyState::evReset ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oSecLevelInitializeState,pArg);
}

void
WaitingForKeyState::evSeedRequested ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oGeneratingSeedState,pArg);
}

void
WaitingForKeyState::evSessionChanged ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

Fsm::Fsm ( void )
    : mpBehaviour(0),
      mpBody(0)
{
}

Fsm::Fsm ( FsmBehaviour* server )
    : mpBehaviour(server),
      mpBody(0)
{}

Fsm::~Fsm ( void )
{
    if ( mpBody )
    {
        delete mpBody;
        mpBody = 0;
    }
    mpBehaviour = 0;
}

bool
Fsm::createFSM ( Fsm** ppFSM, FsmBehaviour* behaviour )
{
   bool retCode = false;

   if ( ppFSM && behaviour )
   {
      (*ppFSM) = new Fsm(behaviour);
      if ( (*ppFSM) )
      {
         if ( !((*ppFSM)->init()) )
         {
            delete (*ppFSM);
            (*ppFSM) = 0;
         }
         else
         {
            retCode = true;
         }
      }
   }

   return retCode;
}

bool
Fsm::init ( void )
{
   bool retCode = false;
   
   mpBody = new FsmBody();
   
   if ( mpBody )
   {
      // connect the body with its frontend
      mpBody->connect(this);
      if ( mpBody->init() )
      {
          retCode = true;
      }
   }
   
   return retCode;
}

const char*
Fsm::getStateName (void) const
{
    return ( mpBody ) ? mpBody->getStateName() : 0;
}

void 
Fsm::acceptEvent ( FsmEvent event, void* pArg )
{
    if ( mpBody )
    {
        // forward the event to the FSM body (handle-body pattern)
        mpBody->acceptEvent(event,pArg);
    }
}
///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

FsmBody::FsmBody ( void ) :
      mpFrontend(0),
      mpState(0),
      mBusyFlag(false),
      mQueueHead(0),
      mQueueTail(0),
      mQueueSize(0)
{
    (void) ::memset(mEventQueue,0,sizeof(FsmEvent)*MAX_TRIGGER_EVENTS);
    (void) ::memset(mParamQueue,0,sizeof(void*)*MAX_TRIGGER_EVENTS);
}

bool
FsmBody::init ( void )
{
	mBusyFlag = true;
    oEvaluatingKeyState.initState(&oRunningSeedAndKeyPolicyState);
    oGeneratingSeedState.initState(&oRunningSeedAndKeyPolicyState);
    oIdleState.initState(&oTopLevelState);
    oRunningSeedAndKeyPolicyState.initSuperState(&oSecurityAccessEnabledState, &oGeneratingSeedState, false);
    oSecLevelActiveState.initSuperState(&oSecLevelRunningState, &oSecLevelActiveNoRestrictionState, true);
    oSecLevelActiveNoRestrictionState.initState(&oSecLevelActiveState);
    oSecLevelActiveRestrictedToSessionState.initState(&oSecLevelActiveState);
    oSecLevelInitializeState.initState(&oSecurityAccessEnabledState);
    oSecLevelLockedState.initState(&oSecurityAccessEnabledState);
    oSecLevelNotActiveState.initState(&oSecLevelRunningState);
    oSecLevelRunningState.initSuperState(&oSecurityAccessEnabledState, &oSecLevelNotActiveState, true);
    oSecurityAccessDisabledState.initState(&oTopLevelState);
    oSecurityAccessEnabledState.initSuperState(&oTopLevelState, &oSecLevelInitializeState, false);
    oTopLevelState.initSuperState(0, &oIdleState, false);
    oWaitingForKeyState.initState(&oRunningSeedAndKeyPolicyState);

    setState(oTopLevelState,0);
	mBusyFlag = false;
	processEvents();
    
    return true;
}

void
FsmBody::connect ( Fsm* frontend )
{
    mpFrontend = frontend;
}

const char*
FsmBody::getStateName ( void ) const
{
    return ( mpState ) ? mpState->getStateName() : 0;
}

bool
FsmBody::addEvent ( const FsmEvent& event, void* param )
{
    if ( mQueueSize < MAX_TRIGGER_EVENTS )
    {
        mQueueSize++;
        mEventQueue[mQueueTail] = event;
        mParamQueue[mQueueTail] = param;
        mQueueTail++;
        if ( mQueueTail == MAX_TRIGGER_EVENTS )
        {
            mQueueTail = 0;
        }
        return true;
    }
    return false;
}

bool
FsmBody::getEvent ( FsmEvent& event, void** param )
{
    if ( !mQueueSize || !param )
    {
        return false;
    }
    mQueueSize--;
    event  = mEventQueue[mQueueHead];
    *param = mParamQueue[mQueueHead];
    mQueueHead++;
    if ( mQueueHead == MAX_TRIGGER_EVENTS )
    {
        mQueueHead = 0;
    }
    return true;
}

bool
FsmBody::isQueueEmpty ( void ) const
{
    return ( mQueueSize ) ? false : true;
}

void 
FsmBody::acceptEvent ( FsmEvent event, void* pArg )
{
	(void) addEvent(event,pArg);

	if ( mBusyFlag ) return;

    processEvents();
}

void
FsmBody::processEvents ( void )
{
    mBusyFlag = true;
    while ( !isQueueEmpty() )
    {
        FsmEvent nextEvent = evUnknown;
        void*    nextArg   = 0;
        if ( !getEvent(nextEvent,&nextArg) )
        {
            break;
        }

        switch (nextEvent)
        {
        case evActivate:
            if ( mpState ) mpState->evActivate(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evActivationConfirmed:
            if ( mpState ) mpState->evActivationConfirmed(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evActivationFailed:
            if ( mpState ) mpState->evActivationFailed(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evCheckKeyCtrl:
            if ( mpState ) mpState->evCheckKeyCtrl(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evDeactivate:
            if ( mpState ) mpState->evDeactivate(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evKeyReceived:
            if ( mpState ) mpState->evKeyReceived(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evKeyTimeout:
            if ( mpState ) mpState->evKeyTimeout(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evLockTimeExpired:
            if ( mpState ) mpState->evLockTimeExpired(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evNumOfAttemptsExceeded:
            if ( mpState ) mpState->evNumOfAttemptsExceeded(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evOnKeyValidationDone:
            if ( mpState ) mpState->evOnKeyValidationDone(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evOnSeedAvailable:
            if ( mpState ) mpState->evOnSeedAvailable(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evOperationModeUpdate:
            if ( mpState ) mpState->evOperationModeUpdate(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evReset:
            if ( mpState ) mpState->evReset(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evSeedRequested:
            if ( mpState ) mpState->evSeedRequested(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evSessionChanged:
            if ( mpState ) mpState->evSessionChanged(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        default:
            //... unknown event ...
            break;
        } //lint !e788: not all items used within defaulted switch
    }
    mBusyFlag = false;
}

void 
FsmBody::setState ( FsmState& state, void* pArg )
{
    if ( mpFrontend )
    {
        mpState = const_cast<FsmState*>(state.propagate(*this,*(mpFrontend->mpBehaviour),pArg));
    }
}

void 
FsmBody::setState ( FsmState* pState )
{
    mpState = pState;
}

const FsmState*
FsmBody::getState ( void ) const
{
    return mpState;
}

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

const char* getEventName ( FsmEvent event )
{
   static const char* eventNames[evCount] = {
      "evUnknown",
      "evActivate",
      "evActivationConfirmed",
      "evActivationFailed",
      "evCheckKeyCtrl",
      "evDeactivate",
      "evKeyReceived",
      "evKeyTimeout",
      "evLockTimeExpired",
      "evNumOfAttemptsExceeded",
      "evOnKeyValidationDone",
      "evOnSeedAvailable",
      "evOperationModeUpdate",
      "evReset",
      "evSeedRequested",
      "evSessionChanged",
   };

   return eventNames[event];
}


} // namespace
