///////////////////////////////////////////////////////////////////////////////
//
// File: dia_SCCManagerFSM.cpp
//
// Generated by SMC 4.4.1 (C++ State Pattern Code Generator)
//
///////////////////////////////////////////////////////////////////////////////

#include <string.h>

#ifndef __INCLUDED_DIA_SCCMANAGERFSM__
#include "dia_SCCManagerFSM.h"
#endif

namespace dia_SCCManagerFSM
{

const unsigned int MAX_TRIGGER_EVENTS = 20;

const unsigned int MAX_DEFERRED_EVENTS = 25;

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class Fsm;
class FsmSuperState;

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states.
//
///////////////////////////////////////////////////////////////////////////////

class FsmState
{
public:
   //! name of the FSM's state
   virtual const char* getStateName ( void ) const = 0;

   //! resetting state internals
   virtual void reset ( void ) {}

   // event functions 
   virtual void evReconnect ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestStatusActive ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestStatusInactive ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReset ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evStatusUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! default implementation for the Entry action
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! default implementation for the Exit action
   virtual void exit  ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! return the parent state
   virtual FsmSuperState* getParent ( void );

   //! assign the body object
   void initState ( FsmSuperState* pParent );

protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmState ( void );
   //! class destructor
   virtual ~FsmState ( void );

   //! pointer to the superstate
   FsmSuperState* mpParent;
};

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

class FsmSuperState
   : public FsmState
{
public:
   //! set a savepoint for the history
   virtual void savepoint ( FsmBody& b );
   //! default action
   virtual void defaultAction ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! resetting state internals
   virtual void reset ( void ) { _history = 0; }

   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! assign the body object
   void initSuperState ( FsmSuperState* pParent, FsmState* defState, bool histEnable=false );

protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmSuperState ( void );

   //! pointer to the default substate
   FsmState* _default;
   //! pointer to the history substate
   const FsmState* _history;
   //! flag that indicates if history is enabled or not
   bool _historyEnable;
};

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ActivatingState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ActivatingState
   : public FsmState
{
public:
   //! default constructor
   ActivatingState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evRequestStatusActive ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReset ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evStatusUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! deferred events
   virtual void evRequestStatusInactive ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   //! array for recording received events to be deferred
   FsmEvent _deferredEvents[MAX_DEFERRED_EVENTS];
   //! array for recording params of events to be deferred
   void*    _deferredParams[MAX_DEFERRED_EVENTS];
   //! number of events currently deferred
   int _numDeferredEvents;


protected:
   static const char* mStateName;
};

const char* ActivatingState::mStateName = "Activating";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ActiveState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ActiveState
   : public FsmState
{
public:
   //! default constructor
   ActiveState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evReconnect ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestStatusActive ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestStatusInactive ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReset ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evStatusUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* ActiveState::mStateName = "Active";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DeactivatingState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class DeactivatingState
   : public FsmState
{
public:
   //! default constructor
   DeactivatingState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evRequestStatusInactive ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReset ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evStatusUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! deferred events
   virtual void evRequestStatusActive ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   //! array for recording received events to be deferred
   FsmEvent _deferredEvents[MAX_DEFERRED_EVENTS];
   //! array for recording params of events to be deferred
   void*    _deferredParams[MAX_DEFERRED_EVENTS];
   //! number of events currently deferred
   int _numDeferredEvents;


protected:
   static const char* mStateName;
};

const char* DeactivatingState::mStateName = "Deactivating";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: FinalState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class FinalState
   : public FsmState
{
public:
   //! default constructor
   FinalState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evRequestStatusActive ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestStatusInactive ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReset ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evStatusUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* FinalState::mStateName = "Final";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: InactiveState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class InactiveState
   : public FsmState
{
public:
   //! default constructor
   InactiveState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evRequestStatusActive ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestStatusInactive ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReset ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evStatusUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* InactiveState::mStateName = "Inactive";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: InitializingState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class InitializingState
   : public FsmState
{
public:
   //! default constructor
   InitializingState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evRequestStatusActive ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestStatusInactive ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReset ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evStatusUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* InitializingState::mStateName = "Initializing";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ReconnectingState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ReconnectingState
   : public FsmState
{
public:
   //! default constructor
   ReconnectingState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evRequestStatusActive ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestStatusInactive ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReset ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evStatusUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! exit actions
   virtual void exit ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* ReconnectingState::mStateName = "Reconnecting";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ToplevelState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ToplevelState
   : public FsmSuperState
{
public:
   //! default constructor
   ToplevelState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evRequestStatusActive ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestStatusInactive ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReset ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evStatusUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* ToplevelState::mStateName = "Toplevel";

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBody
//
// This is the finite state machine's body class 'FsmBody'.
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody
{
    struct FsmDeferredEvent
    {
          FsmDeferredEvent() : mEvent(evUnknown), mArg(0) {}
          FsmEvent mEvent;
          void*    mArg;
    };

public:
    //! class constructor
    FsmBody ( void );

    //! connect the FSM body with its frontend
    void connect ( Fsm* frontend );

    //! initialize the FSM: set initial state and execute initial actions
    bool init ( void );

    //! this method is used to stimulate the FSM with events
    void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the active state
    const char* getStateName ( void ) const;

    //! push trigger events to the event queue
    bool addEvent ( const FsmEvent& event, void* arg  );
    //! get event from the event queue
    bool getEvent ( FsmEvent& event, void** arg  );
    //! get event from the event queue
    bool isQueueEmpty ( void ) const;

    //! push deferred events to the pool of deferred events
    bool addDeferredEvent ( const FsmEvent& event, void* arg );
    //! get deferred event from the pool of deferred events
    bool getDeferredEvent ( FsmEvent& event, void** arg );
    //! check if the event pool is empty
    bool isPoolOfDeferredEventsEmpty ( void ) const;

    // set the FSM's internal state and propagate to default or history substate
    void setState ( FsmState& state, void* pArg );
    // set the FSM's internal state (no propagation
    void setState ( FsmState* pState );
    // return the active state object
    const FsmState* getState ( void ) const;

    //! static state objects
    ActivatingState oActivatingState;
    ActiveState oActiveState;
    DeactivatingState oDeactivatingState;
    FinalState oFinalState;
    InactiveState oInactiveState;
    InitializingState oInitializingState;
    ReconnectingState oReconnectingState;
    ToplevelState oToplevelState;

    //! frontend for this body
    Fsm* mpFrontend;
    //! link to the active state object
    FsmState* mpState;

    //! busy indicator flag
    bool mBusyFlag;

    //! queue of trigger events
    FsmEvent mEventQueue[MAX_TRIGGER_EVENTS];
    //! queue of arguments for trigger events
    void*    mParamQueue[MAX_TRIGGER_EVENTS];
    //! index of the queue's front element
    unsigned int mQueueHead;
    //! index of the queue's back element
    unsigned int mQueueTail;
    //! number of queued events
    unsigned int mQueueSize;
    //! pool of deferred events
    FsmDeferredEvent mDeferredEventPool[MAX_DEFERRED_EVENTS];
    //! index of the pool's front element
    unsigned int mPoolHead;
    //! index of the pool's back element
    unsigned int mPoolTail;
    //! number of deferred events stored in the pool
    unsigned int mPoolSize;
};

///////////////////////////////////////////////////////////////////////////////
//
// Default implementation for all events.
//
///////////////////////////////////////////////////////////////////////////////

void
FsmState::evReconnect ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evReconnect *** 
}

void
FsmState::evRequestStatusActive ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evRequestStatusActive *** 
}

void
FsmState::evRequestStatusInactive ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evRequestStatusInactive *** 
}

void
FsmState::evReset ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evReset *** 
}

void
FsmState::evStatusUpdate ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evStatusUpdate *** 
}

void
FsmState::evTimeout ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evTimeout *** 
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states components.
//
///////////////////////////////////////////////////////////////////////////////

FsmState::FsmState ( void )
   : mpParent(0)
{}

FsmState::~FsmState ( void )
{
   // make lint happy
   mpParent = 0;
}

void
FsmState::initState ( FsmSuperState* pParent )
{
   mpParent = pParent;
}

void
FsmState::entry ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

void
FsmState::exit ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

const FsmState*
FsmState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.setState(this);
   entry(b,s,pArg);
   return this;
}

FsmSuperState*
FsmState::getParent ( void )
{
   return (mpParent) ? mpParent : 0;
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

FsmSuperState::FsmSuperState ( void )
   : _default(0),
     _history(0),
     _historyEnable(false)
{}

void
FsmSuperState::initSuperState ( FsmSuperState* pParent, FsmState* defState, bool histEnable )
{
   mpParent = pParent;
   _default = defState;
   _history = 0;
   _historyEnable = histEnable;
}

const FsmState*
FsmSuperState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   const FsmState* pState = 0;

   // we have crossed a state boundary
   b.setState(this);
   // execute the entry actions for this superstate
   entry(b,s,pArg);
   
   if ( _history && _historyEnable )
   {
      pState = const_cast<FsmState*>(_history)->propagate(b,s,pArg);
   }
   else
   {
      defaultAction(b,s,pArg);
      if ( _default ) {
         pState = _default->propagate(b,s,pArg);
      }
   }
   
   return pState;
}

void
FsmSuperState::savepoint ( FsmBody& b )
{
   if ( _historyEnable )
   {
      _history = b.getState();
   }
}

void
FsmSuperState::defaultAction ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /*pArg*/ )
{
   //... empty as default ...
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ActivatingState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ActivatingState::ActivatingState ( void )
   : _numDeferredEvents(0)
{
   (void) ::memset(_deferredEvents, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
   (void) ::memset(_deferredParams, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
}

void
ActivatingState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   _numDeferredEvents = 0;

   s.vFsmSendStatusActive(pArg);
}

void
ActivatingState::evRequestStatusActive ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

void
ActivatingState::evReset ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oInitializingState,pArg);
}

void
ActivatingState::evStatusUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isActive(pArg) )
   {
        // trigger deferred events
        while ( !b.isPoolOfDeferredEventsEmpty() )
        {
            FsmEvent defevent = evUnknown;
            void*    defarg   = 0;
            if ( b.getDeferredEvent(defevent,&defarg) )
            {
                b.addEvent(defevent,defarg);
            }
        }
        b.setState(b.oActiveState,pArg);
    } 
    else if ( s.isInactive(pArg) )
   {
        // trigger deferred events
        while ( !b.isPoolOfDeferredEventsEmpty() )
        {
            FsmEvent defevent = evUnknown;
            void*    defarg   = 0;
            if ( b.getDeferredEvent(defevent,&defarg) )
            {
                b.addEvent(defevent,defarg);
            }
        }
        b.setState(b.oInactiveState,pArg);
    }
    else
    {
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oInitializingState,pArg);
    }
}

void
ActivatingState::evRequestStatusInactive( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SCCManagerFSM::evRequestStatusInactive;

   b.addDeferredEvent(event,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ActiveState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ActiveState::ActiveState ( void )
{}

void
ActiveState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmOnActive(pArg);
}

void
ActiveState::evReconnect ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oReconnectingState,pArg);
}

void
ActiveState::evRequestStatusActive ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

void
ActiveState::evRequestStatusInactive ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oDeactivatingState,pArg);
}

void
ActiveState::evReset ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oInitializingState,pArg);
}

void
ActiveState::evStatusUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isActive(pArg) )
   {
        // this is an internal transition
    } 
    else if ( s.isInactive(pArg) && s.isActiveRequested(pArg) )
   {
        b.setState(b.oReconnectingState,pArg);
    } 
    else if ( s.isInactive(pArg) )
   {
        b.setState(b.oInactiveState,pArg);
    }
    else
    {
   b.setState(b.oInitializingState,pArg);
    }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DeactivatingState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

DeactivatingState::DeactivatingState ( void )
   : _numDeferredEvents(0)
{
   (void) ::memset(_deferredEvents, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
   (void) ::memset(_deferredParams, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
}

void
DeactivatingState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   _numDeferredEvents = 0;

   s.vFsmSendStatusInactive(pArg);
}

void
DeactivatingState::evRequestStatusInactive ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

void
DeactivatingState::evReset ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oInitializingState,pArg);
}

void
DeactivatingState::evStatusUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isActive(pArg) )
   {
        // trigger deferred events
        while ( !b.isPoolOfDeferredEventsEmpty() )
        {
            FsmEvent defevent = evUnknown;
            void*    defarg   = 0;
            if ( b.getDeferredEvent(defevent,&defarg) )
            {
                b.addEvent(defevent,defarg);
            }
        }
        b.setState(b.oActiveState,pArg);
    } 
    else if ( s.isInactive(pArg) )
   {
        // trigger deferred events
        while ( !b.isPoolOfDeferredEventsEmpty() )
        {
            FsmEvent defevent = evUnknown;
            void*    defarg   = 0;
            if ( b.getDeferredEvent(defevent,&defarg) )
            {
                b.addEvent(defevent,defarg);
            }
        }
        b.setState(b.oInactiveState,pArg);
    }
    else
    {
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oInitializingState,pArg);
    }
}

void
DeactivatingState::evRequestStatusActive( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_SCCManagerFSM::evRequestStatusActive;

   b.addDeferredEvent(event,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: FinalState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

FinalState::FinalState ( void )
{}

void
FinalState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmFinalize(pArg);
}

void
FinalState::evRequestStatusActive ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

void
FinalState::evRequestStatusInactive ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

void
FinalState::evReset ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

void
FinalState::evStatusUpdate ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: InactiveState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

InactiveState::InactiveState ( void )
{}

void
InactiveState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmOnInactive(pArg);
}

void
InactiveState::evRequestStatusActive ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oActivatingState,pArg);
}

void
InactiveState::evRequestStatusInactive ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

void
InactiveState::evReset ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oInitializingState,pArg);
}

void
InactiveState::evStatusUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isActive(pArg) )
   {
        b.setState(b.oActiveState,pArg);
    } 
    else if ( s.isInactive(pArg) )
   {
        // this is an internal transition
    }
    else
    {
   b.setState(b.oInitializingState,pArg);
    }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: InitializingState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

InitializingState::InitializingState ( void )
{}

void
InitializingState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmOnInitializing(pArg);
}

void
InitializingState::evRequestStatusActive ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oActivatingState,pArg);
}

void
InitializingState::evRequestStatusInactive ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oDeactivatingState,pArg);
}

void
InitializingState::evReset ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oInitializingState,pArg);
}

void
InitializingState::evStatusUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isActive(pArg) )
   {
        b.setState(b.oActiveState,pArg);
    } 
    else if ( s.isInactive(pArg) )
   {
        b.setState(b.oInactiveState,pArg);
    }
    else
    {
   b.setState(b.oInitializingState,pArg);
    }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ReconnectingState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ReconnectingState::ReconnectingState ( void )
{}

void
ReconnectingState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmOnReconnecting(pArg);
   s.vFsmStartReconnection(pArg);
   s.vFsmStartTimer(pArg);
}

void
ReconnectingState::exit ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmStopTimer(pArg);
}

void
ReconnectingState::evRequestStatusActive ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oActivatingState,pArg);
}

void
ReconnectingState::evRequestStatusInactive ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oDeactivatingState,pArg);
}

void
ReconnectingState::evReset ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oInitializingState,pArg);
}

void
ReconnectingState::evStatusUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isActive(pArg) )
   {
        //... performing exit actions ...
        exit(b,s,pArg);
        b.setState(b.oActiveState,pArg);
    }
    else
    {
   // transition Actions
   s.vFsmSendStatusActive(pArg);
   // this is an internal transition
    }
}

void
ReconnectingState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isMaxRetriesReached(pArg) )
   {
        //... performing exit actions ...
        exit(b,s,pArg);
        // transition Actions
        s.vFsmTriggerSystemReset(pArg);
        b.setState(b.oFinalState,pArg);
    }
    else
    {
   // transition Actions
   s.vFsmRetryReconnect(pArg);
   // this is an internal transition
    }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ToplevelState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ToplevelState::ToplevelState ( void )
{}

void
ToplevelState::evRequestStatusActive ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oActivatingState,pArg);
}

void
ToplevelState::evRequestStatusInactive ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oDeactivatingState,pArg);
}

void
ToplevelState::evReset ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oInitializingState,pArg);
}

void
ToplevelState::evStatusUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.isActive(pArg) )
   {
        b.setState(b.oActiveState,pArg);
    } 
    else if ( s.isInactive(pArg) )
   {
        b.setState(b.oInactiveState,pArg);
    }
    else
    {
   b.setState(b.oInitializingState,pArg);
    }
}

///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

Fsm::Fsm ( void )
    : mpBehaviour(0),
      mpBody(0)
{
}

Fsm::Fsm ( FsmBehaviour* server )
    : mpBehaviour(server),
      mpBody(0)
{}

Fsm::~Fsm ( void )
{
    if ( mpBody )
    {
        delete mpBody;
        mpBody = 0;
    }
    mpBehaviour = 0;
}

bool
Fsm::createFSM ( Fsm** ppFSM, FsmBehaviour* behaviour )
{
   bool retCode = false;

   if ( ppFSM && behaviour )
   {
      (*ppFSM) = new Fsm(behaviour);
      if ( (*ppFSM) )
      {
         if ( !((*ppFSM)->init()) )
         {
            delete (*ppFSM);
            (*ppFSM) = 0;
         }
         else
         {
            retCode = true;
         }
      }
   }

   return retCode;
}

bool
Fsm::init ( void )
{
   bool retCode = false;
   
   mpBody = new FsmBody();
   
   if ( mpBody )
   {
      // connect the body with its frontend
      mpBody->connect(this);
      if ( mpBody->init() )
      {
          retCode = true;
      }
   }
   
   return retCode;
}

const char*
Fsm::getStateName (void) const
{
    return ( mpBody ) ? mpBody->getStateName() : 0;
}

void 
Fsm::acceptEvent ( FsmEvent event, void* pArg )
{
    if ( mpBody )
    {
        // forward the event to the FSM body (handle-body pattern)
        mpBody->acceptEvent(event,pArg);
    }
}
///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

FsmBody::FsmBody ( void ) :
      mpFrontend(0),
      mpState(0),
      mBusyFlag(false),
      mQueueHead(0),
      mQueueTail(0),
      mQueueSize(0),
      mPoolHead(0),
      mPoolTail(0),
      mPoolSize(0)
{
    (void) ::memset(mEventQueue,0,sizeof(FsmEvent)*MAX_TRIGGER_EVENTS);
    (void) ::memset(mParamQueue,0,sizeof(void*)*MAX_TRIGGER_EVENTS);
}

bool
FsmBody::init ( void )
{
    oActivatingState.initState(&oToplevelState);
    oActiveState.initState(&oToplevelState);
    oDeactivatingState.initState(&oToplevelState);
    oFinalState.initState(&oToplevelState);
    oInactiveState.initState(&oToplevelState);
    oInitializingState.initState(&oToplevelState);
    oReconnectingState.initState(&oToplevelState);
    oToplevelState.initSuperState(0, &oInitializingState, false);

    setState(oToplevelState,0);
    
    return true;
}

void
FsmBody::connect ( Fsm* frontend )
{
    mpFrontend = frontend;
}

const char*
FsmBody::getStateName ( void ) const
{
    return ( mpState ) ? mpState->getStateName() : 0;
}

bool
FsmBody::addEvent ( const FsmEvent& event, void* param )
{
    if ( mQueueSize < MAX_TRIGGER_EVENTS )
    {
        mQueueSize++;
        mEventQueue[mQueueTail] = event;
        mParamQueue[mQueueTail] = param;
        mQueueTail++;
        if ( mQueueTail == MAX_TRIGGER_EVENTS )
        {
            mQueueTail = 0;
        }
        return true;
    }
    return false;
}

bool
FsmBody::getEvent ( FsmEvent& event, void** param )
{
    if ( !mQueueSize || !param )
    {
        return false;
    }
    mQueueSize--;
    event  = mEventQueue[mQueueHead];
    *param = mParamQueue[mQueueHead];
    mQueueHead++;
    if ( mQueueHead == MAX_TRIGGER_EVENTS )
    {
        mQueueHead = 0;
    }
    return true;
}

bool
FsmBody::isQueueEmpty ( void ) const
{
    return ( mQueueSize ) ? false : true;
}

bool
FsmBody::addDeferredEvent ( const FsmEvent& event, void* arg )
{
    if ( mPoolSize < MAX_DEFERRED_EVENTS )
    {
        mPoolSize++;
        mDeferredEventPool[mPoolTail].mEvent = event;
        mDeferredEventPool[mPoolTail].mArg   = arg;
        mPoolTail++;
        if ( mPoolTail == MAX_DEFERRED_EVENTS )
        {
            mPoolTail = 0;
        }
        return true;
    }
    return false;
}

bool
FsmBody::getDeferredEvent ( FsmEvent& event, void** pArg )
{
    if ( !mPoolSize || !pArg )
    {
        return false;
    }
    mPoolSize--;
    event = mDeferredEventPool[mPoolHead].mEvent;
    *pArg = mDeferredEventPool[mPoolHead].mArg;
    mPoolHead++;
    if ( mPoolHead == MAX_DEFERRED_EVENTS )
    {
        mPoolHead = 0;
    }
    return true;
}

bool
FsmBody::isPoolOfDeferredEventsEmpty ( void ) const
{
    return ( mPoolSize ) ? false : true;
}

void 
FsmBody::acceptEvent ( FsmEvent event, void* pArg )
{
    (void) addEvent(event,pArg);

    if ( mBusyFlag )
    {
        return;
    }

    mBusyFlag = true;
    while ( !isQueueEmpty() )
    {
        FsmEvent nextEvent = evUnknown;
        void*    nextArg   = 0;
        if ( !getEvent(nextEvent,&nextArg) )
        {
            break;
        }

        switch (nextEvent)
        {
        case evReconnect:
            if ( mpState ) mpState->evReconnect(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evRequestStatusActive:
            if ( mpState ) mpState->evRequestStatusActive(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evRequestStatusInactive:
            if ( mpState ) mpState->evRequestStatusInactive(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evReset:
            if ( mpState ) mpState->evReset(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evStatusUpdate:
            if ( mpState ) mpState->evStatusUpdate(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evTimeout:
            if ( mpState ) mpState->evTimeout(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        default:
            //... unknown event ...
            break;
        } //lint !e788: not all items used within defaulted switch
    }
    mBusyFlag = false;
}

void 
FsmBody::setState ( FsmState& state, void* pArg )
{
    if ( mpFrontend )
    {
        mpState = const_cast<FsmState*>(state.propagate(*this,*(mpFrontend->mpBehaviour),pArg));
    }
}

void 
FsmBody::setState ( FsmState* pState )
{
    mpState = pState;
}

const FsmState*
FsmBody::getState ( void ) const
{
    return mpState;
}

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

const char* getEventName ( FsmEvent event )
{
   static const char* eventNames[evCount] = {
      "evUnknown",
      "evReconnect",
      "evRequestStatusActive",
      "evRequestStatusInactive",
      "evReset",
      "evStatusUpdate",
      "evTimeout",
   };

   return eventNames[event];
}


} // namespace
