///////////////////////////////////////////////////////////////////////////////
//
// File: dia_SAFeatureAuthorizationLevelFSM.h
//
// Generated by SMC 4.4.2 (C++ State Pattern Code Generator)
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __INCLUDED_DIA_SAFEATUREAUTHORIZATIONLEVELFSM__
#define __INCLUDED_DIA_SAFEATUREAUTHORIZATIONLEVELFSM__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

namespace dia_SAFeatureAuthorizationLevelFSM
{

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody;

///////////////////////////////////////////////////////////////////////////////
//
// Enums and typedefs
//
///////////////////////////////////////////////////////////////////////////////

//! enumeration of FSM events. First and last item added by SMC
enum FsmEvent
{
   evUnknown = 0,
   evDeviceLock,
   evError,
   evKeyValidated,
   evLevel,
   evLevelChanged,
   evLevelChangeIndication,
   evSeedReceived,
   evStart,
   evStop,
   evTimeout,
   evWarning,
   evCount
};

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

const char* getEventName ( FsmEvent event );

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBehaviour
//
// This is the base class for the FSM server (provides implementation for all
// actions and guards)
//
///////////////////////////////////////////////////////////////////////////////

class FsmBehaviour
{ 
   friend class ActiveState;
   friend class IdleState;
   friend class InitializingState;
   friend class TopLevelState;
   friend class WaitingState;
   friend class FsmBody;

public:
   virtual ~FsmBehaviour ( void ) {}

protected:
   // FSM actions
   virtual void vFsmHandleError ( void* pArg ) = 0;
   virtual void vFsmHandleWarning ( void* pArg ) = 0;
   virtual void vFsmNotifyDeviceLock ( void* pArg ) = 0;
   virtual void vFsmNotifyKeyValidationResult ( void* pArg ) = 0;
   virtual void vFsmNotifyLevel ( void* pArg ) = 0;
   virtual void vFsmNotifyLevelChange ( void* pArg ) = 0;
   virtual void vFsmNotifyLevelChangeIndication ( void* pArg ) = 0;
   virtual void vFsmNotifySeed ( void* pArg ) = 0;
   virtual void vFsmRequestLevel ( void* pArg ) = 0;
   virtual void vFsmReset ( void* pArg ) = 0;
   virtual void vFsmStartInitTimer ( void* pArg ) = 0;
   virtual void vFsmStartMonitoring ( void* pArg ) = 0;
   virtual void vFsmStopInitTimer ( void* pArg ) = 0;
   virtual void vFsmStoreLevel ( void* pArg ) = 0;
   virtual void vStopMonitoring ( void* pArg ) = 0;

};

///////////////////////////////////////////////////////////////////////////////
//
// Class: Fsm
//
// This is the finite state machine class 'dia_SAFeatureAuthorizationLevelFSM'.
//
///////////////////////////////////////////////////////////////////////////////

class Fsm
{
    //! we grant the body class access to our protected section
    friend class FsmBody;

public:
    //! factory method used to create an FAM object in two stages
    static bool createFSM ( Fsm** ppFSM, FsmBehaviour* behaviour );
    //! class destructor
    virtual ~Fsm ( void );

    //! this method is used to stimulate the FSM with events
    virtual void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the current state
    virtual const char* getStateName ( void ) const;

protected:
    //! protected default constructor to avoid usage
    Fsm ( void );
    //! class constructor
    Fsm ( FsmBehaviour* behaviour );
    //! copy constructor without implementation
    Fsm ( const Fsm& obj );
    //! assignment operator without implementation
    Fsm& operator = ( const Fsm& obj );

    //! setup and initialize the state machine
    virtual bool init ( void );

protected:
    //! pointer to the server that provides the implementation for the actions and guards
    FsmBehaviour* mpBehaviour;
    //! body of the FSM implementation
    FsmBody* mpBody;
};


} // namespace

#endif
