///////////////////////////////////////////////////////////////////////////////
//
// File: dia_RoutineCtrlSCCSecuritySettingsFSM.cpp
//
// Generated by SMC 4.4.1 (C++ State Pattern Code Generator)
//
///////////////////////////////////////////////////////////////////////////////

#include <string.h>

#ifndef __INCLUDED_DIA_ROUTINECTRLSCCSECURITYSETTINGSFSM__
#include "dia_RoutineCtrlSCCSecuritySettingsFSM.h"
#endif

namespace dia_RoutineCtrlSCCSecuritySettingsFSM
{

const unsigned int MAX_TRIGGER_EVENTS = 20;

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class Fsm;
class FsmSuperState;

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states.
//
///////////////////////////////////////////////////////////////////////////////

class FsmState
{
public:
   //! name of the FSM's state
   virtual const char* getStateName ( void ) const = 0;

   //! resetting state internals
   virtual void reset ( void ) {}

   // event functions 
   virtual void evGetResults ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReconnected ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evStart ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSystemStateUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTerminated ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUpdateApplicationNotStarted ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUpdateApplicationStarted ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! default implementation for the Entry action
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! default implementation for the Exit action
   virtual void exit  ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! return the parent state
   virtual FsmSuperState* getParent ( void );

   //! assign the body object
   void initState ( FsmSuperState* pParent );

protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmState ( void );
   //! class destructor
   virtual ~FsmState ( void );

   //! pointer to the superstate
   FsmSuperState* mpParent;
};

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

class FsmSuperState
   : public FsmState
{
public:
   //! set a savepoint for the history
   virtual void savepoint ( FsmBody& b );
   //! default action
   virtual void defaultAction ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! resetting state internals
   virtual void reset ( void ) { _history = 0; }

   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! assign the body object
   void initSuperState ( FsmSuperState* pParent, FsmState* defState, bool histEnable=false );

protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmSuperState ( void );

   //! pointer to the default substate
   FsmState* _default;
   //! pointer to the history substate
   const FsmState* _history;
   //! flag that indicates if history is enabled or not
   bool _historyEnable;
};

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DoneState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class DoneState
   : public FsmState
{
public:
   //! default constructor
   DoneState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evGetResults ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* DoneState::mStateName = "Done";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ExecuteState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ExecuteState
   : public FsmSuperState
{
public:
   //! default constructor
   ExecuteState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evGetResults ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* ExecuteState::mStateName = "Execute";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: IdleState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class IdleState
   : public FsmState
{
public:
   //! default constructor
   IdleState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evGetResults ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evStart ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* IdleState::mStateName = "Idle";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: RunningState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class RunningState
   : public FsmState
{
public:
   //! default constructor
   RunningState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evGetResults ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evReconnected ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTerminated ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* RunningState::mStateName = "Running";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SettingSystemStateState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class SettingSystemStateState
   : public FsmState
{
public:
   //! default constructor
   SettingSystemStateState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evGetResults ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSystemStateUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! exit actions
   virtual void exit ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* SettingSystemStateState::mStateName = "SettingSystemState";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: StartingState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class StartingState
   : public FsmState
{
public:
   //! default constructor
   StartingState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evGetResults ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUpdateApplicationNotStarted ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evUpdateApplicationStarted ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* StartingState::mStateName = "Starting";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ToplevelState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ToplevelState
   : public FsmSuperState
{
public:
   //! default constructor
   ToplevelState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evGetResults ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* ToplevelState::mStateName = "Toplevel";

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBody
//
// This is the finite state machine's body class 'FsmBody'.
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody
{
    struct FsmDeferredEvent
    {
          FsmDeferredEvent() : mEvent(evUnknown), mArg(0) {}
          FsmEvent mEvent;
          void*    mArg;
    };

public:
    //! class constructor
    FsmBody ( void );

    //! connect the FSM body with its frontend
    void connect ( Fsm* frontend );

    //! initialize the FSM: set initial state and execute initial actions
    bool init ( void );

    //! this method is used to stimulate the FSM with events
    void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the active state
    const char* getStateName ( void ) const;

    //! push trigger events to the event queue
    bool addEvent ( const FsmEvent& event, void* arg  );
    //! get event from the event queue
    bool getEvent ( FsmEvent& event, void** arg  );
    //! get event from the event queue
    bool isQueueEmpty ( void ) const;

    // set the FSM's internal state and propagate to default or history substate
    void setState ( FsmState& state, void* pArg );
    // set the FSM's internal state (no propagation
    void setState ( FsmState* pState );
    // return the active state object
    const FsmState* getState ( void ) const;

    //! static state objects
    DoneState oDoneState;
    ExecuteState oExecuteState;
    IdleState oIdleState;
    RunningState oRunningState;
    SettingSystemStateState oSettingSystemStateState;
    StartingState oStartingState;
    ToplevelState oToplevelState;

    //! frontend for this body
    Fsm* mpFrontend;
    //! link to the active state object
    FsmState* mpState;

    //! busy indicator flag
    bool mBusyFlag;

    //! queue of trigger events
    FsmEvent mEventQueue[MAX_TRIGGER_EVENTS];
    //! queue of arguments for trigger events
    void*    mParamQueue[MAX_TRIGGER_EVENTS];
    //! index of the queue's front element
    unsigned int mQueueHead;
    //! index of the queue's back element
    unsigned int mQueueTail;
    //! number of queued events
    unsigned int mQueueSize;
};

///////////////////////////////////////////////////////////////////////////////
//
// Default implementation for all events.
//
///////////////////////////////////////////////////////////////////////////////

void
FsmState::evGetResults ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evGetResults *** 
}

void
FsmState::evIdle ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evIdle *** 
}

void
FsmState::evReconnected ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evReconnected *** 
}

void
FsmState::evStart ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evStart *** 
}

void
FsmState::evSystemStateUpdate ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evSystemStateUpdate *** 
}

void
FsmState::evTerminated ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evTerminated *** 
}

void
FsmState::evTimeout ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evTimeout *** 
}

void
FsmState::evUpdateApplicationNotStarted ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evUpdateApplicationNotStarted *** 
}

void
FsmState::evUpdateApplicationStarted ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evUpdateApplicationStarted *** 
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states components.
//
///////////////////////////////////////////////////////////////////////////////

FsmState::FsmState ( void )
   : mpParent(0)
{}

FsmState::~FsmState ( void )
{
   // make lint happy
   mpParent = 0;
}

void
FsmState::initState ( FsmSuperState* pParent )
{
   mpParent = pParent;
}

void
FsmState::entry ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

void
FsmState::exit ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

const FsmState*
FsmState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.setState(this);
   entry(b,s,pArg);
   return this;
}

FsmSuperState*
FsmState::getParent ( void )
{
   return (mpParent) ? mpParent : 0;
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

FsmSuperState::FsmSuperState ( void )
   : _default(0),
     _history(0),
     _historyEnable(false)
{}

void
FsmSuperState::initSuperState ( FsmSuperState* pParent, FsmState* defState, bool histEnable )
{
   mpParent = pParent;
   _default = defState;
   _history = 0;
   _historyEnable = histEnable;
}

const FsmState*
FsmSuperState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   const FsmState* pState = 0;

   // we have crossed a state boundary
   b.setState(this);
   // execute the entry actions for this superstate
   entry(b,s,pArg);
   
   if ( _history && _historyEnable )
   {
      pState = const_cast<FsmState*>(_history)->propagate(b,s,pArg);
   }
   else
   {
      defaultAction(b,s,pArg);
      if ( _default ) {
         pState = _default->propagate(b,s,pArg);
      }
   }
   
   return pState;
}

void
FsmSuperState::savepoint ( FsmBody& b )
{
   if ( _historyEnable )
   {
      _history = b.getState();
   }
}

void
FsmSuperState::defaultAction ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /*pArg*/ )
{
   //... empty as default ...
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: DoneState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

DoneState::DoneState ( void )
{}

void
DoneState::evGetResults ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmCollectResults(pArg);
   s.vFsmSendResponse(pArg);
   // this is an internal transition
}

void
DoneState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oIdleState,pArg);
}

void
DoneState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSetError_Timeout(pArg);
   s.vFsmSendResponse(pArg);
   b.setState(b.oIdleState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ExecuteState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ExecuteState::ExecuteState ( void )
{}

void
ExecuteState::evGetResults ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSetResultsNotAvailable(pArg);
   s.vFsmSendResponse(pArg);
   // this is an internal transition
}

void
ExecuteState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oIdleState,pArg);
}

void
ExecuteState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSetError_Timeout(pArg);
   s.vFsmSendResponse(pArg);
   b.setState(b.oIdleState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: IdleState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

IdleState::IdleState ( void )
{}

void
IdleState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmReset(pArg);
}

void
IdleState::evGetResults ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSetResultsNotAvailable(pArg);
   s.vFsmSendResponse(pArg);
   // this is an internal transition
}

void
IdleState::evIdle ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

void
IdleState::evStart ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oSettingSystemStateState,pArg);
}

void
IdleState::evTimeout ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: RunningState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

RunningState::RunningState ( void )
{}

void
RunningState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmSetResultRunning(pArg);
   s.vFsmSendResponse(pArg);
   s.vFsmStartReconnection(pArg);
}

void
RunningState::evGetResults ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmIsRunning(pArg) )
   {
        // transition Actions
        s.vFsmSetResultsInProgress(pArg);
        s.vFsmSendResponse(pArg);
        // this is an internal transition
    }
    else
    {
   // transition Actions
   s.vFsmCollectResults(pArg);
   s.vFsmSendResponse(pArg);
   // this is an internal transition
    }
}

void
RunningState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oIdleState,pArg);
}

void
RunningState::evReconnected ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oDoneState,pArg);
}

void
RunningState::evTerminated ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmEvaluateResults(pArg);
   b.setState(b.oDoneState,pArg);
}

void
RunningState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSetError_Timeout(pArg);
   s.vFsmSendResponse(pArg);
   b.setState(b.oIdleState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SettingSystemStateState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

SettingSystemStateState::SettingSystemStateState ( void )
{}

void
SettingSystemStateState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmGetSystemState(pArg);
}

void
SettingSystemStateState::exit ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmFinalizeSystemStateSetting(pArg);
}

void
SettingSystemStateState::evGetResults ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSetResultsNotAvailable(pArg);
   s.vFsmSendResponse(pArg);
   // this is an internal transition
}

void
SettingSystemStateState::evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oIdleState,pArg);
}

void
SettingSystemStateState::evSystemStateUpdate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmIsRequiredSystemState(pArg) )
   {
        //... performing exit actions ...
        exit(b,s,pArg);
        b.setState(b.oExecuteState,pArg);
    } 
    else if ( s.bFsmNeedToRequestSystemState(pArg) )
   {
        // transition Actions
        s.vFsmRequestSystemState(pArg);
        // this is an internal transition
    }
    else
    {
   // this is an internal transition
    }
}

void
SettingSystemStateState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   // transition Actions
   s.vFsmSetError_Timeout(pArg);
   s.vFsmSendResponse(pArg);
   b.setState(b.oIdleState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: StartingState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

StartingState::StartingState ( void )
{}

void
StartingState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmStartUpdateApplication(pArg);
}

void
StartingState::evGetResults ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSetResultsNotAvailable(pArg);
   s.vFsmSendResponse(pArg);
   // this is an internal transition
}

void
StartingState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oIdleState,pArg);
}

void
StartingState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSetError_Timeout(pArg);
   s.vFsmSendResponse(pArg);
   b.setState(b.oIdleState,pArg);
}

void
StartingState::evUpdateApplicationNotStarted ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSetError_AppStartFailed(pArg);
   s.vFsmSendResponse(pArg);
   b.setState(b.oIdleState,pArg);
}

void
StartingState::evUpdateApplicationStarted ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oRunningState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ToplevelState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ToplevelState::ToplevelState ( void )
{}

void
ToplevelState::evGetResults ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSetResultsNotAvailable(pArg);
   s.vFsmSendResponse(pArg);
   // this is an internal transition
}

void
ToplevelState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oIdleState,pArg);
}

void
ToplevelState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSetError_Timeout(pArg);
   s.vFsmSendResponse(pArg);
   b.setState(b.oIdleState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

Fsm::Fsm ( void )
    : mpBehaviour(0),
      mpBody(0)
{
}

Fsm::Fsm ( FsmBehaviour* server )
    : mpBehaviour(server),
      mpBody(0)
{}

Fsm::~Fsm ( void )
{
    if ( mpBody )
    {
        delete mpBody;
        mpBody = 0;
    }
    mpBehaviour = 0;
}

bool
Fsm::createFSM ( Fsm** ppFSM, FsmBehaviour* behaviour )
{
   bool retCode = false;

   if ( ppFSM && behaviour )
   {
      (*ppFSM) = new Fsm(behaviour);
      if ( (*ppFSM) )
      {
         if ( !((*ppFSM)->init()) )
         {
            delete (*ppFSM);
            (*ppFSM) = 0;
         }
         else
         {
            retCode = true;
         }
      }
   }

   return retCode;
}

bool
Fsm::init ( void )
{
   bool retCode = false;
   
   mpBody = new FsmBody();
   
   if ( mpBody )
   {
      // connect the body with its frontend
      mpBody->connect(this);
      if ( mpBody->init() )
      {
          retCode = true;
      }
   }
   
   return retCode;
}

const char*
Fsm::getStateName (void) const
{
    return ( mpBody ) ? mpBody->getStateName() : 0;
}

void 
Fsm::acceptEvent ( FsmEvent event, void* pArg )
{
    if ( mpBody )
    {
        // forward the event to the FSM body (handle-body pattern)
        mpBody->acceptEvent(event,pArg);
    }
}
///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

FsmBody::FsmBody ( void ) :
      mpFrontend(0),
      mpState(0),
      mBusyFlag(false),
      mQueueHead(0),
      mQueueTail(0),
      mQueueSize(0)
{
    (void) ::memset(mEventQueue,0,sizeof(FsmEvent)*MAX_TRIGGER_EVENTS);
    (void) ::memset(mParamQueue,0,sizeof(void*)*MAX_TRIGGER_EVENTS);
}

bool
FsmBody::init ( void )
{
    oDoneState.initState(&oToplevelState);
    oExecuteState.initSuperState(&oToplevelState, &oStartingState, false);
    oIdleState.initState(&oToplevelState);
    oRunningState.initState(&oExecuteState);
    oSettingSystemStateState.initState(&oToplevelState);
    oStartingState.initState(&oExecuteState);
    oToplevelState.initSuperState(0, &oIdleState, false);

    setState(oToplevelState,0);
    
    return true;
}

void
FsmBody::connect ( Fsm* frontend )
{
    mpFrontend = frontend;
}

const char*
FsmBody::getStateName ( void ) const
{
    return ( mpState ) ? mpState->getStateName() : 0;
}

bool
FsmBody::addEvent ( const FsmEvent& event, void* param )
{
    if ( mQueueSize < MAX_TRIGGER_EVENTS )
    {
        mQueueSize++;
        mEventQueue[mQueueTail] = event;
        mParamQueue[mQueueTail] = param;
        mQueueTail++;
        if ( mQueueTail == MAX_TRIGGER_EVENTS )
        {
            mQueueTail = 0;
        }
        return true;
    }
    return false;
}

bool
FsmBody::getEvent ( FsmEvent& event, void** param )
{
    if ( !mQueueSize || !param )
    {
        return false;
    }
    mQueueSize--;
    event  = mEventQueue[mQueueHead];
    *param = mParamQueue[mQueueHead];
    mQueueHead++;
    if ( mQueueHead == MAX_TRIGGER_EVENTS )
    {
        mQueueHead = 0;
    }
    return true;
}

bool
FsmBody::isQueueEmpty ( void ) const
{
    return ( mQueueSize ) ? false : true;
}

void 
FsmBody::acceptEvent ( FsmEvent event, void* pArg )
{
    (void) addEvent(event,pArg);

    if ( mBusyFlag )
    {
        return;
    }

    mBusyFlag = true;
    while ( !isQueueEmpty() )
    {
        FsmEvent nextEvent = evUnknown;
        void*    nextArg   = 0;
        if ( !getEvent(nextEvent,&nextArg) )
        {
            break;
        }

        switch (nextEvent)
        {
        case evGetResults:
            if ( mpState ) mpState->evGetResults(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evIdle:
            if ( mpState ) mpState->evIdle(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evReconnected:
            if ( mpState ) mpState->evReconnected(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evStart:
            if ( mpState ) mpState->evStart(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evSystemStateUpdate:
            if ( mpState ) mpState->evSystemStateUpdate(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evTerminated:
            if ( mpState ) mpState->evTerminated(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evTimeout:
            if ( mpState ) mpState->evTimeout(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evUpdateApplicationNotStarted:
            if ( mpState ) mpState->evUpdateApplicationNotStarted(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evUpdateApplicationStarted:
            if ( mpState ) mpState->evUpdateApplicationStarted(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        default:
            //... unknown event ...
            break;
        } //lint !e788: not all items used within defaulted switch
    }
    mBusyFlag = false;
}

void 
FsmBody::setState ( FsmState& state, void* pArg )
{
    if ( mpFrontend )
    {
        mpState = const_cast<FsmState*>(state.propagate(*this,*(mpFrontend->mpBehaviour),pArg));
    }
}

void 
FsmBody::setState ( FsmState* pState )
{
    mpState = pState;
}

const FsmState*
FsmBody::getState ( void ) const
{
    return mpState;
}

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

const char* getEventName ( FsmEvent event )
{
   static const char* eventNames[evCount] = {
      "evUnknown",
      "evGetResults",
      "evIdle",
      "evReconnected",
      "evStart",
      "evSystemStateUpdate",
      "evTerminated",
      "evTimeout",
      "evUpdateApplicationNotStarted",
      "evUpdateApplicationStarted",
   };

   return eventNames[event];
}


} // namespace
