///////////////////////////////////////////////////////////////////////////////
//
// File: dia_RoutineCtrlManagerFSM.cpp
//
// Generated by SMC 4.4.1 (C++ State Pattern Code Generator)
//
///////////////////////////////////////////////////////////////////////////////

#include <string.h>

#ifndef __INCLUDED_DIA_ROUTINECTRLMANAGERFSM__
#include "dia_RoutineCtrlManagerFSM.h"
#endif

namespace dia_RoutineCtrlManagerFSM
{

const unsigned int MAX_TRIGGER_EVENTS = 20;

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class Fsm;
class FsmSuperState;

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states.
//
///////////////////////////////////////////////////////////////////////////////

class FsmState
{
public:
   //! name of the FSM's state
   virtual const char* getStateName ( void ) const = 0;

   //! resetting state internals
   virtual void reset ( void ) {}

   // event functions 
   virtual void evCheckRoutines ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNoRoutineActive ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRoutineActivated ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRoutineDeactivated ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTerminateAllRoutines ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! default implementation for the Entry action
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! default implementation for the Exit action
   virtual void exit  ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! return the parent state
   virtual FsmSuperState* getParent ( void );

   //! assign the body object
   void initState ( FsmSuperState* pParent );

protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmState ( void );
   //! class destructor
   virtual ~FsmState ( void );

   //! pointer to the superstate
   FsmSuperState* mpParent;
};

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

class FsmSuperState
   : public FsmState
{
public:
   //! set a savepoint for the history
   virtual void savepoint ( FsmBody& b );
   //! default action
   virtual void defaultAction ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! resetting state internals
   virtual void reset ( void ) { _history = 0; }

   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! assign the body object
   void initSuperState ( FsmSuperState* pParent, FsmState* defState, bool histEnable=false );

protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmSuperState ( void );

   //! pointer to the default substate
   FsmState* _default;
   //! pointer to the history substate
   const FsmState* _history;
   //! flag that indicates if history is enabled or not
   bool _historyEnable;
};

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ActiveIdleState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ActiveIdleState
   : public FsmState
{
public:
   //! default constructor
   ActiveIdleState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evCheckRoutines ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNoRoutineActive ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRoutineActivated ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRoutineDeactivated ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTerminateAllRoutines ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* ActiveIdleState::mStateName = "ActiveIdle";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: IdleState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class IdleState
   : public FsmState
{
public:
   //! default constructor
   IdleState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNoRoutineActive ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRoutineActivated ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* IdleState::mStateName = "Idle";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: RoutinesActiveState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class RoutinesActiveState
   : public FsmSuperState
{
public:
   //! default constructor
   RoutinesActiveState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNoRoutineActive ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRoutineDeactivated ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* RoutinesActiveState::mStateName = "RoutinesActive";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: TerminateRoutinesState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class TerminateRoutinesState
   : public FsmState
{
public:
   //! default constructor
   TerminateRoutinesState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evCheckRoutines ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNoRoutineActive ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRoutineDeactivated ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* TerminateRoutinesState::mStateName = "TerminateRoutines";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ToplevelState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ToplevelState
   : public FsmSuperState
{
public:
   //! default constructor
   ToplevelState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNoRoutineActive ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* ToplevelState::mStateName = "Toplevel";

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBody
//
// This is the finite state machine's body class 'FsmBody'.
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody
{
    struct FsmDeferredEvent
    {
          FsmDeferredEvent() : mEvent(evUnknown), mArg(0) {}
          FsmEvent mEvent;
          void*    mArg;
    };

public:
    //! class constructor
    FsmBody ( void );

    //! connect the FSM body with its frontend
    void connect ( Fsm* frontend );

    //! initialize the FSM: set initial state and execute initial actions
    bool init ( void );

    //! this method is used to stimulate the FSM with events
    void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the active state
    const char* getStateName ( void ) const;

    //! push trigger events to the event queue
    bool addEvent ( const FsmEvent& event, void* arg  );
    //! get event from the event queue
    bool getEvent ( FsmEvent& event, void** arg  );
    //! get event from the event queue
    bool isQueueEmpty ( void ) const;

    // set the FSM's internal state and propagate to default or history substate
    void setState ( FsmState& state, void* pArg );
    // set the FSM's internal state (no propagation
    void setState ( FsmState* pState );
    // return the active state object
    const FsmState* getState ( void ) const;

    //! static state objects
    ActiveIdleState oActiveIdleState;
    IdleState oIdleState;
    RoutinesActiveState oRoutinesActiveState;
    TerminateRoutinesState oTerminateRoutinesState;
    ToplevelState oToplevelState;

    //! frontend for this body
    Fsm* mpFrontend;
    //! link to the active state object
    FsmState* mpState;

    //! busy indicator flag
    bool mBusyFlag;

    //! queue of trigger events
    FsmEvent mEventQueue[MAX_TRIGGER_EVENTS];
    //! queue of arguments for trigger events
    void*    mParamQueue[MAX_TRIGGER_EVENTS];
    //! index of the queue's front element
    unsigned int mQueueHead;
    //! index of the queue's back element
    unsigned int mQueueTail;
    //! number of queued events
    unsigned int mQueueSize;
};

///////////////////////////////////////////////////////////////////////////////
//
// Default implementation for all events.
//
///////////////////////////////////////////////////////////////////////////////

void
FsmState::evCheckRoutines ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evCheckRoutines *** 
}

void
FsmState::evIdle ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evIdle *** 
}

void
FsmState::evNoRoutineActive ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evNoRoutineActive *** 
}

void
FsmState::evRoutineActivated ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evRoutineActivated *** 
}

void
FsmState::evRoutineDeactivated ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evRoutineDeactivated *** 
}

void
FsmState::evTerminateAllRoutines ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evTerminateAllRoutines *** 
}

void
FsmState::evTimeout ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evTimeout *** 
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states components.
//
///////////////////////////////////////////////////////////////////////////////

FsmState::FsmState ( void )
   : mpParent(0)
{}

FsmState::~FsmState ( void )
{
   // make lint happy
   mpParent = 0;
}

void
FsmState::initState ( FsmSuperState* pParent )
{
   mpParent = pParent;
}

void
FsmState::entry ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

void
FsmState::exit ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

const FsmState*
FsmState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.setState(this);
   entry(b,s,pArg);
   return this;
}

FsmSuperState*
FsmState::getParent ( void )
{
   return (mpParent) ? mpParent : 0;
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

FsmSuperState::FsmSuperState ( void )
   : _default(0),
     _history(0),
     _historyEnable(false)
{}

void
FsmSuperState::initSuperState ( FsmSuperState* pParent, FsmState* defState, bool histEnable )
{
   mpParent = pParent;
   _default = defState;
   _history = 0;
   _historyEnable = histEnable;
}

const FsmState*
FsmSuperState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   const FsmState* pState = 0;

   // we have crossed a state boundary
   b.setState(this);
   // execute the entry actions for this superstate
   entry(b,s,pArg);
   
   if ( _history && _historyEnable )
   {
      pState = const_cast<FsmState*>(_history)->propagate(b,s,pArg);
   }
   else
   {
      defaultAction(b,s,pArg);
      if ( _default ) {
         pState = _default->propagate(b,s,pArg);
      }
   }
   
   return pState;
}

void
FsmSuperState::savepoint ( FsmBody& b )
{
   if ( _historyEnable )
   {
      _history = b.getState();
   }
}

void
FsmSuperState::defaultAction ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /*pArg*/ )
{
   //... empty as default ...
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ActiveIdleState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ActiveIdleState::ActiveIdleState ( void )
{}

void
ActiveIdleState::evCheckRoutines ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmIsNoRoutineActive(pArg) )
   {
        // trigger events
        FsmEvent event = dia_RoutineCtrlManagerFSM::evUnknown;

        event = dia_RoutineCtrlManagerFSM::evNoRoutineActive; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        // this is an internal transition
    }
}

void
ActiveIdleState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oIdleState,pArg);
}

void
ActiveIdleState::evNoRoutineActive ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oIdleState,pArg);
}

void
ActiveIdleState::evRoutineActivated ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmAddRoutine(pArg);
   // this is an internal transition
}

void
ActiveIdleState::evRoutineDeactivated ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmRemoveRoutine(pArg);
   // trigger events
   FsmEvent event = dia_RoutineCtrlManagerFSM::evUnknown;

   event = dia_RoutineCtrlManagerFSM::evCheckRoutines; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
ActiveIdleState::evTerminateAllRoutines ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oTerminateRoutinesState,pArg);
}

void
ActiveIdleState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmHandleTimeout(pArg);
   b.setState(b.oIdleState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: IdleState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

IdleState::IdleState ( void )
{}

void
IdleState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmReset(pArg);
}

void
IdleState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oIdleState,pArg);
}

void
IdleState::evNoRoutineActive ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oIdleState,pArg);
}

void
IdleState::evRoutineActivated ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmAddRoutine(pArg);
   b.setState(b.oRoutinesActiveState,pArg);
}

void
IdleState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmHandleTimeout(pArg);
   b.setState(b.oIdleState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: RoutinesActiveState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

RoutinesActiveState::RoutinesActiveState ( void )
{}

void
RoutinesActiveState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oIdleState,pArg);
}

void
RoutinesActiveState::evNoRoutineActive ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oIdleState,pArg);
}

void
RoutinesActiveState::evRoutineDeactivated ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmRemoveRoutine(pArg);
   // trigger events
   FsmEvent event = dia_RoutineCtrlManagerFSM::evUnknown;

   event = dia_RoutineCtrlManagerFSM::evCheckRoutines; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
RoutinesActiveState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmHandleTimeout(pArg);
   b.setState(b.oIdleState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: TerminateRoutinesState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

TerminateRoutinesState::TerminateRoutinesState ( void )
{}

void
TerminateRoutinesState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmCollectRoutines(pArg);
   s.vFsmStopNextRoutine(pArg);
}

void
TerminateRoutinesState::evCheckRoutines ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmIsNoRoutineActive(pArg) )
   {
        // trigger events
        FsmEvent event = dia_RoutineCtrlManagerFSM::evUnknown;

        event = dia_RoutineCtrlManagerFSM::evNoRoutineActive; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        // this is an internal transition
    }
    else
    {
   // transition Actions
   s.vFsmStopNextRoutine(pArg);
   // this is an internal transition
    }
}

void
TerminateRoutinesState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oIdleState,pArg);
}

void
TerminateRoutinesState::evNoRoutineActive ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oIdleState,pArg);
}

void
TerminateRoutinesState::evRoutineDeactivated ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmRemoveRoutine(pArg);
   // trigger events
   FsmEvent event = dia_RoutineCtrlManagerFSM::evUnknown;

   event = dia_RoutineCtrlManagerFSM::evCheckRoutines; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
TerminateRoutinesState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmHandleTimeout(pArg);
   b.setState(b.oIdleState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ToplevelState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ToplevelState::ToplevelState ( void )
{}

void
ToplevelState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oIdleState,pArg);
}

void
ToplevelState::evNoRoutineActive ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oIdleState,pArg);
}

void
ToplevelState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmHandleTimeout(pArg);
   b.setState(b.oIdleState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

Fsm::Fsm ( void )
    : mpBehaviour(0),
      mpBody(0)
{
}

Fsm::Fsm ( FsmBehaviour* server )
    : mpBehaviour(server),
      mpBody(0)
{}

Fsm::~Fsm ( void )
{
    if ( mpBody )
    {
        delete mpBody;
        mpBody = 0;
    }
    mpBehaviour = 0;
}

bool
Fsm::createFSM ( Fsm** ppFSM, FsmBehaviour* behaviour )
{
   bool retCode = false;

   if ( ppFSM && behaviour )
   {
      (*ppFSM) = new Fsm(behaviour);
      if ( (*ppFSM) )
      {
         if ( !((*ppFSM)->init()) )
         {
            delete (*ppFSM);
            (*ppFSM) = 0;
         }
         else
         {
            retCode = true;
         }
      }
   }

   return retCode;
}

bool
Fsm::init ( void )
{
   bool retCode = false;
   
   mpBody = new FsmBody();
   
   if ( mpBody )
   {
      // connect the body with its frontend
      mpBody->connect(this);
      if ( mpBody->init() )
      {
          retCode = true;
      }
   }
   
   return retCode;
}

const char*
Fsm::getStateName (void) const
{
    return ( mpBody ) ? mpBody->getStateName() : 0;
}

void 
Fsm::acceptEvent ( FsmEvent event, void* pArg )
{
    if ( mpBody )
    {
        // forward the event to the FSM body (handle-body pattern)
        mpBody->acceptEvent(event,pArg);
    }
}
///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

FsmBody::FsmBody ( void ) :
      mpFrontend(0),
      mpState(0),
      mBusyFlag(false),
      mQueueHead(0),
      mQueueTail(0),
      mQueueSize(0)
{
    (void) ::memset(mEventQueue,0,sizeof(FsmEvent)*MAX_TRIGGER_EVENTS);
    (void) ::memset(mParamQueue,0,sizeof(void*)*MAX_TRIGGER_EVENTS);
}

bool
FsmBody::init ( void )
{
    oActiveIdleState.initState(&oRoutinesActiveState);
    oIdleState.initState(&oToplevelState);
    oRoutinesActiveState.initSuperState(&oToplevelState, &oActiveIdleState, false);
    oTerminateRoutinesState.initState(&oRoutinesActiveState);
    oToplevelState.initSuperState(0, &oIdleState, false);

    setState(oToplevelState,0);
    
    return true;
}

void
FsmBody::connect ( Fsm* frontend )
{
    mpFrontend = frontend;
}

const char*
FsmBody::getStateName ( void ) const
{
    return ( mpState ) ? mpState->getStateName() : 0;
}

bool
FsmBody::addEvent ( const FsmEvent& event, void* param )
{
    if ( mQueueSize < MAX_TRIGGER_EVENTS )
    {
        mQueueSize++;
        mEventQueue[mQueueTail] = event;
        mParamQueue[mQueueTail] = param;
        mQueueTail++;
        if ( mQueueTail == MAX_TRIGGER_EVENTS )
        {
            mQueueTail = 0;
        }
        return true;
    }
    return false;
}

bool
FsmBody::getEvent ( FsmEvent& event, void** param )
{
    if ( !mQueueSize || !param )
    {
        return false;
    }
    mQueueSize--;
    event  = mEventQueue[mQueueHead];
    *param = mParamQueue[mQueueHead];
    mQueueHead++;
    if ( mQueueHead == MAX_TRIGGER_EVENTS )
    {
        mQueueHead = 0;
    }
    return true;
}

bool
FsmBody::isQueueEmpty ( void ) const
{
    return ( mQueueSize ) ? false : true;
}

void 
FsmBody::acceptEvent ( FsmEvent event, void* pArg )
{
    (void) addEvent(event,pArg);

    if ( mBusyFlag )
    {
        return;
    }

    mBusyFlag = true;
    while ( !isQueueEmpty() )
    {
        FsmEvent nextEvent = evUnknown;
        void*    nextArg   = 0;
        if ( !getEvent(nextEvent,&nextArg) )
        {
            break;
        }

        switch (nextEvent)
        {
        case evCheckRoutines:
            if ( mpState ) mpState->evCheckRoutines(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evIdle:
            if ( mpState ) mpState->evIdle(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evNoRoutineActive:
            if ( mpState ) mpState->evNoRoutineActive(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evRoutineActivated:
            if ( mpState ) mpState->evRoutineActivated(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evRoutineDeactivated:
            if ( mpState ) mpState->evRoutineDeactivated(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evTerminateAllRoutines:
            if ( mpState ) mpState->evTerminateAllRoutines(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evTimeout:
            if ( mpState ) mpState->evTimeout(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        default:
            //... unknown event ...
            break;
        } //lint !e788: not all items used within defaulted switch
    }
    mBusyFlag = false;
}

void 
FsmBody::setState ( FsmState& state, void* pArg )
{
    if ( mpFrontend )
    {
        mpState = const_cast<FsmState*>(state.propagate(*this,*(mpFrontend->mpBehaviour),pArg));
    }
}

void 
FsmBody::setState ( FsmState* pState )
{
    mpState = pState;
}

const FsmState*
FsmBody::getState ( void ) const
{
    return mpState;
}

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

const char* getEventName ( FsmEvent event )
{
   static const char* eventNames[evCount] = {
      "evUnknown",
      "evCheckRoutines",
      "evIdle",
      "evNoRoutineActive",
      "evRoutineActivated",
      "evRoutineDeactivated",
      "evTerminateAllRoutines",
      "evTimeout",
   };

   return eventNames[event];
}


} // namespace
