///////////////////////////////////////////////////////////////////////////////
//
// File: dia_RemoteControlFSM.h
//
// Generated by SMC 4.5.1 (C++ State Pattern Code Generator)
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __INCLUDED_DIA_REMOTECONTROLFSM__
#define __INCLUDED_DIA_REMOTECONTROLFSM__

namespace dia_RemoteControlFSM
{

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody;

///////////////////////////////////////////////////////////////////////////////
//
// Enums and typedefs
//
///////////////////////////////////////////////////////////////////////////////

//! enumeration of FSM events. First and last item added by SMC
enum FsmEvent
{
   evUnknown = 0,
   evCheckCompletion,
   evResponseReceived,
   evStart,
   evStop,
   evTimeout,
   evCount
};

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

const char* getEventName ( FsmEvent event );

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBehaviour
//
// This is the base class for the FSM server (provides implementation for all
// actions and guards)
//
///////////////////////////////////////////////////////////////////////////////

class FsmBehaviour
{
   friend class ActivatingState;
   friend class ActiveState;
   friend class DeactivatingState;
   friend class IdleState;
   friend class TopLevelState;
   friend class FsmBody;

public:
   virtual ~FsmBehaviour ( void ) {}

protected:
   // FSM actions
   virtual void vFsmActivatePlugin ( void* pArg ) = 0;
   virtual void vFsmDeactivatePlugin ( void* pArg ) = 0;
   virtual void vFsmEvaluateResponse ( void* pArg ) = 0;
   virtual void vFsmNotify ( void* pArg ) = 0;
   virtual void vFsmPrepare ( void* pArg ) = 0;
   virtual void vFsmPrepareDeactivation ( void* pArg ) = 0;
   virtual void vFsmReset ( void* pArg ) = 0;
   virtual void vFsmResultReady ( void* pArg ) = 0;
   virtual void vFsmSetActivatedPlugin ( void* pArg ) = 0;
   virtual void vFsmSetErrCode_OK ( void* pArg ) = 0;
   virtual void vFsmSetErrCode_Timeout ( void* pArg ) = 0;
   virtual void vFsmSetModeOFF ( void* pArg ) = 0;
   virtual void vFsmSetModeON ( void* pArg ) = 0;
   virtual void vFsmSetNextDeactivationPlugin ( void* pArg ) = 0;
   virtual void vFsmSetNextPlugin ( void* pArg ) = 0;

   // FSM guards
   virtual bool bIsActivationComplete ( void* pArg ) = 0;
   virtual bool bIsActivationFailed ( void* pArg ) = 0;
   virtual bool bIsDeactivationComplete ( void* pArg ) = 0;
};

///////////////////////////////////////////////////////////////////////////////
//
// Class: Fsm
//
// This is the finite state machine class 'dia_RemoteControlFSM'.
//
///////////////////////////////////////////////////////////////////////////////

class Fsm
{
    //! we grant the body class access to our protected section
    friend class FsmBody;

public:
    //! factory method used to create an FAM object in two stages
    static bool createFSM ( Fsm** ppFSM, FsmBehaviour* behaviour );
    //! class destructor
    virtual ~Fsm ( void );

    //! this method is used to stimulate the FSM with events
    virtual void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the current state
    virtual const char* getStateName ( void ) const;

protected:
    //! protected default constructor to avoid usage
    Fsm ( void );
    //! class constructor
    Fsm ( FsmBehaviour* behaviour );
    //! copy constructor without implementation
    Fsm ( const Fsm& obj );
    //! assignment operator without implementation
    Fsm& operator = ( const Fsm& obj );

    //! setup and initialize the state machine
    virtual bool init ( void );

protected:
    //! pointer to the server that provides the implementation for the actions and guards
    FsmBehaviour* mpBehaviour;
    //! body of the FSM implementation
    FsmBody* mpBody;
};


} // namespace

#endif
